/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.channels;

import cn.com.infosec.netsign.base.CRLUpdater;
import cn.com.infosec.netsign.base.Channel;
import cn.com.infosec.netsign.base.NetSignX509Certificate;
import cn.com.infosec.netsign.base.channels.BasicChannel;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.base.util.TrustConfig;
import cn.com.infosec.netsign.base.util.TrustConfigMap;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.Key;
import cn.com.infosec.netsign.frame.config.PDFSignConfig;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.frame.config.ServiceConfig;
import cn.com.infosec.netsign.frame.config.TrustField;
import cn.com.infosec.netsign.frame.util.PBCUtil;
import cn.com.infosec.netsign.logger.AbstractLogger;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.logger.LoggerException;
import cn.com.infosec.netsign.manager.JKSManager;
import cn.com.infosec.netsign.manager.LogManager;
import cn.com.infosec.netsign.resources.ResourceList;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.swxa.SWXAUtil;
import com.itextpdf.text.Image;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ServerChannel
implements Channel {
    private BasicChannel channel;
    private ServiceConfig config = null;
    private Service service = null;
    private boolean usedHardware = true;
    private boolean cryptoCommunicate = true;
    private cn.com.infosec.netsign.base.processors.util.CryptoUtil cryptoUtil = null;
    private List updaters = null;
    private TrustConfigMap trustConfigs = null;
    private Map signKeyStores = null;
    private Map signKeySNDNMap = null;
    private String defaultCertDN = null;
    private Map envelopeCerts = null;
    private String defaultEnvelopeCertDN = null;
    private String defaultDigestAlg = "SHA1";
    private String defaultSymmetricalAlg = "RC4";
    private AbstractLogger accessLogger = null;
    private AbstractLogger debugLogger = null;
    private boolean checkAuth = false;
    private List authList = null;
    private boolean checkValidity;
    private String logLevel = "INFO";
    private Image pdfImage;
    private ResourcePool rp;

    public ResourcePool getResourcePool() {
        return this.rp;
    }

    public Service getService() {
        return this.service;
    }

    private void initResourcePool() throws ChannelException {
        ArrayList rns = this.service.getResourceNames();
        if (rns != null && rns.size() > 0) {
            this.rp = new ResourcePool();
            int i = 0;
            int size = rns.size();
            while (i < size) {
                String rName = (String)rns.get(i);
                ResourceList rl = ResourceManager.getAllResourceList().get(rName);
                if (rl == null) {
                    throw new ChannelException("ResourceList " + rName + " does not exists");
                }
                this.rp.put(rName, rl);
                ++i;
            }
        }
    }

    private void initPDFConfig() {
        try {
            String stamp;
            PDFSignConfig c = this.service.getPdfSignConfig();
            this.pdfImage = null;
            if (c != null && (stamp = c.getStamp()) != null && !stamp.equals("")) {
                this.pdfImage = Image.getInstance((String)("data/pdfstamp/" + stamp));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initAuth() {
        this.authList = this.service.getClientAuth();
        this.checkAuth = this.service.isClientAuthEnabled();
    }

    private void initConfig(String name) {
        this.config = ConfigManager.getService();
        this.service = this.config.getService(name);
        LogManager.getSystemLogger().Log(String.valueOf(name) + " Get ServerChannel's config");
    }

    private void initLoggers() throws ChannelException {
        this.logLevel = this.service.getLogLevel();
        try {
            LogManager.register(this.config, this.service.getName());
        }
        catch (LoggerException ex) {
            LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Register Logger failed: " + ex.getMessage());
            throw new ChannelException(ex);
        }
        this.accessLogger = LogManager.getAccessLogger(this.service.getName());
        this.debugLogger = LogManager.getErrorLogger(this.service.getName());
        LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Initialize Loggers");
    }

    private void initMode() {
        this.usedHardware = ExtendedConfig.getAlgMode().equals("hard");
        LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " used hardware: " + this.usedHardware);
    }

    private void initCommunication() throws ChannelException {
        if (this.service.getCommuniteStoreAlias() == null) {
            this.cryptoCommunicate = false;
            ConsoleLogger.logString((String)(String.valueOf(this.service.getName()) + " Initialize communicate config," + " the communication is not cryptoable"));
            LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Initialize communicate config," + " the communication is not cryptoable");
        } else {
            this.cryptoCommunicate = true;
            this.cryptoUtil = new cn.com.infosec.netsign.base.processors.util.CryptoUtil();
            Key commKey = ConfigManager.getKeyStore().getKey(this.service.getCommuniteStoreAlias());
            this.cryptoUtil.SetDecKey(JKSManager.getPriKey(this.service.getCommuniteStoreAlias()));
            LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Initialize communicate config");
            ConsoleLogger.logString((String)(String.valueOf(this.service.getName()) + " Initialize communicate config"));
        }
    }

    private void initRootCerts() throws ChannelException {
        ArrayList trustList = this.service.getTrustFields();
        this.checkValidity = this.service.isCheckValidity();
        this.trustConfigs = null;
        if (trustList != null) {
            ConsoleLogger.logString((String)("trust list:" + trustList.size()));
            HashMap allTrusts = ConfigManager.getTrustFields();
            this.trustConfigs = new TrustConfigMap();
            this.updaters = new ArrayList();
            int i = 0;
            int size = trustList.size();
            while (i < size) {
                String trustName = (String)trustList.get(i);
                System.out.println("Init trust config: " + trustName);
                TrustField trustField = (TrustField)allTrusts.get(trustName);
                TrustConfig trustconfig = new TrustConfig(trustField);
                this.trustConfigs.put(CryptoUtil.trimDN((String)trustconfig.getRootCertDN()), trustconfig);
                LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Initialize root cert: " + trustconfig.getRootCertDN() == null ? null : trustconfig.getRootCertDN().replaceAll("\\\\<", "<").replaceAll("\\\\>", ">"));
                if (trustconfig.isCrlEnabled()) {
                    CRLUpdater updater = new CRLUpdater(trustconfig.getCRLList(), "crl/" + trustconfig.getCRLPath(), trustconfig.getCRLUpdateInterval(), trustconfig.useCRLDP());
                    trustconfig.setCRLUpdater(updater);
                    if (ExtendedConfig.getCRLLoadMode().equals("all") || !trustconfig.useCRLDP()) {
                        new Thread(updater).start();
                    }
                    this.updaters.add(updater);
                    LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Start a crl update thread");
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initEnvelopeCerts() throws ChannelException {
        encCerts = this.service.getEncryptCertAlias();
        this.envelopeCerts = null;
        ConsoleLogger.logString((String)("initEnvelopeCerts:" + encCerts.size()));
        if (encCerts == null || encCerts.size() <= 0) return;
        this.envelopeCerts = new HashMap<K, V>();
        i = 0;
        size = encCerts.size();
        while (i < size) {
            k = (Key)ConfigManager.getKeys().get(encCerts.get(i));
            cert = null;
            prik = null;
            if (k.getCert() == null) {
                if (k.getMode().equals("soft") || k.getPrivateKeyAlg() == null && ExtendedConfig.getHardKeyStoreDevice() == null) {
                    cert = JKSManager.getCertificate((String)encCerts.get(i));
                    prik = JKSManager.getPriKey((String)encCerts.get(i));
                } else if (ExtendedConfig.isUsehardkeystore() && ExtendedConfig.getHardKeyStoreDevice() == null) {
                    if (!"jce:SwxaJCE".equals(k.getPrivateKeyAlg())) throw new ChannelException("unsupport private key alg " + k.getPrivateKeyAlg());
                    prik = SWXAUtil.getHsmKeyPair((String)k.getKeylable(), (String)"SwxaJCE").getPrivate();
                    cert = SWXAUtil.getCertificate((String)k.getKeylable());
                }
            } else {
                tmpstore = new ServerKeyStore(k, ExtendedConfig.getSignProvider());
                prik = tmpstore.getPrivateKey();
                cert = tmpstore.getCert();
            }
            if (cert != null) {
                try {
                    nsCert = NetSignX509Certificate.getInstance(cert, prik, k.getKeylable(), ExtendedConfig.getEncryptProvider());
                    System.out.println("init envelope cert: " + (nsCert.getSubjectDNStr() == null ? null : nsCert.getSubjectDNStr().replaceAll("\\\\<", "<").replaceAll("\\\\>", ">")));
                    this.envelopeCerts.put(nsCert.getSubjectDNStr(), nsCert);
                    this.envelopeCerts.put(CryptoUtil.turnDN((String)nsCert.getSubjectDNStr()), nsCert);
                    if (k.getPrivateKeyAlg() != null) {
                        this.envelopeCerts.put(k.getKeylable(), nsCert);
                    }
                    if (i != 0) ** GOTO lbl44
                    this.defaultEnvelopeCertDN = cert.getSubjectDN().getName();
                    System.out.println("Default envelope cert is: " + (this.defaultEnvelopeCertDN == null ? null : this.defaultEnvelopeCertDN.replaceAll("\\\\<", "<").replaceAll("\\\\>", ">")));
                    LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Initialize envelope certs, the default envelope cert is: " + this.defaultEnvelopeCertDN == null ? null : this.defaultEnvelopeCertDN.replaceAll("\\\\<", "<").replaceAll("\\\\>", ">"));
                }
                catch (Exception e) {
                    throw new ChannelException(e);
                }
            } else {
                ConsoleLogger.logString((String)("Warrning: can not find encrypt certificate " + encCerts.get(i)));
            }
lbl44:
            // 3 sources

            ++i;
        }
    }

    private void initKeyStore() throws ChannelException {
        ArrayList signCerts = this.service.getSignCertAlias();
        this.signKeyStores = null;
        this.signKeySNDNMap = null;
        if (signCerts != null && signCerts.size() > 0) {
            this.signKeyStores = new HashMap();
            this.signKeySNDNMap = new HashMap();
            int i = 0;
            int size = signCerts.size();
            while (i < size) {
                Key key = (Key)ConfigManager.getKeys().get(signCerts.get(i));
                if (key != null) {
                    ServerKeyStore keyStore = new ServerKeyStore(key, ExtendedConfig.getSignProvider());
                    System.out.println("Init sign cert: " + (keyStore.getCertDN() == null ? null : keyStore.getCertDN().replaceAll("\\\\<", "<").replaceAll("\\\\>", ">")));
                    this.signKeyStores.put(keyStore.getCertDN(), keyStore);
                    this.signKeyStores.put(CryptoUtil.turnDN((String)keyStore.getCertDN()), keyStore);
                    this.signKeySNDNMap.put(keyStore.getSerialNumber(), keyStore.getCertDN());
                    if (key.getPrivateKeyAlg() != null) {
                        this.signKeyStores.put(key.getKeylable(), keyStore);
                    }
                    if (i == 0) {
                        this.defaultCertDN = keyStore.getCertDN();
                        System.out.println("Default sign cert is: " + (this.defaultCertDN == null ? null : this.defaultCertDN.replaceAll("\\\\<", "<").replaceAll("\\\\>", ">")));
                        LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " Initialize key store, the default sign cert is: " + this.defaultCertDN == null ? null : this.defaultCertDN.replaceAll("\\\\<", "<").replaceAll("\\\\>", ">"));
                    }
                } else {
                    ConsoleLogger.logString((String)("Warrning: can not find sign certificate " + signCerts.get(i)));
                }
                ++i;
            }
        }
    }

    public ServerChannel(String name) throws ChannelException {
        LogManager.getSystemLogger().Log(String.valueOf(name) + " ServerChannel initialize...");
        this.initConfig(name);
        this.initLoggers();
        this.initMode();
        this.initRootCerts();
        this.initCommunication();
        this.initEnvelopeCerts();
        this.initKeyStore();
        this.initAuth();
        this.initPDFConfig();
        this.initResourcePool();
        this.channel = new BasicChannel(name);
    }

    public void reload(String name) throws ChannelException {
        LogManager.getSystemLogger().Log(String.valueOf(name) + " ServerChannel reload...");
        Iterator it = this.updaters.iterator();
        while (it.hasNext()) {
            ((CRLUpdater)it.next()).shutdown();
        }
        this.initConfig(name);
        this.initLoggers();
        this.initMode();
        this.initRootCerts();
        this.initCommunication();
        this.initEnvelopeCerts();
        this.initKeyStore();
        this.initAuth();
        this.initPDFConfig();
        this.initResourcePool();
        this.channel.reload(name);
    }

    public String getId() {
        return this.channel.getId();
    }

    public void startChannel() throws ChannelException {
        this.channel.startChannel();
        LogManager.getSystemLogger().Log(String.valueOf(this.channel.getId()) + " ServerChannel started");
    }

    public void stopChannel() throws ChannelException {
        this.channel.stopChannel();
        Iterator it = this.updaters.iterator();
        while (it.hasNext()) {
            ((CRLUpdater)it.next()).shutdown();
        }
        LogManager.getSystemLogger().Log(String.valueOf(this.service.getName()) + " ServerChannel stopped");
    }

    public String getDefaultDigestAlg() {
        return this.defaultDigestAlg;
    }

    public String getDefaultSymmetricalAlg() {
        return this.defaultSymmetricalAlg;
    }

    public boolean isCryptoCommunicate() {
        return this.cryptoCommunicate;
    }

    public boolean isUsedHardware() {
        return this.usedHardware;
    }

    public ServiceConfig getConfig() {
        return this.config;
    }

    public cn.com.infosec.netsign.base.processors.util.CryptoUtil getCryptoUtil() {
        return this.cryptoUtil;
    }

    public AbstractLogger getAccessLogger() {
        return this.accessLogger;
    }

    public AbstractLogger getDebugLogger() {
        return this.debugLogger;
    }

    public Map getTrustConfigs() {
        return this.trustConfigs;
    }

    public Map getSignKeyStores() {
        return this.signKeyStores;
    }

    public ServerKeyStore getSignKeyStore(String certDN) {
        ServerKeyStore sks;
        if (this.signKeyStores == null) {
            return null;
        }
        if (certDN == null || certDN.equals("")) {
            certDN = this.defaultCertDN;
        }
        if ((sks = (ServerKeyStore)this.signKeyStores.get(certDN)) != null) {
            return sks;
        }
        ArrayList resourceListNames = this.service.getResourceNames();
        if (resourceListNames != null && resourceListNames.size() > 0) {
            if (resourceListNames.contains("pbcrawcerts") || resourceListNames.contains("rbcrawcerts")) {
                Object[] keys = this.signKeyStores.keySet().toArray();
                int i = 0;
                int length = keys.length;
                while (i < length) {
                    String dn = (String)keys[i];
                    if (PBCUtil.getBankID((String)dn).equals(certDN)) {
                        return (ServerKeyStore)this.signKeyStores.get(dn);
                    }
                    ++i;
                }
            }
            return null;
        }
        return null;
    }

    public ServerKeyStore getSignKeyStore() {
        if (this.signKeyStores == null) {
            return null;
        }
        return (ServerKeyStore)this.signKeyStores.get(this.defaultCertDN);
    }

    public ServerKeyStore getSignKeyStoreBySN(String sn) {
        if (this.signKeySNDNMap == null) {
            return null;
        }
        if (sn == null || sn.equals("")) {
            return this.getSignKeyStore();
        }
        String dn = (String)this.signKeySNDNMap.get(sn);
        if (dn == null) {
            return null;
        }
        return this.getSignKeyStore(dn);
    }

    public NetSignX509Certificate getEnvelopeCert(String certDN) {
        if (this.envelopeCerts == null) {
            return null;
        }
        if (certDN == null) {
            certDN = this.defaultEnvelopeCertDN;
        }
        return (NetSignX509Certificate)this.envelopeCerts.get(certDN);
    }

    public NetSignX509Certificate getEnvelopeCert() {
        if (this.envelopeCerts == null) {
            return null;
        }
        return (NetSignX509Certificate)this.envelopeCerts.get(this.defaultEnvelopeCertDN);
    }

    public int getActiveThreads() {
        return this.channel.getActiveThreads();
    }

    public List getAuthList() {
        return this.authList;
    }

    public boolean isCheckAuth() {
        return this.checkAuth;
    }

    public boolean IsStarted() {
        return this.channel.IsStarted();
    }

    public boolean isCheckValidity() {
        return this.checkValidity;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public Image getPdfImage() {
        return this.pdfImage;
    }
}

