/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.channels;

import cn.com.infosec.netsign.base.Channel;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.listeners.AbstractListener;

public class BasicChannel
implements Channel {
    private String name;
    private AbstractListener listener;
    private boolean started = false;

    public boolean IsStarted() {
        return this.started;
    }

    public int getActiveThreads() {
        return this.listener.countCurrentThreads();
    }

    public BasicChannel() throws ChannelException {
        this.name = "admin";
        this.listener = AbstractListener.createAdminListener();
    }

    public BasicChannel(String id) throws ChannelException {
        this.name = id;
        this.listener = AbstractListener.createServerListener(id, this);
    }

    public String getId() {
        return this.name;
    }

    public void startChannel() throws ChannelException {
        new Thread(this.listener).start();
        this.started = true;
    }

    public void stopChannel() throws ChannelException {
        this.started = false;
        this.listener.shutdown();
    }

    public void reload(String id) throws ChannelException {
        this.listener.reload(id, this);
    }

    public AbstractListener getListener() {
        return this.listener;
    }

    public void setListener(AbstractListener listener) {
        this.listener = listener;
    }

    public boolean isStarted() {
        return this.started;
    }
}

