/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.base.PDFBookmarkPos;
import cn.com.infosec.netsign.base.PDFDirectPos;
import cn.com.infosec.netsign.base.PDFImage;
import cn.com.infosec.netsign.base.PDFObject;
import cn.com.infosec.netsign.base.PDFPosition;
import cn.com.infosec.netsign.base.PDFSignElements;
import cn.com.infosec.netsign.base.PDFTextPos;
import cn.com.infosec.netsign.base.util.Utils;

public class PDFRequest {
    private PDFPosition pdfPos;
    private PDFObject pdfObj;
    private String pdfDigestAlg;

    public void setPdfDigestAlg(String pdfDigestAlg) {
        this.pdfDigestAlg = pdfDigestAlg;
    }

    public String getPdfDigestAlg() {
        return this.pdfDigestAlg;
    }

    public PDFRequest parse(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        String[] pieces = str.split(";");
        PDFPosition pos = null;
        PDFSignElements objRect = new PDFSignElements();
        PDFRequest prq = new PDFRequest();
        if (!pieces[0].equals("b") && !pieces[0].equals("t")) {
            pos = new PDFDirectPos();
            pos.setType(1);
            pos.setPage(Integer.parseInt(pieces[0]));
            pos.setX1(Integer.parseInt(pieces[1]));
            pos.setY1(Integer.parseInt(pieces[2]));
            pos.setX2(Integer.parseInt(pieces[3]));
            pos.setY2(Integer.parseInt(pieces[4]));
            if (!pieces[5].equals(" ")) {
                objRect.setFieldName(pieces[5]);
            }
            if (!pieces[6].equals(" ")) {
                objRect.setStamp(pieces[6]);
            }
            if (!pieces[7].equals(" ")) {
                objRect.setSignSubject(pieces[7]);
            }
            if (!pieces[8].equals(" ")) {
                prq.setPdfDigestAlg(pieces[8]);
            }
        } else if (pieces[0].equals("b")) {
            pos = new PDFBookmarkPos();
            pos.setType(2);
            pos.setBookmark(pieces[1]);
            if (!pieces[2].equals(" ")) {
                objRect.setFieldName(pieces[2]);
            }
            if (!pieces[3].equals(" ")) {
                objRect.setStamp(pieces[3]);
            }
            if (!pieces[4].equals(" ")) {
                objRect.setSignSubject(pieces[4]);
            }
            if (!pieces[5].equals(" ")) {
                prq.setPdfDigestAlg(pieces[5]);
            }
        } else if (pieces[0].equals("t")) {
            pos = new PDFTextPos();
            pos.setType(3);
            pos.setText(pieces[1]);
            pos.setRelativePos(Integer.parseInt(pieces[2]));
            pos.setWidth(Integer.parseInt(pieces[3]));
            pos.setHeight(Integer.parseInt(pieces[4]));
            if (!pieces[5].equals(" ")) {
                objRect.setFieldName(pieces[5]);
            }
            if (!pieces[6].equals(" ")) {
                objRect.setStamp(pieces[6]);
            }
            if (!pieces[7].equals(" ")) {
                objRect.setSignSubject(pieces[7]);
            }
            if (!pieces[8].equals(" ")) {
                prq.setPdfDigestAlg(pieces[8]);
            }
        }
        prq.setPdfObj(objRect);
        prq.setPdfPos(pos);
        return prq;
    }

    public void setPdfPos(PDFPosition pdfPos) {
        this.pdfPos = pdfPos;
    }

    public PDFPosition getPdfPos() {
        return this.pdfPos;
    }

    public void setPdfObj(PDFObject pdfObj) {
        this.pdfObj = pdfObj;
    }

    public PDFObject getPdfObj() {
        return this.pdfObj;
    }

    public String toString() {
        int posType = this.pdfPos.getType();
        StringBuffer buf = new StringBuffer();
        String s = ";";
        switch (posType) {
            case 1: {
                buf.append(this.directPos2String(this.pdfPos, this.pdfObj));
                break;
            }
            case 2: {
                buf.append(this.bookmarkPos2String(this.pdfPos, this.pdfObj));
                break;
            }
            case 3: {
                buf.append(this.textPos2String(this.pdfPos, this.pdfObj));
            }
        }
        if (((PDFSignElements)this.pdfObj).getFieldName() != null && !((PDFSignElements)this.pdfObj).getFieldName().equals("")) {
            buf.append(((PDFSignElements)this.pdfObj).getFieldName());
        } else {
            buf.append(" ");
        }
        buf.append(s);
        if (((PDFSignElements)this.pdfObj).getStamp() != null && !((PDFSignElements)this.pdfObj).getStamp().equals("")) {
            buf.append(((PDFSignElements)this.pdfObj).getStamp());
        } else {
            buf.append(" ");
        }
        buf.append(s);
        if (((PDFSignElements)this.pdfObj).getSignSubject() != null && !((PDFSignElements)this.pdfObj).getSignSubject().equals("")) {
            buf.append(((PDFSignElements)this.pdfObj).getSignSubject()).toString();
        } else {
            buf.append(" ");
        }
        buf.append(s);
        if (this.pdfDigestAlg != null && !this.pdfDigestAlg.equals("")) {
            buf.append(this.pdfDigestAlg);
        } else {
            buf.append(" ");
        }
        return buf.toString();
    }

    private String directPos2String(PDFPosition pdfPos2, PDFObject pdfObj2) {
        String s = ";";
        StringBuffer buf = new StringBuffer();
        buf.append(pdfPos2.getPage()).append(s).append(pdfPos2.getX1()).append(s).append(pdfPos2.getY1()).append(s).append(pdfPos2.getX2()).append(s).append(pdfPos2.getY2()).append(s);
        return buf.toString();
    }

    private String bookmarkPos2String(PDFPosition pdfPos2, PDFObject pdfObj2) {
        String s = ";";
        StringBuffer buf = new StringBuffer().append("b").append(s);
        buf.append(pdfPos2.getBookmark()).append(s);
        return buf.toString();
    }

    private String textPos2String(PDFPosition pdfPos2, PDFObject pdfObj2) {
        String s = ";";
        StringBuffer buf = new StringBuffer().append("t").append(s);
        buf.append(pdfPos2.getText()).append(s).append(pdfPos2.getRelativePos()).append(s).append(pdfPos2.getWidth()).append(s).append(pdfPos2.getHeight()).append(s);
        return buf.toString();
    }

    public byte[] encodeImage() {
        int posType = this.pdfPos.getType();
        byte[] image = null;
        image = ((PDFImage)this.pdfObj).getImage();
        if (image == null || image.length == 0) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        switch (posType) {
            case 1: {
                str.append(this.pdfPos.getPage()).append(";");
                str.append(this.pdfPos.getX1()).append(";");
                str.append(this.pdfPos.getY1()).append(";");
                str.append(this.pdfPos.getX2()).append(";");
                str.append(this.pdfPos.getY2()).append(";");
                break;
            }
            case 2: {
                str.append("b").append(";");
                str.append(this.pdfPos.getBookmark());
                break;
            }
            case 3: {
                str.append("t").append(";");
                str.append(this.pdfPos.getText()).append(";");
                str.append(this.pdfPos.getRelativePos()).append(";");
                str.append(this.pdfPos.getWidth()).append(";");
                str.append(this.pdfPos.getHeight());
            }
        }
        byte[] strB = str.toString().getBytes();
        byte[] length = Utils.generateBytes(image.length);
        byte[] tr = new byte[4 + image.length + strB.length];
        System.arraycopy(length, 0, tr, 0, 4);
        System.arraycopy(image, 0, tr, 4, image.length);
        System.arraycopy(strB, 0, tr, 4 + image.length, strB.length);
        return tr;
    }

    public PDFRequest decodeImage(byte[] bs) {
        if (bs == null || bs.length == 0) {
            return null;
        }
        PDFRequest prq = new PDFRequest();
        PDFPosition pos = null;
        PDFImage pImg = new PDFImage();
        byte[] lengthB = new byte[4];
        System.arraycopy(bs, 0, lengthB, 0, 4);
        int length = Utils.generateInt(lengthB);
        if (length <= 0) {
            return null;
        }
        byte[] img = new byte[length];
        System.arraycopy(bs, 4, img, 0, length);
        pImg.setImage(img);
        byte[] strB = new byte[bs.length - 4 - length];
        System.arraycopy(bs, 4 + length, strB, 0, strB.length);
        String str = new String(strB);
        String[] pieces = str.split(";");
        if (!pieces[0].equals("b") && !pieces[0].equals("t")) {
            pos = new PDFDirectPos();
            pos.setType(1);
            pos.setPage(Integer.parseInt(pieces[0]));
            pos.setX1(Integer.parseInt(pieces[1]));
            pos.setY1(Integer.parseInt(pieces[2]));
            pos.setX2(Integer.parseInt(pieces[3]));
            pos.setY2(Integer.parseInt(pieces[4]));
            pos.setWidth(pos.getX2() - pos.getX1());
            pos.setHeight(pos.getY2() - pos.getY1());
        }
        if (pieces[0].equals("b")) {
            pos = new PDFBookmarkPos();
            pos.setType(2);
            pos.setBookmark(pieces[1]);
        }
        if (pieces[0].equals("t")) {
            pos = new PDFTextPos();
            pos.setType(3);
            pos.setText(pieces[1]);
            pos.setRelativePos(Integer.parseInt(pieces[2]));
            pos.setWidth(Integer.parseInt(pieces[3]));
            pos.setHeight(Integer.parseInt(pieces[4]));
        }
        prq.setPdfPos(pos);
        prq.setPdfObj(pImg);
        return prq;
    }
}

