/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base;

import cn.com.infosec.netsign.base.NetSignX509Certificate;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.frame.util.CertificateUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class NetSignCertPath {
    private ArrayList path;

    public NetSignCertPath() {
        this.path = new ArrayList();
    }

    public NetSignCertPath(List path) {
        this.path = new ArrayList(path);
    }

    public int size() {
        return this.path.size();
    }

    public void add(NetSignX509Certificate cert) {
        this.path.add(cert);
    }

    public X509Certificate get(int i) {
        return ((NetSignX509Certificate)this.path.get(i)).getCert();
    }

    public void verify(PublicKey pk, boolean checkValidity) throws CertTrustException, CertValidateException {
        this.verify(pk, this.size() - 1, checkValidity);
    }

    private void verify(PublicKey pk, int i, boolean checkValidity) throws CertTrustException, CertValidateException {
        X509Certificate cert;
        block17: {
            cert = this.get(i);
            if (checkValidity) {
                try {
                    cert.checkValidity();
                }
                catch (Exception e) {
                    throw new CertValidateException("cert " + cert.getSubjectDN().getName() + " not before:" + cert.getNotBefore() + " not after:" + cert.getNotAfter());
                }
            }
            try {
                if (pk != null) {
                    if (pk instanceof SM2PublicKey) {
                        NetSignImpl.verifyCert(cert.getSigAlgOID(), cert.getTBSCertificate(), cert.getSignature(), (SM2PublicKey)pk, Utils.getOSCCApucID(1, null));
                    } else {
                        cert.verify(pk, "INFOSEC");
                    }
                    break block17;
                }
                if (cert.getSubjectDN().equals(cert.getIssuerDN())) {
                    if (Utils.getCertType(cert) == 1) {
                        try {
                            SM2Certificate sm2Cert = new SM2Certificate(cert, cert.getEncoded(), cert.getTBSCertificate());
                            NetSignImpl.verifyCert(cert.getSigAlgOID(), cert.getTBSCertificate(), cert.getSignature(), sm2Cert.getSM2PublicKey(), Utils.getOSCCApucID(1, null));
                            break block17;
                        }
                        catch (Exception e) {
                            throw new CertTrustException(e);
                        }
                    }
                    cert.verify(cert.getPublicKey());
                    break block17;
                }
                throw new CertTrustException(String.valueOf(cert.getSubjectDN().getName()) + " can not be trusted");
            }
            catch (Exception e) {
                throw new CertTrustException(String.valueOf(cert.getSubjectDN().getName()) + " can not be trusted");
            }
        }
        if (--i > -1) {
            PublicKey certPubk = null;
            if (Utils.getCertType(cert) == 1) {
                try {
                    SM2Certificate sm2Cert = new SM2Certificate(cert, cert.getEncoded(), cert.getTBSCertificate());
                    certPubk = sm2Cert.getPublicKey();
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                }
            } else {
                certPubk = cert.getPublicKey();
            }
            this.verify(certPubk, i, checkValidity);
        }
    }

    public NetSignCertPath subPath(X509Certificate cert) {
        NetSignX509Certificate nscert = NetSignX509Certificate.getInstance(cert);
        int i = this.path.indexOf(nscert);
        if (i > -1) {
            return new NetSignCertPath(this.path.subList(0, i));
        }
        return null;
    }

    public NetSignCertPath subPath(int pos, int length) {
        return new NetSignCertPath(this.path.subList(pos, pos + length));
    }

    public int indexOf(X509Certificate cert) {
        NetSignX509Certificate nscert = NetSignX509Certificate.getInstance(cert);
        return this.path.indexOf(nscert);
    }

    public int whoisChild(Principal issuerDN) {
        int i = 0;
        int size = this.size();
        while (i < size) {
            NetSignX509Certificate nscert = (NetSignX509Certificate)this.path.get(i);
            if (nscert.getIssuerDN().equals(issuerDN)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int[] mostCloseIssuer(String[] issuerDN, int level) {
        int i = level;
        int size = this.size();
        while (i < size) {
            String issuer = ((NetSignX509Certificate)this.path.get(i)).getIssuerDNStr();
            issuer = CertificateUtil.trimDN((String)issuer);
            int j = 0;
            int length = issuerDN.length;
            while (j < length) {
                if (issuer.equals(issuerDN[j])) {
                    return new int[]{j, i};
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public int whoisChild(String issuerDN) {
        int i = 0;
        int size = this.size();
        while (i < size) {
            NetSignX509Certificate nscert = (NetSignX509Certificate)this.path.get(i);
            if (nscert.getIssuerDNStr().equals(issuerDN)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException {
        int i = 0;
        int size = this.size();
        while (i < size) {
            ((NetSignX509Certificate)this.path.get(size)).checkValidity();
            --size;
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NetSignCertPath ");
        if (this.path != null) {
            buf.append("size:" + this.path.size()).append("\n");
            int i = 0;
            int size = this.path.size();
            while (i < size) {
                buf.append(String.valueOf(this.get(i).getSubjectDN().getName()) + "\n");
                ++i;
            }
        }
        return buf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (!(anObj instanceof NetSignCertPath)) return false;
        NetSignCertPath nspath = (NetSignCertPath)anObj;
        if (this == nspath) {
            return true;
        }
        if (this.size() != nspath.size()) return false;
        int i = 0;
        int size = this.size();
        while (i < size) {
            if (!this.get(i).equals(nspath.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

