/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.admin.exception.AdminAPIException;
import cn.com.infosec.netsign.admin.resource.AdminConfigRes;
import cn.com.infosec.netsign.base.Channel;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.base.channels.factory.ChannelFactory;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.cache.Envelop;
import cn.com.infosec.netsign.frame.config.AdminConfig;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.ResourcesConfig;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.frame.util.ShutdownHook;
import cn.com.infosec.netsign.jmx.MBeanManager;
import cn.com.infosec.netsign.jmx.TaskFactory;
import cn.com.infosec.netsign.jmx.TaskQueue;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.logger.LoggerException;
import cn.com.infosec.netsign.manager.ChannelManager;
import cn.com.infosec.netsign.manager.CryptoManager;
import cn.com.infosec.netsign.manager.DCServerManager;
import cn.com.infosec.netsign.manager.JKSManager;
import cn.com.infosec.netsign.manager.LogManager;
import cn.com.infosec.netsign.manager.NetSignServerGroup;
import cn.com.infosec.netsign.manager.ProcessManager;
import cn.com.infosec.netsign.resources.PDFStamps;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2;
import cn.com.infosec.synfw.logger.SynLogger;
import com.sansec.jce.provider.SwxaProvider;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PropertyResourceBundle;

public class NetSignServer {
    private static final String PARAM_HELP = "-help";
    private static final String PARAM_VERSION = "-version";
    private static final String PARAM_START = "-start";
    private static String startedTime;
    private static long startTimeLong;
    PrintWriter startinfowriter = null;
    private TaskQueue tq = null;
    private static HashMap versions;

    static {
        Security.addProvider((Provider)new InfosecProvider());
        versions = new HashMap();
        versions.put("NetSignServer", "NetSignServer V5.5.40.12 Build201412101800");
    }

    public static String getVersion() {
        String productName;
        block14: {
            FileInputStream in = null;
            productName = null;
            try {
                try {
                    in = new FileInputStream("/opt/infosec/NetSignServer52/NetSignServer/serverInfo.ini");
                    PropertyResourceBundle prb = new PropertyResourceBundle(in);
                    productName = prb.getString("version");
                }
                catch (Exception exception) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block14;
                    }
                    catch (Exception exception2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NetSignServer.getVersion(productName);
    }

    public static String getVersion(String productName) {
        String version = (String)versions.get(productName = productName == null ? "" : productName);
        if (version == null) {
            return (String)versions.get("CORE");
        }
        return version;
    }

    public static long getStartTime() {
        return startTimeLong;
    }

    public static String getStartedTime() {
        return startedTime;
    }

    private void loadConfig(String serviceConfig) {
        if (serviceConfig != null && !serviceConfig.equals("")) {
            ConfigManager.load((String)serviceConfig);
        } else {
            ConfigManager.load((String)"config/");
        }
    }

    private void registerProcessors() throws ProcessorException {
        System.out.println("register processors...");
        LogManager.getSystemLogger().Log("regist processors...");
        ProcessManager.initProcessores();
    }

    private void startChannels() throws ChannelException {
        System.out.println("start ns channels...");
        LogManager.getSystemLogger().Log("load ns channels...");
        HashMap serverMap = ConfigManager.getServices();
        Iterator it = serverMap.values().iterator();
        while (it.hasNext()) {
            Service serverConfig = (Service)it.next();
            String name = serverConfig.getName();
            try {
                NetSignServerGroup.startupServer(name, 2);
                System.out.println("start channel " + name + " success");
                LogManager.getSystemLogger().Log("load channel " + name + " success");
            }
            catch (Throwable e) {
                ConsoleLogger.logException((Throwable)e);
                System.out.println("start channel " + name + " failed: " + e.getMessage());
                LogManager.getSystemLogger().Log("start channel " + name + " failed: " + e.getMessage());
            }
        }
    }

    private void loadNSChannels() {
        System.out.println("load ns channels...");
        LogManager.getSystemLogger().Log("load ns channels...");
        HashMap serverMap = ConfigManager.getServices();
        Iterator it = serverMap.values().iterator();
        while (it.hasNext()) {
            Service serverConfig = (Service)it.next();
            String name = serverConfig.getName();
            try {
                NetSignServerGroup.startupServer(name, 1);
                System.out.println("load channel " + name + " success");
                LogManager.getSystemLogger().Log("load channel " + name + " success");
            }
            catch (Throwable e) {
                ConsoleLogger.logException((Throwable)e);
                System.out.println("load channel " + name + " failed: " + e.getMessage());
                LogManager.getSystemLogger().Log("load channel " + name + " failed: " + e.getMessage());
            }
        }
    }

    private void loadAdminChannels() throws ChannelException {
        System.out.println("load admin channel...");
        LogManager.getSystemLogger().Log("load admin channel...");
        AdminConfig admin = ConfigManager.getAdmin();
        if (admin.getPort() < 0) {
            System.out.println("start none admin channel");
            LogManager.getSystemLogger().Log("start none admin channel");
            return;
        }
        Channel channel = ChannelFactory.createAdminChannel();
        channel.startChannel();
        ChannelManager.registerAdminChannel(channel);
        System.out.println("load admin channel success");
        LogManager.getSystemLogger().Log("load admin channel success");
    }

    private void initCryptoImpl() throws CryptoException {
        System.out.println("initialize crypto config...");
        LogManager.getSystemLogger().Log("initialize crypto config...");
        CryptoManager.initialize();
    }

    private void registerLogger() throws LoggerException {
        System.out.println("register admin logger...");
        LogManager.register(ConfigManager.getAdmin());
    }

    private void load(String[] args) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        startTimeLong = System.currentTimeMillis();
        startedTime = format.format(new Date());
        try {
            ShutdownHook hook = new ShutdownHook();
            Runtime.getRuntime().addShutdownHook((Thread)hook);
            if (args.length > 1) {
                this.loadConfig(args[1]);
            } else {
                this.loadConfig(null);
            }
            if ("jce:SwxaJCE".equals(ExtendedConfig.getPrivateKeyAlg()) && ExtendedConfig.isUsehardkeystore() && ExtendedConfig.getHardKeyStoreDevice() == null) {
                Security.insertProviderAt((Provider)new SwxaProvider(), 100);
            }
            ConsoleLogger.init();
            SynLogger.init();
            this.registerLogger();
            JKSManager.initJKS();
            PDFStamps.load();
            this.initSM2();
            ResourceManager.load((ResourcesConfig)ConfigManager.getResourcesConfig());
        }
        catch (Throwable e1) {
            ConsoleLogger.logException((Throwable)e1);
            this.startinfowriter.println("-1");
            this.startinfowriter.println("load server failed: " + e1.toString());
            this.startinfowriter.close();
            System.exit(-1);
        }
        try {
            AdminConfigRes.initialize();
        }
        catch (AdminAPIException e) {
            ConsoleLogger.logException((Throwable)e);
        }
        try {
            this.initJMX();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            this.startinfowriter.println("-1");
            this.startinfowriter.close();
            System.exit(-1);
        }
        try {
            this.loadAdminChannels();
            this.registerProcessors();
            this.loadNSChannels();
            this.initSYN();
            this.synCertWhenStart();
            this.initCryptoImpl();
            this.startChannels();
        }
        catch (Throwable e) {
            ConsoleLogger.logException((Throwable)e);
            System.out.println("load server failed: " + e.toString());
            this.startinfowriter.println("-1");
            this.startinfowriter.println("load server failed: " + e.toString());
            this.startinfowriter.close();
            LogManager.getSystemLogger().Log("load server failed: " + e.toString());
            System.exit(-1);
        }
        try {
            DCServerManager.registerServers();
        }
        catch (Throwable e) {
            ConsoleLogger.logException((Throwable)e);
        }
        System.out.println("server started at " + startedTime + ".");
        this.startinfowriter.println(0);
        this.startinfowriter.println("server started at " + startedTime + ".");
        this.startinfowriter.close();
        LogManager.getSystemLogger().Log("server started at " + startedTime + ".");
    }

    private void initSM2() throws Exception {
        if (ExtendedConfig.isSupportsm2()) {
            String cryptoDevice = ExtendedConfig.getHardKeyStoreDevice();
            if (cryptoDevice == null) {
                SM2.setSM2SignModeHard((boolean)ExtendedConfig.isSM2SignUsehardalg());
                SM2.setSM2VerifyModeHard((boolean)ExtendedConfig.isSM2VerifyUsehardalg());
            } else {
                SM2.setCryptoDevice((String)ExtendedConfig.getHardKeyStoreDevice());
                SM2.setSM2SignModeHard((boolean)false);
                SM2.setSM2VerifyModeHard((boolean)false);
            }
            SM2.setSM2Provider((String)ExtendedConfig.getSm2Provider());
            SM2.setCacheSM2((boolean)ExtendedConfig.isSm2Cache());
            if (SM2.isCacheSM2()) {
                SM2.setSm2CacheSize((int)ExtendedConfig.getSm2CacheSize());
                SM2.setSm2SignGear((String)ExtendedConfig.getSm2SignGear());
                SM2.setSm2VerifyGear((String)ExtendedConfig.getSm2VerifyGear());
            }
            Envelop.setCache((boolean)ExtendedConfig.isEnvelopCache());
            if (Envelop.isCache()) {
                Envelop.setEnvCacheSize((int)ExtendedConfig.getEnvelopCacheSize());
                Envelop.setEnGear((String)ExtendedConfig.getEncryptGear());
                Envelop.setDeGear((String)ExtendedConfig.getDecryptGear());
            }
            SM2.setIntegerIsUnsignedSignature((boolean)ExtendedConfig.isIntegerUnsigned());
            SDFJNI.init();
        }
    }

    private void initJMX() throws Exception {
        if (!ExtendedConfig.getJmxMonitorLevel().equals("none")) {
            System.out.println("init JMX");
            MBeanManager.initJMX();
            this.tq = TaskFactory.getTaskQueue();
            MBeanManager.registJVMInfoMBean();
            MBeanManager.registSignatureCatchMBean();
        }
    }

    private void initSYN() {
        System.out.println("init SYN");
        PBCRAWCertSynManager synmanager = PBCRAWCertSynManagerFactory.getSynManager();
        synmanager.getTasknotifier().start();
        synmanager.getOperationnotifier().start();
    }

    private void synCertWhenStart() {
        System.out.println("Syn certs when server start...");
        PBCRAWCertSynManager synmanager = PBCRAWCertSynManagerFactory.getSynManager();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            SynLogger.log((String)("---------- Syn when server start begin... ( " + format.format(new Date()) + " ) ----------"));
            synmanager.synWhenServerStart();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Syn certs when server end.");
        SynLogger.log((String)("---------- Syn when server start end. ( " + format.format(new Date()) + " ) ----------"));
        PBCRAWCertSynManagerFactory.getSynManager().getSyncontroller().getEmissary().setJustwake(false);
    }

    public NetSignServer() {
        try {
            FileWriter fw = new FileWriter("StartInfo.txt");
            this.startinfowriter = new PrintWriter(fw);
        }
        catch (Exception ie) {
            ConsoleLogger.logException((Throwable)ie);
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        System.out.println(NetSignServer.getVersion());
        if (args != null && args.length > 0 && !args[0].equals(PARAM_VERSION) && args[0].equals(PARAM_START)) {
            new NetSignServer().load(args);
        }
    }
}

