/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.corba.deployer.CorbaConstants;
import org.apache.axis2.corba.deployer.SchemaGenerator;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.IDL;
import org.apache.axis2.corba.idl.types.Interface;
import org.apache.axis2.corba.idl.types.Operation;
import org.apache.axis2.corba.receivers.CorbaUtil;
import org.apache.axis2.deployment.AbstractDeployer;
import org.apache.axis2.deployment.DeploymentConstants;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.deployment.DescriptionBuilder;
import org.apache.axis2.deployment.repository.util.DeploymentFileData;
import org.apache.axis2.deployment.util.PhasesInfo;
import org.apache.axis2.deployment.util.Utils;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.java2wsdl.TypeTable;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.omg.CORBA_2_3.ORB;

public class CorbaDeployer
extends AbstractDeployer
implements DeploymentConstants,
CorbaConstants {
    private static final Log log = LogFactory.getLog(CorbaDeployer.class);
    private AxisConfiguration axisConfig;
    private ConfigurationContext configCtx;

    public void init(ConfigurationContext configCtx) {
        this.configCtx = configCtx;
        this.axisConfig = this.configCtx.getAxisConfiguration();
    }

    public void deploy(DeploymentFileData deploymentFileData) throws DeploymentException {
        String name = null;
        try {
            deploymentFileData.setClassLoader(this.axisConfig.getServiceClassLoader());
            AxisServiceGroup serviceGroup = new AxisServiceGroup(this.axisConfig);
            serviceGroup.setServiceGroupClassLoader(deploymentFileData.getClassLoader());
            ArrayList serviceList = this.processService(deploymentFileData, serviceGroup, this.configCtx);
            DeploymentEngine.addServiceGroup((AxisServiceGroup)serviceGroup, (ArrayList)serviceList, (URL)deploymentFileData.getFile().toURL(), (DeploymentFileData)deploymentFileData, (AxisConfiguration)this.axisConfig);
            name = deploymentFileData.getName();
            super.deploy(deploymentFileData);
            log.info((Object)("Deploying " + name));
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Error while deploying " + name), (Throwable)axisFault);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Error while deploying " + name), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error while deploying " + name), (Throwable)e);
        }
    }

    private ArrayList processService(DeploymentFileData deploymentFileData, AxisServiceGroup serviceGroup, ConfigurationContext configCtx) throws Exception {
        AxisService axisService;
        block12: {
            String filename = deploymentFileData.getAbsolutePath();
            File file = new File(filename);
            serviceGroup.setServiceGroupName(deploymentFileData.getName());
            String serviceName = DescriptionBuilder.getShortFileName((String)deploymentFileData.getName());
            axisService = new AxisService();
            axisService.setName(serviceName);
            axisService.setParent(serviceGroup);
            axisService.setClassLoader(deploymentFileData.getClassLoader());
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                DescriptionBuilder builder = new DescriptionBuilder((InputStream)in, configCtx);
                OMElement rootElement = builder.buildOM();
                String elementName = rootElement.getLocalName();
                if ("service".equals(elementName)) {
                    this.populateService(axisService, rootElement, file.getParent());
                    break block12;
                }
                throw new AxisFault("Invalid " + deploymentFileData.getAbsolutePath() + " found");
            }
            catch (FileNotFoundException e) {
                throw new DeploymentException(Messages.getMessage((String)"fileNotFound", (String)e.getMessage()));
            }
            catch (XMLStreamException e) {
                throw new DeploymentException(Messages.getMessage((String)"StreamException", (String)e.getMessage()));
            }
            finally {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        log.info((Object)Messages.getMessage((String)"errorininputstreamclose"));
                    }
                }
            }
        }
        ArrayList<AxisService> serviceList = new ArrayList<AxisService>();
        serviceList.add(axisService);
        return serviceList;
    }

    private void populateService(AxisService service, OMElement service_element, String directory) throws DeploymentException {
        try {
            OMElement transports;
            OMAttribute targetNameSpace;
            OMAttribute addressingRequiredatt;
            OMAttribute serviceNameatt;
            Iterator itr = service_element.getChildrenWithName(new QName("parameter"));
            this.processParameters(itr, (ParameterInclude)service, (ParameterInclude)service.getParent());
            OMElement descriptionElement = service_element.getFirstChildWithName(new QName("Description"));
            if (descriptionElement != null) {
                OMElement descriptionValue = descriptionElement.getFirstElement();
                if (descriptionValue != null) {
                    StringWriter writer = new StringWriter();
                    descriptionValue.build();
                    descriptionValue.serialize((Writer)writer);
                    writer.flush();
                    service.setDocumentation(writer.toString());
                } else {
                    service.setDocumentation(descriptionElement.getText());
                }
            } else {
                serviceNameatt = service_element.getAttribute(new QName("name"));
                if (serviceNameatt != null && !"".equals(serviceNameatt.getAttributeValue().trim())) {
                    service.setDocumentation(serviceNameatt.getAttributeValue());
                }
            }
            serviceNameatt = service_element.getAttribute(new QName("name"));
            if (serviceNameatt != null && !"".equals(serviceNameatt.getAttributeValue().trim())) {
                service.setName(serviceNameatt.getAttributeValue());
                if (service.getDocumentation() == null) {
                    service.setDocumentation(serviceNameatt.getAttributeValue());
                }
            }
            if ((addressingRequiredatt = service_element.getAttribute(new QName("wsaddressing"))) != null) {
                String addressingRequiredString = addressingRequiredatt.getAttributeValue();
                AddressingHelper.setAddressingRequirementParemeterValue((AxisDescription)service, (String)addressingRequiredString);
            }
            if ((targetNameSpace = service_element.getAttribute(new QName("targetNamespace"))) != null) {
                String nameSpeceVale = targetNameSpace.getAttributeValue();
                if (nameSpeceVale != null && !"".equals(nameSpeceVale)) {
                    service.setTargetNamespace(nameSpeceVale);
                }
            } else if (service.getTargetNamespace() == null || "".equals(service.getTargetNamespace())) {
                service.setTargetNamespace("http://ws.apache.org/axis2");
            }
            OMElement schemaElement = service_element.getFirstChildWithName(new QName("schema"));
            if (schemaElement != null) {
                OMAttribute elementFormDefault;
                String nameSpeceVale;
                OMAttribute schemaNameSpace = schemaElement.getAttribute(new QName("schemaNamespace"));
                if (schemaNameSpace != null && (nameSpeceVale = schemaNameSpace.getAttributeValue()) != null && !"".equals(nameSpeceVale)) {
                    service.setSchemaTargetNamespace(nameSpeceVale);
                }
                if ((elementFormDefault = schemaElement.getAttribute(new QName("elementFormDefaultQualified"))) != null) {
                    String value = elementFormDefault.getAttributeValue();
                    if ("true".equals(value)) {
                        service.setElementFormDefault(true);
                    } else if ("false".equals(value)) {
                        service.setElementFormDefault(false);
                    }
                }
            }
            OMElement excludeOperations = service_element.getFirstChildWithName(new QName("excludeOperations"));
            ArrayList<String> excludeops = null;
            if (excludeOperations != null) {
                excludeops = new ArrayList<String>();
                Iterator excludeOp_itr = excludeOperations.getChildrenWithName(new QName("operation"));
                while (excludeOp_itr.hasNext()) {
                    OMElement opName = (OMElement)excludeOp_itr.next();
                    excludeops.add(opName.getText().trim());
                }
            }
            if (excludeops == null) {
                excludeops = new ArrayList();
            }
            Iterator moduleRefs = service_element.getChildrenWithName(new QName("module"));
            while (moduleRefs.hasNext()) {
                OMElement moduleref = (OMElement)moduleRefs.next();
                OMAttribute moduleRefAttribute = moduleref.getAttribute(new QName("ref"));
                String refName = moduleRefAttribute.getAttributeValue();
                this.axisConfig.addGlobalModuleRef(refName);
            }
            OMElement messageReceiver = service_element.getFirstChildWithName(new QName("messageReceivers"));
            ClassLoader loader = service.getClassLoader();
            service.addMessageReceiver("http://www.w3.org/ns/wsdl/in-only", this.loadMessageReceiver(loader, "org.apache.axis2.corba.receivers.CorbaInOnlyMessageReceiver"));
            service.addMessageReceiver("http://www.w3.org/ns/wsdl/robust-in-only", this.loadMessageReceiver(loader, "org.apache.axis2.corba.receivers.CorbaInOnlyMessageReceiver"));
            service.addMessageReceiver("http://www.w3.org/ns/wsdl/in-out", this.loadMessageReceiver(loader, "org.apache.axis2.corba.receivers.CorbaMessageReceiver"));
            service.addMessageReceiver("http://www.w3.org/ns/wsdl/in-opt-out", this.loadMessageReceiver(loader, "org.apache.axis2.corba.receivers.CorbaInOutAsyncMessageReceiver"));
            if (messageReceiver != null) {
                HashMap mrs = this.processMessageReceivers(loader, messageReceiver);
                for (String key : mrs.keySet()) {
                    service.addMessageReceiver(key, (MessageReceiver)mrs.get(key));
                }
            }
            if ((transports = service_element.getFirstChildWithName(new QName("transports"))) != null) {
                Iterator transport_itr = transports.getChildrenWithName(new QName("transport"));
                ArrayList<String> trs = new ArrayList<String>();
                while (transport_itr.hasNext()) {
                    OMElement trsEle = (OMElement)transport_itr.next();
                    String tarnsportName = trsEle.getText().trim();
                    trs.add(tarnsportName);
                }
                service.setExposedTransports(trs);
            }
            this.processOperations(service, this.axisConfig, excludeops, null, directory);
            Iterator operationsIterator = service.getOperations();
            while (operationsIterator.hasNext()) {
                AxisOperation operationDesc = (AxisOperation)operationsIterator.next();
                ArrayList wsamappings = operationDesc.getWSAMappingList();
                if (wsamappings == null) continue;
                if (service.getOperation(operationDesc.getName()) == null) {
                    service.addOperation(operationDesc);
                }
                for (int j = 0; j < wsamappings.size(); ++j) {
                    String mapping = (String)wsamappings.get(j);
                    if (mapping.length() <= 0) continue;
                    service.mapActionToOperation(mapping, operationDesc);
                }
            }
            for (int i = 0; i < excludeops.size(); ++i) {
                String opName = (String)excludeops.get(i);
                service.removeOperation(new QName(opName));
            }
        }
        catch (XMLStreamException e) {
            throw new DeploymentException((Throwable)e);
        }
        catch (AxisFault axisFault) {
            throw new DeploymentException(Messages.getMessage((String)"op_error", (String)axisFault.getMessage()), (Throwable)axisFault);
        }
        catch (Exception e) {
            throw new DeploymentException((Throwable)e);
        }
    }

    protected HashMap processMessageReceivers(ClassLoader loader, OMElement element) throws DeploymentException {
        HashMap<String, MessageReceiver> meps = new HashMap<String, MessageReceiver>();
        Iterator iterator = element.getChildrenWithName(new QName("messageReceiver"));
        while (iterator.hasNext()) {
            OMElement receiverElement = (OMElement)iterator.next();
            OMAttribute receiverName = receiverElement.getAttribute(new QName("class"));
            String className = receiverName.getAttributeValue();
            MessageReceiver receiver = this.loadMessageReceiver(loader, className);
            OMAttribute mepAtt = receiverElement.getAttribute(new QName("mep"));
            meps.put(mepAtt.getAttributeValue(), receiver);
        }
        return meps;
    }

    protected MessageReceiver loadMessageReceiver(ClassLoader loader, String className) throws DeploymentException {
        MessageReceiver receiver = null;
        try {
            if (className != null && !"".equals(className)) {
                Class messageReceiver = Loader.loadClass((ClassLoader)loader, (String)className);
                receiver = (MessageReceiver)messageReceiver.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentException(org.apache.axis2.i18n.Messages.getMessage((String)"errorinloadingmr", (String)"ClassNotFoundException", (String)className), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new DeploymentException(org.apache.axis2.i18n.Messages.getMessage((String)"errorinloadingmr", (String)"IllegalAccessException", (String)className), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new DeploymentException(org.apache.axis2.i18n.Messages.getMessage((String)"errorinloadingmr", (String)"InstantiationException", (String)className), (Throwable)e);
        }
        return receiver;
    }

    private void processParameters(Iterator parameters, ParameterInclude parameterInclude, ParameterInclude parent) throws DeploymentException {
        while (parameters.hasNext()) {
            OMElement parameterElement = (OMElement)parameters.next();
            Parameter parameter = new Parameter();
            parameter.setParameterElement(parameterElement);
            OMAttribute paramName = parameterElement.getAttribute(new QName("name"));
            if (paramName == null) {
                throw new DeploymentException(Messages.getMessage((String)"badparaagu", (String)parameterElement.toString()));
            }
            parameter.setName(paramName.getAttributeValue());
            OMElement paramValue = parameterElement.getFirstElement();
            if (paramValue != null) {
                parameter.setValue((Object)parameterElement);
                parameter.setParameterType(2);
            } else {
                String paratextValue = parameterElement.getText();
                parameter.setValue((Object)paratextValue);
                parameter.setParameterType(1);
            }
            OMAttribute paramLocked = parameterElement.getAttribute(new QName("locked"));
            Parameter parentParam = null;
            if (parent != null) {
                parentParam = parent.getParameter(parameter.getName());
            }
            if (paramLocked != null) {
                String lockedValue = paramLocked.getAttributeValue();
                if ("true".equals(lockedValue)) {
                    if (parent != null && parent.isParameterLocked(parameter.getName())) {
                        throw new DeploymentException(Messages.getMessage((String)"confignotfound", (String)parameter.getName()));
                    }
                    parameter.setLocked(true);
                } else {
                    parameter.setLocked(false);
                }
            }
            try {
                if (parent != null) {
                    if (parentParam != null && parent.isParameterLocked(parameter.getName())) continue;
                    parameterInclude.addParameter(parameter);
                    continue;
                }
                parameterInclude.addParameter(parameter);
            }
            catch (AxisFault axisFault) {
                throw new DeploymentException((Throwable)axisFault);
            }
        }
    }

    private void processOperations(AxisService axisService, AxisConfiguration axisConfig, ArrayList excludeOperations, ArrayList nonRpcMethods, String dirName) throws Exception {
        ORB orb = CorbaUtil.getORB(axisService);
        IDL idl = CorbaUtil.getIDL(axisService, orb, dirName);
        Parameter orbParam = new Parameter("orb", (Object)orb);
        Parameter idlParam = new Parameter("idl", (Object)idl);
        axisService.addParameter(orbParam);
        axisService.addParameter(idlParam);
        NamespaceMap map = new NamespaceMap();
        map.put((Object)"ns1", (Object)"http://org.apache.axis2/xsd");
        map.put((Object)"xs", (Object)"http://www.w3.org/2001/XMLSchema");
        axisService.setNamespaceMap(map);
        Parameter interfaceNameParam = axisService.getParameter("interfaceName");
        String interfaceName = (String)(interfaceNameParam == null ? null : interfaceNameParam.getValue());
        SchemaGenerator schemaGenerator = new SchemaGenerator(idl, interfaceName, axisService.getSchemaTargetNamespace(), axisService.getSchemaTargetNamespacePrefix());
        schemaGenerator.setExcludeMethods(excludeOperations);
        schemaGenerator.setNonRpcMethods(nonRpcMethods);
        if (!axisService.isElementFormDefault()) {
            schemaGenerator.setElementFormDefault("unqualified");
        }
        schemaGenerator.setPkg2nsmap(axisService.getP2nMap());
        Collection schemas = schemaGenerator.generateSchema();
        axisService.addSchema(schemas);
        axisService.setSchemaTargetNamespace(schemaGenerator.getSchemaTargetNameSpace());
        axisService.setTypeTable(schemaGenerator.getTypeTable());
        axisService.addParameter("SchemaToIDLMapping", (Object)schemaGenerator.getSchemaToIDLMapping());
        if ("http://ws.apache.org/axis2".equals(axisService.getTargetNamespace())) {
            axisService.setTargetNamespace(schemaGenerator.getTargetNamespace());
        }
        Interface intf = (Interface)idl.getInterfaces().get(interfaceName);
        Operation[] operations = intf.getOperations();
        TypeTable table = schemaGenerator.getTypeTable();
        PhasesInfo pinfo = axisConfig.getPhasesInfo();
        for (int i = 0; i < operations.length; ++i) {
            Operation corbaOperation = operations[i];
            String opName = corbaOperation.getName();
            if (excludeOperations != null && excludeOperations.contains(opName)) continue;
            AxisOperation operation = axisService.getOperation(new QName(opName));
            if (operation != null) {
                DataType returnType;
                AxisMessage inMessage = operation.getMessage("In");
                if (inMessage != null) {
                    inMessage.setName(opName + "Request");
                    QName complexSchemaType = table.getComplexSchemaType(opName);
                    inMessage.setElementQName(complexSchemaType);
                    if (complexSchemaType != null) {
                        axisService.addMessageElementQNameToOperationMapping(complexSchemaType, operation);
                    }
                }
                if ((returnType = corbaOperation.getReturnType()) != null && !CorbaUtil.getQualifiedName(returnType).equals("void")) {
                    AxisMessage outMessage = operation.getMessage("Out");
                    QName qNamefortheType = table.getQNamefortheType(opName + "Response");
                    outMessage.setElementQName(qNamefortheType);
                    if (qNamefortheType != null) {
                        axisService.addMessageElementQNameToOperationMapping(qNamefortheType, operation);
                    }
                    outMessage.setName(opName + "Response");
                }
                if (corbaOperation.hasRaises()) {
                    List extypes = corbaOperation.getRaises();
                    for (int j = 0; j < extypes.size(); ++j) {
                        AxisMessage faultMessage = new AxisMessage();
                        ExceptionType extype = (ExceptionType)extypes.get(j);
                        String exname = extype.getName();
                        if (extypes.size() > 1) {
                            faultMessage.setName(opName + "Fault" + j);
                        } else {
                            faultMessage.setName(opName + "Fault");
                        }
                        faultMessage.setElementQName(table.getComplexSchemaType(exname + "Fault"));
                        operation.setFaultMessages(faultMessage);
                    }
                }
            } else {
                operation = this.getAxisOperationforCorbaOperation(corbaOperation, table);
                MessageReceiver mr = axisService.getMessageReceiver(operation.getMessageExchangePattern());
                if (mr != null) {
                    operation.setMessageReceiver(mr);
                } else {
                    mr = axisConfig.getMessageReceiver(operation.getMessageExchangePattern());
                    operation.setMessageReceiver(mr);
                }
                pinfo.setOperationPhases(operation);
                axisService.addOperation(operation);
            }
            if (operation.getInputAction() != null) continue;
            operation.setSoapAction("urn:" + opName);
        }
    }

    private AxisOperation getAxisOperationforCorbaOperation(Operation corbaOperation, TypeTable table) throws AxisFault {
        AxisOperation operation;
        String opName = corbaOperation.getName();
        DataType returnType = corbaOperation.getReturnType();
        if (returnType == null && !corbaOperation.hasRaises() && !corbaOperation.hasOutParams()) {
            operation = AxisOperationFactory.getAxisOperation((int)10);
        } else {
            operation = AxisOperationFactory.getAxisOperation((int)12);
            AxisMessage outMessage = operation.getMessage("Out");
            outMessage.setElementQName(table.getQNamefortheType(opName + "Response"));
            outMessage.setName(opName + "Response");
        }
        if (corbaOperation.hasRaises()) {
            List extypes = corbaOperation.getRaises();
            for (int j = 0; j < extypes.size(); ++j) {
                AxisMessage faultMessage = new AxisMessage();
                ExceptionType extype = (ExceptionType)extypes.get(j);
                String exname = extype.getName();
                if (extypes.size() > 1) {
                    faultMessage.setName(opName + "Fault" + j);
                } else {
                    faultMessage.setName(opName + "Fault");
                }
                faultMessage.setElementQName(table.getComplexSchemaType(exname + "Fault"));
                operation.setFaultMessages(faultMessage);
            }
        }
        operation.setName(new QName(opName));
        AxisMessage inMessage = operation.getMessage("In");
        if (inMessage != null) {
            inMessage.setElementQName(table.getComplexSchemaType(opName));
            inMessage.setName(opName + "Request");
        }
        return operation;
    }

    public void setDirectory(String directory) {
    }

    public void setExtension(String extension) {
    }

    public void undeploy(String fileName) throws DeploymentException {
        try {
            super.undeploy(fileName);
            fileName = Utils.getShortFileName((String)fileName);
            this.axisConfig.removeServiceGroup(fileName);
            log.info((Object)Messages.getMessage((String)"serviceremoved", (String)fileName));
        }
        catch (AxisFault axisFault) {
            this.axisConfig.removeFaultyService(fileName);
        }
    }
}

