/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartglyph;

import com.fr.base.DoubleDimension2D;
import com.fr.base.GraphHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ChartEnumDefinitions;
import com.fr.chart.base.GlyphUtils;
import com.fr.chart.base.TextAttr;
import com.fr.chart.chartglyph.CategoryPlotGlyph;
import com.fr.chart.chartglyph.ChartGlyph;
import com.fr.chart.chartglyph.DataSheetGlyph;
import com.fr.chart.chartglyph.GeneralGlyph;
import com.fr.chart.chartglyph.HeatMapControlBar;
import com.fr.chart.chartglyph.LegendGlyph;
import com.fr.chart.chartglyph.MapHotAreaColor;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.chart.chartglyph.PlotGlyph;
import com.fr.chart.chartglyph.RectangleGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.chart.chartglyph.StockPlotGlyph;
import com.fr.chart.chartglyph.TitleGlyph;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRFont;
import com.fr.stable.StringUtils;
import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class ChartGlyphLayout {
    private static final double DEFAULT_WIDTH = 507.0;
    private static final double DEFAULT_HEIGHT = 340.0;
    private static final double DEFAULT_GAP = 8.0;
    private static final double MIN_GAP = 4.0;
    private static final double MAX_GAP = 16.0;
    private static final double INCRE_ONE_PIX = 100.0;
    private static double WIDTH_GAP = 8.0;
    private static double HEIGHT_GAP = 8.0;
    private static double CHART_CHANGE_HEIGHT = 20.0;
    public static double ARROW_WIDTH = 10.0;
    public static double ARROW_HEIGHT = 5.0;
    private static int TEST_GAP = 30;
    private static int COMBINE_GAP = 22;
    private static int FONT_HEIGHT = 12;
    private static int SHORT_WIDTH_GAP = 5;
    private static int SHORT_HEIGHT_GAP = 10;

    public static void doLayout(ChartGlyph chartGlyph, int n) {
        if (chartGlyph == null || chartGlyph.getBounds() == null) {
            return;
        }
        Rectangle2D rectangle2D = chartGlyph.getBounds();
        Rectangle2D rectangle2D2 = chartGlyph.getBounds();
        ChartGlyphLayout.preMoreChangeChart(chartGlyph, rectangle2D2);
        ChartGlyphLayout.preGap4ChartBorder(chartGlyph, rectangle2D2);
        ChartGlyphLayout.preGap4ChartInPadding(rectangle2D2);
        ChartGlyphLayout.titleGlyphDoLayout(rectangle2D2, chartGlyph.getTitleGlyph(), n);
        ChartGlyphLayout.calculatorDataSheetCateUnitLength(rectangle2D, rectangle2D2, chartGlyph, n);
        ChartGlyphLayout.legendDoLayoutWithLeftBounds(rectangle2D, rectangle2D2, chartGlyph, n);
        ChartGlyphLayout.makeSureDataSheetBounds(rectangle2D2, chartGlyph, n);
        ChartGlyphLayout.plotDoLayout(rectangle2D2, chartGlyph, n);
        ChartGlyphLayout.dataSheetDoLayoutWithPlotGlyph(chartGlyph);
    }

    public static void makeSureDataSheetBounds(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n) {
        Object v = chartGlyph.getDataSheetGlyph();
        if (v == null) {
            return;
        }
        Dimension2D dimension2D = ((DataSheetGlyph)v).getPrefferedSize(chartGlyph, n);
        double d = dimension2D.getHeight();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + rectangle2D.getHeight() - d, rectangle2D.getWidth(), d);
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d);
        ((RectangleGlyph)v).setBounds(double_);
    }

    private static void preMoreChangeChart(ChartGlyph chartGlyph, Rectangle2D rectangle2D) {
        if (chartGlyph.isUseChangeChart()) {
            rectangle2D.setFrame(rectangle2D.getX(), rectangle2D.getY() + CHART_CHANGE_HEIGHT, rectangle2D.getWidth(), rectangle2D.getHeight() - CHART_CHANGE_HEIGHT);
        }
    }

    public static void preGap4ChartBorder(ChartGlyph chartGlyph, Rectangle2D rectangle2D) {
        double d = GraphHelper.getLineStyleSize((int)chartGlyph.getBorderStyle());
        rectangle2D.setFrame(rectangle2D.getX() + d, rectangle2D.getY() + d, rectangle2D.getWidth() - d * 2.0, rectangle2D.getHeight() - d * 2.0);
    }

    public static void preGap4ChartInPadding(Rectangle2D rectangle2D) {
        WIDTH_GAP = Math.min(16.0, Math.max(4.0, 8.0 + (rectangle2D.getWidth() - 507.0) / 100.0));
        HEIGHT_GAP = Math.min(16.0, Math.max(4.0, 8.0 + (rectangle2D.getHeight() - 340.0) / 100.0));
        rectangle2D.setFrame(rectangle2D.getX() + WIDTH_GAP, rectangle2D.getY() + HEIGHT_GAP, rectangle2D.getWidth() - WIDTH_GAP * 2.0, rectangle2D.getHeight() - HEIGHT_GAP * 2.0);
    }

    public static void titleGlyphDoLayout(Rectangle2D rectangle2D, TitleGlyph titleGlyph, int n) {
        if (titleGlyph == null || StringUtils.isEmpty((String)titleGlyph.getText()) || !titleGlyph.isVisible()) {
            return;
        }
        titleGlyph.layoutTitleAndRefreshChartBounds(rectangle2D, WIDTH_GAP, HEIGHT_GAP, n);
    }

    public static void legendDoLayoutWithLeftBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, ChartGlyph chartGlyph, int n) {
        Object u = chartGlyph.getLegendGlyph();
        if (u == null || !((RectangleGlyph)u).isVisible()) {
            return;
        }
        if (chartGlyph.getPlotGlyph() != null && ComparatorUtils.equals((String)((PlotGlyph)chartGlyph.getPlotGlyph()).getPlotGlyphType(), (String)"MapPlotGlyph")) {
            ChartGlyphLayout.mapLegendDoLayoutWithLeftBounds(rectangle2D, rectangle2D2, chartGlyph, n, u);
        } else {
            ((LegendGlyph)u).layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, WIDTH_GAP, HEIGHT_GAP, n);
        }
    }

    private static void mapLegendDoLayoutWithLeftBounds(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, ChartGlyph chartGlyph, int n, LegendGlyph legendGlyph) {
        Rectangle2D.Double double_;
        double d;
        MapPlotGlyph mapPlotGlyph = (MapPlotGlyph)chartGlyph.getPlotGlyph();
        boolean bl = mapPlotGlyph.getMapType() != ChartEnumDefinitions.MapType.Map_Normal;
        boolean bl2 = mapPlotGlyph.isHeatMap();
        boolean bl3 = mapPlotGlyph.isSvgMap();
        if (!bl3 || bl && !bl2) {
            legendGlyph.layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, WIDTH_GAP, HEIGHT_GAP, n);
            return;
        }
        int n2 = legendGlyph.getPosition();
        MapHotAreaColor mapHotAreaColor = mapPlotGlyph.getAreaColors();
        TextAttr textAttr = new TextAttr();
        if (legendGlyph.getFont() != null) {
            textAttr.setFRFont(legendGlyph.getFont());
        } else {
            textAttr.setFRFont(FRFont.getInstance((String)"Microsoft YaHei", (int)0, (float)9.0f, (Color)Color.black));
        }
        Dimension2D dimension2D = ChartGlyphLayout.getControlBarDimension(n2, mapHotAreaColor, rectangle2D2, textAttr, n);
        boolean bl4 = false;
        if (n2 == 1 || n2 == 3) {
            d = dimension2D.getWidth() + WIDTH_GAP * 2.0 + (double)TEST_GAP;
            bl4 = d < rectangle2D2.getWidth();
            double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() - d, rectangle2D2.getHeight());
        } else {
            d = dimension2D.getHeight() + HEIGHT_GAP * 2.0 + (double)TEST_GAP;
            bl4 = d < rectangle2D2.getHeight();
            double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() - d);
        }
        if (bl4) {
            Dimension2D dimension2D2 = legendGlyph.prefferedLegendSizeWithChartBounds(double_, n);
            double d2 = ChartGlyphLayout.getLegendStartX(n2, dimension2D, dimension2D2, rectangle2D2);
            double d3 = ChartGlyphLayout.getLegendStartY(n2, dimension2D, dimension2D2, rectangle2D2);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d3, dimension2D.getWidth(), dimension2D.getHeight());
            Rectangle2D.Double double_3 = n2 == 1 || n2 == 3 ? new Rectangle2D.Double(((RectangularShape)double_2).getX() + dimension2D.getWidth() + (double)COMBINE_GAP, ((RectangularShape)double_2).getY(), dimension2D2.getWidth(), dimension2D2.getHeight()) : new Rectangle2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY() + dimension2D.getHeight() + (double)COMBINE_GAP, dimension2D2.getWidth(), dimension2D2.getHeight());
            legendGlyph.changeLegendBounds(double_3, n);
            ChartGlyphLayout.makeBoundsInCenter(double_2, double_3, n2);
            n2 = n2 == 8 ? 4 : n2;
            chartGlyph.setMapControlBar(new HeatMapControlBar(double_2, n2, mapHotAreaColor, n, textAttr));
            ChartGlyphLayout.refreshChartBoundsWithControlBar(n2, rectangle2D2, double_2, double_3);
        } else {
            legendGlyph.layoutLegendAndRefreshChartBounds(rectangle2D, rectangle2D2, WIDTH_GAP, HEIGHT_GAP, n);
        }
    }

    private static void makeBoundsInCenter(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (n == 1 || n == 3) {
            double d;
            double d2 = rectangle2D.getHeight();
            if (d2 > (d = rectangle2D2.getHeight())) {
                rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D.getY() + (d2 - d) / 2.0, rectangle2D2.getWidth(), rectangle2D2.getHeight());
            } else {
                rectangle2D.setRect(rectangle2D.getX(), rectangle2D2.getY() + (d - d2) / 2.0, rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        } else {
            double d;
            double d3 = rectangle2D.getWidth();
            if (d3 > (d = rectangle2D2.getWidth())) {
                rectangle2D2.setRect(rectangle2D.getX() + (d3 - d) / 2.0, rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
            } else {
                rectangle2D.setRect(rectangle2D2.getX() + (d - d3) / 2.0, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        }
    }

    private static Dimension2D getControlBarDimension(int n, MapHotAreaColor mapHotAreaColor, Rectangle2D rectangle2D, TextAttr textAttr, int n2) {
        if (n == 1 || n == 3) {
            return ChartGlyphLayout.getControlBarDimensionTopAndBottom(mapHotAreaColor, rectangle2D, textAttr, n2);
        }
        return ChartGlyphLayout.getControlBarDimensionLeftAndRight(mapHotAreaColor, rectangle2D, textAttr, n2);
    }

    private static Dimension2D getControlBarDimensionTopAndBottom(MapHotAreaColor mapHotAreaColor, Rectangle2D rectangle2D, TextAttr textAttr, int n) {
        int n2 = 26;
        int n3 = 13;
        int n4 = 1;
        int n5 = mapHotAreaColor.getAreaNumber();
        String string = mapHotAreaColor.getMaxLabelWithIndex(0);
        String string2 = mapHotAreaColor.getMinLabelWithIndex(n5 - 1);
        Dimension2D dimension2D = GlyphUtils.calculateTextDimensionWithNoRotation(String.valueOf(string), textAttr, n);
        double d = dimension2D.getWidth();
        double d2 = GlyphUtils.calculateTextDimensionWithNoRotation(String.valueOf(string2), textAttr, n).getWidth();
        double d3 = dimension2D.getHeight();
        double d4 = (d + d2) / 2.0 + (double)(n2 * n5) + (double)(n4 * (n5 - 1));
        double d5 = d3 * 2.0 + (double)SHORT_HEIGHT_GAP + (double)n3;
        return new DoubleDimension2D(d4, d5);
    }

    private static Dimension2D getControlBarDimensionLeftAndRight(MapHotAreaColor mapHotAreaColor, Rectangle2D rectangle2D, TextAttr textAttr, int n) {
        int n2 = 13;
        int n3 = 26;
        int n4 = 1;
        int n5 = mapHotAreaColor.getAreaNumber();
        double d = n3 * n5 + n4 * (n5 - 1) + FONT_HEIGHT;
        double d2 = 0.0;
        String[] stringArray = mapHotAreaColor.getNumberLabels();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            d2 = Math.max(GlyphUtils.calculateTextDimensionWithNoRotation(String.valueOf(string), textAttr, n).getWidth(), d2);
        }
        double d3 = d2 + (double)SHORT_WIDTH_GAP + (double)n2;
        d3 = Math.min(0.28 * rectangle2D.getWidth(), d3);
        return new DoubleDimension2D(d3, d);
    }

    private static double getLegendStartX(int n, Dimension2D dimension2D, Dimension2D dimension2D2, Rectangle2D rectangle2D) {
        if (n == 1 || n == 3) {
            return rectangle2D.getX() + (rectangle2D.getWidth() - dimension2D.getWidth() - dimension2D2.getWidth() - (double)COMBINE_GAP) / 2.0;
        }
        if (n == 2) {
            return rectangle2D.getX();
        }
        return rectangle2D.getX() + rectangle2D.getWidth() - Math.max(dimension2D.getWidth(), dimension2D2.getWidth());
    }

    private static double getLegendStartY(int n, Dimension2D dimension2D, Dimension2D dimension2D2, Rectangle2D rectangle2D) {
        if (n == 2 || n == 4) {
            return rectangle2D.getY() + (rectangle2D.getHeight() - dimension2D.getHeight() - dimension2D2.getHeight() - (double)COMBINE_GAP) / 2.0;
        }
        if (n == 8 || n == 1) {
            return rectangle2D.getY();
        }
        return rectangle2D.getY() + rectangle2D.getHeight() - Math.max(dimension2D.getHeight(), dimension2D2.getHeight());
    }

    private static void refreshChartBoundsWithControlBar(int n, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        if (n == 1 || n == 3) {
            ChartGlyphLayout.refreshChartBoundsWithControlBarTopAndBottom(n, rectangle2D, rectangle2D2, rectangle2D3);
        } else {
            ChartGlyphLayout.refreshChartBoundsWithControlBarLeftAndRight(n, rectangle2D, rectangle2D2, rectangle2D3);
        }
    }

    private static void refreshChartBoundsWithControlBarTopAndBottom(int n, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.max(rectangle2D2.getHeight(), rectangle2D3.getHeight());
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY() + (n == 1 ? d : 0.0), rectangle2D.getWidth(), rectangle2D.getHeight() - d);
    }

    private static void refreshChartBoundsWithControlBarLeftAndRight(int n, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.max(rectangle2D2.getWidth(), rectangle2D3.getWidth());
        rectangle2D.setRect(rectangle2D.getX() + (n == 2 ? d : 0.0), rectangle2D.getY(), rectangle2D.getWidth() - d, rectangle2D.getHeight());
    }

    private static void calculatorDataSheetCateUnitLength(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, ChartGlyph chartGlyph, int n) {
        Object v = chartGlyph.getDataSheetGlyph();
        if (v == null) {
            return;
        }
        Object t = chartGlyph.getPlotGlyph();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight());
        ChartGlyphLayout.legendDoLayoutWithLeftBounds(rectangle2D, double_, chartGlyph, n);
        ChartGlyphLayout.justAxisDoLayout(double_, chartGlyph, n);
        Object v2 = chartGlyph.getDataSheetGlyph();
        Rectangle2D rectangle2D3 = ((RectangleGlyph)v2).getBounds();
        if (t != null && v2 != null) {
            int n2 = 0;
            if (t instanceof CategoryPlotGlyph) {
                int n3 = ((CategoryPlotGlyph)t).getxAxisGlyph().getPosition();
                if (n3 == 1 || n3 == 3) {
                    n2 = (int)((CategoryPlotGlyph)t).getxAxisGlyph().getBounds().getWidth() / ((PlotGlyph)t).getCategoryCount();
                } else {
                    int n4 = (int)((CategoryPlotGlyph)t).getyAxisGlyph().getBounds().getX() + (int)((RectangleGlyph)t).getBounds().getX();
                    n2 = (int)(rectangle2D3.getX() + rectangle2D3.getWidth() - (double)n4) / ((PlotGlyph)t).getCategoryCount();
                }
            } else if (t instanceof StockPlotGlyph) {
                n2 = (int)((StockPlotGlyph)t).getxAxisGlyph().getUnitLen();
            }
            ((DataSheetGlyph)v2).setUnitLength(n2);
        }
    }

    public static void plotDoLayout(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n) {
        Object t = chartGlyph.getPlotGlyph();
        if (t == null) {
            return;
        }
        ChartGlyphLayout.justAxisDoLayout(rectangle2D, chartGlyph, n);
        ((PlotGlyph)t).layoutDataSeriesGlyph(n);
        if (((GeneralGlyph)t).getRoundRadius() > 0) {
            ((RectangleGlyph)t).setBounds(ChartBaseUtils.rectangle2RoundRectangle(((RectangleGlyph)t).getBounds(), ((GeneralGlyph)t).getRoundRadius()));
        } else {
            ((RectangleGlyph)t).setBounds(ChartBaseUtils.rectangle2RoundRectangle(((RectangleGlyph)t).getBounds(), ((GeneralGlyph)t).isRoundBorder()));
        }
    }

    private static void justAxisDoLayout(Rectangle2D rectangle2D, ChartGlyph chartGlyph, int n) {
        Object object;
        double d;
        Object t = chartGlyph.getPlotGlyph();
        if (t == null) {
            return;
        }
        double d2 = ((PlotGlyph)t).getPreGap4AxisRightUnit();
        double d3 = ((PlotGlyph)t).getPreGap4AxisTopUnit();
        double d4 = ((PlotGlyph)t).getPreLeft4DataSheet(n);
        Object v = chartGlyph.getDataSheetGlyph();
        double d5 = 0.0;
        if (v != null) {
            d = ((DataSheetGlyph)v).getPrefferedSize(chartGlyph, n).getWidth();
            d5 = d4 > d ? 0.0 : d - d4;
        }
        d = 0.0;
        double d6 = 0.0;
        if (t instanceof RectanglePlotGlyph) {
            object = (RectanglePlotGlyph)t;
            if (((RectanglePlotGlyph)object).getxAxisGlyph() != null && ((RectanglePlotGlyph)object).getxAxisGlyph().isArrowShow()) {
                d = ARROW_WIDTH;
            }
            if (((RectanglePlotGlyph)object).getyAxisGlyph() != null && ((RectanglePlotGlyph)object).getyAxisGlyph().isArrowShow()) {
                d6 = ARROW_HEIGHT;
            }
        }
        object = new Rectangle2D.Double(rectangle2D.getX() + d5, rectangle2D.getY() + d3 + d6, rectangle2D.getWidth() - d5 - d2 - d, rectangle2D.getHeight() - d3 - d6);
        ((RectangleGlyph)t).setBounds((RectangularShape)object);
        ((PlotGlyph)t).layoutAxisGlyph(n);
    }

    public static void dataSheetDoLayoutWithPlotGlyph(ChartGlyph chartGlyph) {
        Object v = chartGlyph.getDataSheetGlyph();
        if (v != null) {
            ((DataSheetGlyph)v).doLayout((PlotGlyph)chartGlyph.getPlotGlyph());
        }
    }
}

