/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.chart.chartdata.BaseMapAreaValue;
import com.fr.chart.chartdata.BaseMapTitleValue;
import com.fr.chart.chartdata.MapTitleValue;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class MapAreaValue
implements BaseMapAreaValue {
    private List titleValues = new ArrayList();

    public MapAreaValue() {
    }

    public MapAreaValue(BaseMapTitleValue baseMapTitleValue) {
        this.titleValues.add(baseMapTitleValue);
    }

    public boolean isTitleValueNull() {
        if (this.titleValues.size() <= 0) {
            return true;
        }
        boolean bl = true;
        int n = this.titleValues.size();
        for (int i = 0; i < n; ++i) {
            BaseMapTitleValue baseMapTitleValue = (BaseMapTitleValue)this.titleValues.get(i);
            if (!StringUtils.isNotEmpty((String)baseMapTitleValue.getTitle())) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public double getFirstTitleValue() {
        if (this.titleValues.size() <= 0) {
            return 0.0;
        }
        BaseMapTitleValue baseMapTitleValue = (BaseMapTitleValue)this.titleValues.get(0);
        return baseMapTitleValue.getValue();
    }

    public String getFirstStringValue() {
        if (this.titleValues.size() <= 0) {
            return "";
        }
        BaseMapTitleValue baseMapTitleValue = (BaseMapTitleValue)this.titleValues.get(0);
        return baseMapTitleValue.getStringValue();
    }

    public double getTitleValueByIndex(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.titleValues.size() <= 0 || n >= this.titleValues.size()) {
            return 0.0;
        }
        return ((BaseMapTitleValue)this.titleValues.get(n)).getValue();
    }

    public double getMaxValueExcept(int n) {
        double d = 0.0;
        int n2 = this.titleValueSize();
        for (int i = 0; i < n2; ++i) {
            if (i == n) continue;
            MapTitleValue mapTitleValue = this.getTitleValue(i);
            d = Math.max(d, mapTitleValue.getValue());
        }
        return d;
    }

    public void clearTitleValues() {
        this.titleValues.clear();
    }

    public void addTitleValue(BaseMapTitleValue baseMapTitleValue) {
        this.titleValues.add(baseMapTitleValue);
    }

    public MapTitleValue getTitleValue(int n) {
        if (n >= 0 && n < this.titleValues.size()) {
            return (MapTitleValue)this.titleValues.get(n);
        }
        MapTitleValue mapTitleValue = new MapTitleValue();
        this.addTitleValue(mapTitleValue);
        return mapTitleValue;
    }

    public int titleValueSize() {
        return this.titleValues.size();
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        int n = this.titleValues.size();
        for (int i = 0; i < n; ++i) {
            MapTitleValue mapTitleValue = (MapTitleValue)this.titleValues.get(i);
            jSONArray.put((Object)mapTitleValue.toJSONObject());
        }
        jSONObject.put("titleValues", (Object)jSONArray);
        return jSONObject;
    }

    public JSONObject toStringValueJSONObject() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        int n = this.titleValues.size();
        for (int i = 0; i < n; ++i) {
            MapTitleValue mapTitleValue = (MapTitleValue)this.titleValues.get(i);
            jSONArray.put((Object)mapTitleValue.toStringValueJSONObject());
        }
        jSONObject.put("titleValues", (Object)jSONArray);
        return jSONObject;
    }
}

