/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartAxisPosition;
import com.fr.chart.chartattr.RectanglePlot;
import com.fr.chart.chartattr.ValueAxis;
import com.fr.chart.chartdata.TopChartData;
import com.fr.chart.chartglyph.AxisGlyph;
import com.fr.chart.chartglyph.RectanglePlotGlyph;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;

public abstract class XYPlot
extends RectanglePlot {
    private static final long serialVersionUID = -7820354209332093183L;
    private static final double MAXBU = 500.0;
    private static final double MINBU = 300.0;

    public XYPlot() {
        this.setxAxis(new ValueAxis(3));
        this.setyAxis(new ValueAxis(2));
    }

    public void installAxisGlyph(RectanglePlotGlyph rectanglePlotGlyph, ChartData chartData) {
        AxisGlyph axisGlyph = this.getxAxis().createAxisGlyph(chartData);
        axisGlyph.setAxisType("xAxis");
        rectanglePlotGlyph.setxAxisGlyph(axisGlyph);
        double d = this.getMaxValue4XValue(chartData);
        double d2 = this.getMinValue4XValue(chartData, axisGlyph.isLog());
        double d3 = (d - d2) * this.getMarkerSize() / 500.0;
        axisGlyph.initMinMaxValue(d2 -= d3, d += d3);
        AxisGlyph axisGlyph2 = this.getyAxis().createAxisGlyph(chartData);
        axisGlyph2.setAxisType("yAxis");
        rectanglePlotGlyph.setyAxisGlyph(axisGlyph2);
        d = this.getMaxValueFromData(chartData, ChartAxisPosition.AXIS_LEFT);
        d2 = this.getMinValueFromData(chartData, axisGlyph2.isLog(), ChartAxisPosition.AXIS_LEFT);
        d3 = (d - d2) * this.getMarkerSize() / 300.0;
        axisGlyph2.initMinMaxValue(d2 -= d3, d += d3);
        rectanglePlotGlyph.axisExtendsMaxMinValueWithTrendLine(axisGlyph);
    }

    public String[] getAlertLinePaneTitle() {
        return new String[]{"X_Axis", "Y_Axis"};
    }

    protected abstract double getMaxValue4XValue(ChartData var1);

    public double getMinValue4XValue(ChartData chartData, boolean bl) {
        TopChartData topChartData = (TopChartData)chartData;
        double d = 0.0;
        if (bl) {
            d = Double.MAX_VALUE;
        }
        for (int i = 0; i < topChartData.getItemCount(); ++i) {
            for (int j = 0; j < topChartData.getCategoryLabelCount(); ++j) {
                Number number = topChartData.getX(i, j);
                if (number == null) continue;
                if (bl) {
                    if (!(number.doubleValue() > 0.0) || !(number.doubleValue() < d)) continue;
                    d = number.doubleValue();
                    continue;
                }
                d = d < number.doubleValue() ? d : number.doubleValue();
            }
        }
        if (bl && d == Double.MAX_VALUE) {
            d = 1.0;
        }
        return d;
    }

    protected double getMarkerSize() {
        return 0.0;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("XAxis".equals(string)) {
                this.setxAxis((ValueAxis)xMLableReader.readXMLObject((XMLReadable)new ValueAxis()));
            } else if ("YAxis".equals(string)) {
                this.setyAxis((ValueAxis)xMLableReader.readXMLObject((XMLReadable)new ValueAxis()));
            } else if (string.equals("XYAttr")) {
                boolean bl = false;
                String string2 = xMLableReader.getAttrAsString("bgStagger", null);
                if (string2 != null) {
                    bl = Boolean.valueOf(string2);
                }
                if (bl && (string2 = xMLableReader.getAttrAsString("bgColor", null)) != null) {
                    this.setHorizontalIntervalBackgroundColor(xMLableReader.getAttrAsColor("bgColor", null));
                }
            }
        }
    }
}

