/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.base;

import com.fr.base.chart.ChangeConfigProvider;
import com.fr.chart.base.AttrChangeType;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.TextAttr;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.StableUtils;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.awt.Color;

public class AttrChangeConfig
implements XMLable,
ChangeConfigProvider {
    public static final String XML_TAG = "ChangeAttr";
    private static final int DEFAULT_TIME = 5;
    private boolean enable = false;
    private AttrChangeType changeType = AttrChangeType.BUTTON;
    private TextAttr styleAttr = new TextAttr();
    private Color buttonColor = new Color(127, 127, 127);
    private Color carouselColor = new Color(127, 127, 127);
    private int timeInterval = 5;
    private static final double MS = 1000.0;

    public AttrChangeType getChangeType() {
        return this.changeType;
    }

    public void setChangeType(AttrChangeType attrChangeType) {
        this.changeType = attrChangeType;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
        if (this.enable) {
            return;
        }
        this.resetAttr();
    }

    private void resetAttr() {
        this.changeType = AttrChangeType.BUTTON;
        this.styleAttr = new TextAttr();
        this.buttonColor = new Color(127, 127, 127);
        this.carouselColor = new Color(127, 127, 127);
        this.timeInterval = 5;
    }

    public TextAttr getStyleAttr() {
        return this.styleAttr;
    }

    public void setStyleAttr(TextAttr textAttr) {
        this.styleAttr = textAttr;
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color color) {
        this.buttonColor = color;
    }

    public Color getCarouselColor() {
        return this.carouselColor;
    }

    public void setCarouselColor(Color color) {
        this.carouselColor = color;
    }

    public int getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(int n) {
        this.timeInterval = n;
    }

    public Object clone() throws CloneNotSupportedException {
        AttrChangeConfig attrChangeConfig = (AttrChangeConfig)super.clone();
        attrChangeConfig.setEnable(this.isEnable());
        attrChangeConfig.setCarouselColor(this.getCarouselColor());
        attrChangeConfig.setButtonColor(this.getButtonColor());
        attrChangeConfig.setStyleAttr((TextAttr)this.getStyleAttr().clone());
        attrChangeConfig.setChangeType(this.getChangeType());
        attrChangeConfig.setTimeInterval(this.getTimeInterval());
        return attrChangeConfig;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        if (xMLableReader.isChildNode() && XML_TAG.equals(string = xMLableReader.getTagName())) {
            this.setEnable(xMLableReader.getAttrAsBoolean("enable", false));
            this.setChangeType(AttrChangeType.parse(xMLableReader.getAttrAsString("changeType", "button")));
            this.setTimeInterval(xMLableReader.getAttrAsInt("timeInterval", 5));
            this.setButtonColor(xMLableReader.getAttrAsColor("buttonColor", null));
            this.setCarouselColor(xMLableReader.getAttrAsColor("carouselColor", null));
            this.setStyleAttr((TextAttr)xMLableReader.readXMLObject((XMLReadable)new TextAttr()));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG(XML_TAG).attr("enable", this.isEnable()).attr("changeType", this.getChangeType().getType()).attr("timeInterval", this.timeInterval).attr("buttonColor", this.buttonColor.getRGB()).attr("carouselColor", this.carouselColor.getRGB());
        this.getStyleAttr().writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public boolean equals(Object object) {
        return object instanceof AttrChangeConfig && this.isEnable() == ((AttrChangeConfig)object).isEnable() && ComparatorUtils.equals((Object)this.getButtonColor(), (Object)((AttrChangeConfig)object).getButtonColor()) && ComparatorUtils.equals((Object)this.getCarouselColor(), (Object)((AttrChangeConfig)object).getCarouselColor()) && this.getChangeType() == ((AttrChangeConfig)object).getChangeType() && this.getTimeInterval() == ((AttrChangeConfig)object).getTimeInterval() && ComparatorUtils.equals((Object)this.getStyleAttr(), (Object)((AttrChangeConfig)object).getStyleAttr());
    }

    public JSONObject toJSONObject(Repository repository) throws JSONException {
        JSONObject jSONObject = JSONObject.create();
        jSONObject.put("type", (Object)(this.changeType == AttrChangeType.BUTTON ? "button" : "carousel"));
        switch (this.changeType) {
            case BUTTON: {
                jSONObject.put("color", (Object)StableUtils.javaColorToCSSColor((Color)this.buttonColor));
                break;
            }
            case CAROUSEL: {
                jSONObject.put("color", (Object)StableUtils.javaColorToCSSColor((Color)this.carouselColor));
                break;
            }
            default: {
                jSONObject.put("color", (Object)"");
            }
        }
        jSONObject.put("style", (Object)ChartBaseUtils.getCSSFontJSON(this.getStyleAttr().getFRFont(), repository));
        jSONObject.put("interval", (double)this.getTimeInterval() * 1000.0);
        return jSONObject;
    }

    public boolean useChangeModel() {
        return this.isEnable();
    }
}

