/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.Vector;
import org.freehep.graphicsio.CubicToQuadPathConstructor;
import org.freehep.graphicsio.swf.SWFConstants;
import org.freehep.graphicsio.swf.SWFShape;

public class SWFPathConstructor
extends CubicToQuadPathConstructor
implements SWFConstants {
    private Vector path;
    private int x0;
    private int y0;
    private int xc;
    private int yc;
    private int stroke;
    private int fill0;
    private int fill1;

    public SWFPathConstructor(Vector vector, int n2, int n3, int n4) {
        this(vector, n2, n3, n4, 0.025);
    }

    public SWFPathConstructor(Vector vector, int n2, int n3, int n4, double d2) {
        super(d2);
        this.path = vector;
        this.stroke = n2;
        this.fill0 = n3;
        this.fill1 = n4;
    }

    public void move(double d2, double d3) throws IOException {
        this.x0 = this.toInt(d2);
        this.y0 = this.toInt(d3);
        this.xc = this.x0;
        this.yc = this.y0;
        this.path.add(new SWFShape.ShapeRecord(true, this.xc, this.yc, this.fill0, this.fill1, this.stroke));
        super.move(d2, d3);
    }

    public void line(double d2, double d3) throws IOException {
        int n2 = this.toInt(d2) - this.xc;
        int n3 = this.toInt(d3) - this.yc;
        this.path.add(new SWFShape.EdgeRecord(n2, n3));
        this.xc += n2;
        this.yc += n3;
        super.line(d2, d3);
    }

    public void quad(double d2, double d3, double d4, double d5) throws IOException {
        int n2 = this.toInt(d2) - this.xc;
        int n3 = this.toInt(d3) - this.yc;
        int n4 = this.toInt(d4 - d2);
        int n5 = this.toInt(d5 - d3);
        this.path.add(new SWFShape.EdgeRecord(n2, n3, n4, n5));
        this.xc += n4 + n2;
        this.yc += n5 + n3;
        this.currentX = d4;
        this.currentY = d5;
    }

    public void closePath(double d2, double d3) throws IOException {
        if (this.xc != this.x0 || this.yc != this.y0) {
            this.path.add(new SWFShape.EdgeRecord(this.x0 - this.xc, this.y0 - this.yc));
        }
        super.closePath(d2, d3);
    }

    private int toInt(double d2) {
        return (int)(d2 * 20.0);
    }
}

