/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineSound
extends DefinitionTag {
    public static final int NONE = 0;
    public static final int ADPCM = 1;
    public static final int MP3 = 2;
    public static final int NELLYMOSER = 3;
    public static final int RATE_5_5 = 0;
    public static final int RATE_11 = 1;
    public static final int RATE_22 = 2;
    public static final int RATE_44 = 3;
    public static final int BYTE = 0;
    public static final int SHORT = 1;
    public static final int MONO = 0;
    public static final int STEREO = 1;
    private int character;
    private int format;
    private int rate;
    private int size;
    private boolean stereo;
    private long samples;
    private int[] data;

    public DefineSound(int n2, int n3, int n4, int n5, boolean bl, long l2, int[] nArray) {
        this();
        this.character = n2;
        this.format = n3;
        this.rate = n4;
        this.size = n5;
        this.stereo = bl;
        this.samples = l2;
        this.data = nArray;
    }

    public DefineSound() {
        super(14, 1);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineSound defineSound = new DefineSound();
        defineSound.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(defineSound.character, defineSound);
        defineSound.format = (int)sWFInputStream.readUBits(4);
        defineSound.rate = (int)sWFInputStream.readUBits(2);
        defineSound.size = sWFInputStream.readBitFlag() ? 1 : 0;
        defineSound.stereo = sWFInputStream.readBitFlag();
        defineSound.samples = sWFInputStream.readUnsignedInt();
        defineSound.data = sWFInputStream.readUnsignedByte(n3 - 7);
        return defineSound;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeUBits(this.format, 4);
        sWFOutputStream.writeUBits(this.rate, 2);
        sWFOutputStream.writeBitFlag(this.size == 1);
        sWFOutputStream.writeBitFlag(this.stereo);
        sWFOutputStream.writeUnsignedInt(this.samples);
        sWFOutputStream.writeUnsignedByte(this.data);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString() + "\n");
        stringBuffer.append("  character:  " + this.character + "\n");
        stringBuffer.append("  format:" + this.format + "\n");
        stringBuffer.append("  rate:" + this.rate + "\n");
        stringBuffer.append("  size:" + this.size + "\n");
        stringBuffer.append("  stereo:" + this.stereo + "\n");
        stringBuffer.append("  samples:" + this.samples + "\n");
        stringBuffer.append("  length:" + this.data.length + "\n");
        return stringBuffer.toString();
    }
}

