/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.gif;

import java.awt.Component;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.exportchooser.ImageExportFileType;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionComboBox;
import org.freehep.graphicsio.gif.GIFGraphics2D;
import org.freehep.graphicsio.gif.GIFImageWriterSpi;
import org.freehep.util.UserProperties;

public class GIFExportFileType
extends ImageExportFileType {
    public static final String[] quantizeModes;

    public GIFExportFileType() {
        super(new GIFImageWriterSpi());
    }

    public boolean hasOptionPanel() {
        return true;
    }

    public JPanel createOptionPanel(Properties properties) {
        UserProperties userProperties = new UserProperties(properties, GIFGraphics2D.getDefaultProperties());
        JPanel jPanel = super.createOptionPanel(userProperties);
        OptionCheckBox optionCheckBox = new OptionCheckBox(userProperties, GIFGraphics2D.QUANTIZE_COLORS, "Quantize Colors");
        jPanel.add("0 * * 1 [5 15 5 15] w", optionCheckBox);
        JLabel jLabel = new JLabel("Quantize using ");
        jPanel.add("0 * [5 15 5 15] r", jLabel);
        optionCheckBox.enables(jLabel);
        OptionComboBox optionComboBox = new OptionComboBox(userProperties, GIFGraphics2D.QUANTIZE_MODE, quantizeModes);
        jPanel.add("1 * [5 15 5 15] lw", optionComboBox);
        optionCheckBox.enables(optionComboBox);
        optionCheckBox.setEnabled(false);
        jLabel.setEnabled(false);
        optionComboBox.setEnabled(false);
        return jPanel;
    }

    public VectorGraphics getGraphics(OutputStream outputStream, Component component) throws IOException {
        return new GIFGraphics2D(outputStream, component.getSize());
    }

    static {
        try {
            Class<?> clazz = Class.forName("org.freehep.graphicsio.gif.GIFImageWriterSpi");
            IIORegistry.getDefaultInstance().registerServiceProvider((ImageWriterSpi)clazz.newInstance(), ImageWriterSpi.class);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        quantizeModes = new String[]{"NeuQuant"};
    }
}

