/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SymbolShape
implements Shape {
    private static final double SQRT_2 = Math.sqrt(2.0);
    private static final double SQRT_3 = Math.sqrt(3.0);
    private double[] points;
    private int[] type;
    private ArrayPathIterator pathIterator;
    private double x;
    private double y;
    private double size;
    private int symbol;

    public SymbolShape() {
        this.ensureNumberOfPoints(10);
        this.type[0] = 0;
        for (int i2 = 1; i2 < this.type.length; ++i2) {
            this.type[i2] = 1;
        }
        this.pathIterator = new ArrayPathIterator(this.points, this.type);
    }

    public boolean contains(double d2, double d3) {
        return this.getBounds2D().contains(d2, d3);
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.contains(d2, d3) && this.contains(d2 + d4, d3) && this.contains(d2, d3 + d5) && this.contains(d2 + d4, d3 + d5);
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        return this.contains(d2, d3) || this.contains(d2 + d4, d3) || this.contains(d2, d3 + d5) || this.contains(d2 + d4, d3 + d5);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return this.getPathIterator(affineTransform);
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x - this.size / 2.0, this.y - this.size / 2.0, this.size, this.size);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (affineTransform != null) {
            affineTransform.transform(this.points, 0, this.pathIterator.points, 0, this.points.length / 2);
        }
        this.pathIterator.reset();
        return this.pathIterator;
    }

    private void createNew(int n2) {
        this.ensureNumberOfPoints(n2);
        this.pathIterator.numberOfPoints = n2;
        this.pathIterator.done();
    }

    public void create(int n2, double d2, double d3, double d4) {
        this.symbol = n2;
        this.x = d2;
        this.y = d3;
        this.size = d4;
        switch (n2) {
            case 0: {
                this.createVLine(d2, d3, d4);
                break;
            }
            case 1: {
                this.createHLine(d2, d3, d4);
                break;
            }
            case 2: {
                this.createPlus(d2, d3, d4);
                break;
            }
            case 3: {
                this.createCross(d2, d3, d4);
                break;
            }
            case 4: {
                this.createStar(d2, d3, d4);
                break;
            }
            case 6: {
                this.createBox(d2, d3, d4);
                break;
            }
            case 7: {
                this.createUpTriangle(d2, d3, d4);
                break;
            }
            case 8: {
                this.createDownTriangle(d2, d3, d4);
                break;
            }
            case 9: {
                this.createDiamond(d2, d3, d4);
            }
        }
    }

    public String toString() {
        return this.getClass() + ": " + this.symbol + " (" + this.x + ", " + this.y + ") size: " + this.size;
    }

    private void createHLine(double d2, double d3, double d4) {
        this.createNew(2);
        this.type[0] = 0;
        this.points[0] = d2 - d4 / 2.0;
        this.points[1] = d3;
        this.type[1] = 1;
        this.points[2] = d2 + d4 / 2.0;
        this.points[3] = d3;
    }

    private void createVLine(double d2, double d3, double d4) {
        this.createNew(2);
        this.type[0] = 0;
        this.points[0] = d2;
        this.points[1] = d3 - d4 / 2.0;
        this.type[1] = 1;
        this.points[2] = d2;
        this.points[3] = d3 + d4 / 2.0;
    }

    private void createPlus(double d2, double d3, double d4) {
        this.createNew(4);
        double d5 = d4 / 2.0;
        this.type[0] = 0;
        this.points[0] = d2 + d5;
        this.points[1] = d3;
        this.type[1] = 1;
        this.points[2] = d2 - d5;
        this.points[3] = d3;
        this.type[2] = 0;
        this.points[4] = d2;
        this.points[5] = d3 + d5;
        this.type[3] = 1;
        this.points[6] = d2;
        this.points[7] = d3 - d5;
    }

    private void createCross(double d2, double d3, double d4) {
        this.createNew(4);
        double d5 = d4 / 2.0 / SQRT_2;
        this.type[0] = 0;
        this.points[0] = d2 - d5;
        this.points[1] = d3 - d5;
        this.type[1] = 1;
        this.points[2] = d2 + d5;
        this.points[3] = d3 + d5;
        this.type[2] = 0;
        this.points[4] = d2 + d5;
        this.points[5] = d3 - d5;
        this.type[3] = 1;
        this.points[6] = d2 - d5;
        this.points[7] = d3 + d5;
    }

    private void createStar(double d2, double d3, double d4) {
        this.createNew(8);
        double d5 = d4 / 2.0;
        this.type[0] = 0;
        this.points[0] = d2;
        this.points[1] = d3 - d5;
        this.type[1] = 1;
        this.points[2] = d2;
        this.points[3] = d3 + d5;
        this.type[2] = 0;
        this.points[4] = d2 - d5;
        this.points[5] = d3;
        this.type[3] = 1;
        this.points[6] = d2 + d5;
        this.points[7] = d3;
        d5 = d4 / 2.0 / SQRT_2;
        this.type[4] = 0;
        this.points[8] = d2 - d5;
        this.points[9] = d3 - d5;
        this.type[5] = 1;
        this.points[10] = d2 + d5;
        this.points[11] = d3 + d5;
        this.type[6] = 0;
        this.points[12] = d2 + d5;
        this.points[13] = d3 - d5;
        this.type[7] = 1;
        this.points[14] = d2 - d5;
        this.points[15] = d3 + d5;
    }

    private void createUpTriangle(double d2, double d3, double d4) {
        this.createNew(4);
        this.type[0] = 0;
        this.points[0] = d2;
        this.points[1] = d3 - d4 / SQRT_3;
        this.type[1] = 1;
        this.points[2] = d2 - d4 / 2.0;
        this.points[3] = d3 + (-d4 / SQRT_3 + d4 * SQRT_3 / 2.0);
        this.type[2] = 1;
        this.points[4] = d2 + d4 / 2.0;
        this.points[5] = d3 + (-d4 / SQRT_3 + d4 * SQRT_3 / 2.0);
        this.type[3] = 4;
    }

    private void createDownTriangle(double d2, double d3, double d4) {
        this.createNew(4);
        this.type[0] = 0;
        this.points[0] = d2;
        this.points[1] = d3 + d4 / SQRT_3;
        this.type[1] = 1;
        this.points[2] = d2 - d4 / 2.0;
        this.points[3] = d3 - (-d4 / SQRT_3 + d4 * SQRT_3 / 2.0);
        this.type[2] = 1;
        this.points[4] = d2 + d4 / 2.0;
        this.points[5] = d3 - (-d4 / SQRT_3 + d4 * SQRT_3 / 2.0);
        this.type[3] = 4;
    }

    private void createDiamond(double d2, double d3, double d4) {
        this.createNew(5);
        double d5 = d4 / 2.0;
        this.type[0] = 0;
        this.points[0] = d2 + d5;
        this.points[1] = d3;
        this.type[1] = 1;
        this.points[2] = d2;
        this.points[3] = d3 + d5;
        this.type[2] = 1;
        this.points[4] = d2 - d5;
        this.points[5] = d3;
        this.type[3] = 1;
        this.points[6] = d2;
        this.points[7] = d3 - d5;
        this.type[4] = 4;
    }

    private void createBox(double d2, double d3, double d4) {
        this.createNew(5);
        double d5 = d4 / SQRT_2 / 2.0;
        this.type[0] = 0;
        this.points[0] = d2 - d5;
        this.points[1] = d3 - d5;
        this.type[1] = 1;
        this.points[2] = d2 + d5 + 1.0;
        this.points[3] = d3 - d5;
        this.type[2] = 1;
        this.points[4] = d2 + d5 + 1.0;
        this.points[5] = d3 + d5 + 1.0;
        this.type[3] = 1;
        this.points[6] = d2 - d5;
        this.points[7] = d3 + d5 + 1.0;
        this.type[4] = 4;
    }

    private void ensureNumberOfPoints(int n2) {
        if (this.type == null || this.type.length < n2) {
            this.points = new double[n2 * 2];
            this.type = new int[n2];
        }
    }

    private class ArrayPathIterator
    implements PathIterator {
        private int currentPoint = 0;
        private double[] points;
        private int[] type;
        private int numberOfPoints;

        private ArrayPathIterator(double[] dArray, int[] nArray) {
            this.points = dArray;
            this.type = nArray;
        }

        public boolean isDone() {
            return this.currentPoint >= this.numberOfPoints;
        }

        public void next() {
            ++this.currentPoint;
        }

        public int currentSegment(double[] dArray) {
            dArray[0] = this.points[2 * this.currentPoint];
            dArray[1] = this.points[2 * this.currentPoint + 1];
            return this.type[this.currentPoint];
        }

        public int currentSegment(float[] fArray) {
            fArray[0] = (float)this.points[2 * this.currentPoint];
            fArray[1] = (float)this.points[2 * this.currentPoint + 1];
            return this.type[this.currentPoint];
        }

        public int getWindingRule() {
            return 1;
        }

        private void reset() {
            this.currentPoint = 0;
        }

        private void done() {
            this.currentPoint = this.numberOfPoints;
        }
    }
}

