/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.util;

import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.model.FileHeader;
import com.fr.zip4j.model.ZipModel;
import com.fr.zip4j.util.InternalZipConstants;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class Zip4jUtil {
    public static boolean isStringNotNullAndNotEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static boolean checkOutputFolder(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException(new NullPointerException("output path is null"));
        }
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new ZipException("output folder is not valid");
            }
            if (!file.canWrite()) {
                throw new ZipException("no write access to output folder");
            }
        } else {
            try {
                file.mkdirs();
                if (!file.isDirectory()) {
                    throw new ZipException("output folder is not valid");
                }
                if (!file.canWrite()) {
                    throw new ZipException("no write access to destination folder");
                }
            }
            catch (Exception exception) {
                throw new ZipException("Cannot create destination folder");
            }
        }
        return true;
    }

    public static boolean checkFileReadAccess(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("path is null");
        }
        if (!Zip4jUtil.checkFileExists(string)) {
            throw new ZipException("file does not exist: " + string);
        }
        try {
            File file = new File(string);
            return file.canRead();
        }
        catch (Exception exception) {
            throw new ZipException("cannot read zip file");
        }
    }

    public static boolean checkFileWriteAccess(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("path is null");
        }
        if (!Zip4jUtil.checkFileExists(string)) {
            throw new ZipException("file does not exist: " + string);
        }
        try {
            File file = new File(string);
            return file.canWrite();
        }
        catch (Exception exception) {
            throw new ZipException("cannot read zip file");
        }
    }

    public static boolean checkFileExists(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("path is null");
        }
        File file = new File(string);
        return Zip4jUtil.checkFileExists(file);
    }

    public static boolean checkFileExists(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("cannot check if file exists: input file is null");
        }
        return file.exists();
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }

    public static void setFileReadOnly(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null. cannot set read only file attribute");
        }
        if (file.exists()) {
            file.setReadOnly();
        }
    }

    public static void setFileHidden(File file) throws ZipException {
    }

    public static void setFileArchive(File file) throws ZipException {
    }

    public static void setFileSystemMode(File file) throws ZipException {
    }

    public static long getLastModifiedFileTime(File file, TimeZone timeZone) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot read last modified file time");
        }
        if (!file.exists()) {
            throw new ZipException("input file does not exist, cannot read last modified file time");
        }
        return file.lastModified();
    }

    public static String getFileNameFromFilePath(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot get file name");
        }
        if (file.isDirectory()) {
            return null;
        }
        return file.getName();
    }

    public static long getFileLengh(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("invalid file name");
        }
        return Zip4jUtil.getFileLengh(new File(string));
    }

    public static long getFileLengh(File file) throws ZipException {
        if (file == null) {
            throw new ZipException("input file is null, cannot calculate file length");
        }
        if (file.isDirectory()) {
            return -1L;
        }
        return file.length();
    }

    public static long javaToDosTime(long l2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l2);
        int n2 = calendar.get(1);
        if (n2 < 1980) {
            return 0x210000L;
        }
        return n2 - 1980 << 25 | calendar.get(2) + 1 << 21 | calendar.get(5) << 16 | calendar.get(11) << 11 | calendar.get(12) << 5 | calendar.get(13) >> 1;
    }

    public static long dosToJavaTme(int n2) {
        int n3 = 2 * (n2 & 0x1F);
        int n4 = n2 >> 5 & 0x3F;
        int n5 = n2 >> 11 & 0x1F;
        int n6 = n2 >> 16 & 0x1F;
        int n7 = (n2 >> 21 & 0xF) - 1;
        int n8 = (n2 >> 25 & 0x7F) + 1980;
        Calendar calendar = Calendar.getInstance();
        calendar.set(n8, n7, n6, n5, n4, n3);
        calendar.set(14, 0);
        return calendar.getTime().getTime();
    }

    public static FileHeader getFileHeader(ZipModel zipModel, String string) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot determine file header for fileName: " + string);
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file name is null, cannot determine file header for fileName: " + string);
        }
        FileHeader fileHeader = null;
        fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, string);
        if (fileHeader == null && (fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, string = string.replaceAll("\\\\", "/"))) == null) {
            string = string.replaceAll("/", "\\\\");
            fileHeader = Zip4jUtil.getFileHeaderWithExactMatch(zipModel, string);
        }
        return fileHeader;
    }

    public static FileHeader getFileHeaderWithExactMatch(ZipModel zipModel, String string) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("zip model is null, cannot determine file header with exact match for fileName: " + string);
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file name is null, cannot determine file header with exact match for fileName: " + string);
        }
        if (zipModel.getCentralDirectory() == null) {
            throw new ZipException("central directory is null, cannot determine file header with exact match for fileName: " + string);
        }
        if (zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("file Headers are null, cannot determine file header with exact match for fileName: " + string);
        }
        if (zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return null;
        }
        ArrayList arrayList = zipModel.getCentralDirectory().getFileHeaders();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            FileHeader fileHeader = (FileHeader)arrayList.get(i2);
            String string2 = fileHeader.getFileName();
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2) || !string.equalsIgnoreCase(string2)) continue;
            return fileHeader;
        }
        return null;
    }

    public static int getIndexOfFileHeader(ZipModel zipModel, FileHeader fileHeader) throws ZipException {
        if (zipModel == null || fileHeader == null) {
            throw new ZipException("input parameters is null, cannot determine index of file header");
        }
        if (zipModel.getCentralDirectory() == null) {
            throw new ZipException("central directory is null, ccannot determine index of file header");
        }
        if (zipModel.getCentralDirectory().getFileHeaders() == null) {
            throw new ZipException("file Headers are null, cannot determine index of file header");
        }
        if (zipModel.getCentralDirectory().getFileHeaders().size() <= 0) {
            return -1;
        }
        String string = fileHeader.getFileName();
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("file name in file header is empty or null, cannot determine index of file header");
        }
        ArrayList arrayList = zipModel.getCentralDirectory().getFileHeaders();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            FileHeader fileHeader2 = (FileHeader)arrayList.get(i2);
            String string2 = fileHeader2.getFileName();
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2) || !string.equalsIgnoreCase(string2)) continue;
            return i2;
        }
        return -1;
    }

    public static ArrayList getFilesInDirectoryRec(File file, boolean bl) throws ZipException {
        if (file == null) {
            throw new ZipException("input path is null, cannot read files in the directory");
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        List<File> list = Arrays.asList(fileArray);
        if (!file.canRead()) {
            return arrayList;
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            File file2 = list.get(i2);
            if (file2.isHidden() && !bl) {
                return arrayList;
            }
            arrayList.add(file2);
            if (!file2.isDirectory()) continue;
            ArrayList arrayList2 = Zip4jUtil.getFilesInDirectoryRec(file2, bl);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public static String getZipFileNameWithoutExt(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("zip file name is empty or null, cannot determine zip file name");
        }
        String string2 = string;
        if (string.indexOf(System.getProperty("file.separator")) >= 0) {
            string2 = string.substring(string.lastIndexOf(System.getProperty("file.separator")));
        }
        if (string2.indexOf(".") > 0) {
            string2 = string2.substring(0, string2.lastIndexOf("."));
        }
        return string2;
    }

    public static byte[] convertCharset(String string) throws ZipException {
        try {
            byte[] byArray = null;
            String string2 = Zip4jUtil.detectCharSet(string);
            byArray = string2.equals("Cp850") ? string.getBytes("Cp850") : (string2.equals("UTF8") ? string.getBytes("UTF8") : string.getBytes());
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    public static String decodeFileName(byte[] byArray, boolean bl) {
        if (bl) {
            try {
                return new String(byArray, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray);
            }
        }
        return Zip4jUtil.getCp850EncodedString(byArray);
    }

    public static String getCp850EncodedString(byte[] byArray) {
        try {
            String string = new String(byArray, "Cp850");
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray);
        }
    }

    public static String getAbsoluteFilePath(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("filePath is null or empty, cannot get absolute file path");
        }
        File file = new File(string);
        return file.getAbsolutePath();
    }

    public static boolean checkArrayListTypes(ArrayList arrayList, int n2) throws ZipException {
        if (arrayList == null) {
            throw new ZipException("input arraylist is null, cannot check types");
        }
        if (arrayList.size() <= 0) {
            return true;
        }
        boolean bl = false;
        block0 : switch (n2) {
            case 1: {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    if (arrayList.get(i2) instanceof File) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
            case 2: {
                for (int i3 = 0; i3 < arrayList.size(); ++i3) {
                    if (arrayList.get(i3) instanceof String) continue;
                    bl = true;
                    break block0;
                }
                break;
            }
        }
        return !bl;
    }

    public static String detectCharSet(String string) throws ZipException {
        if (string == null) {
            throw new ZipException("input string is null, cannot detect charset");
        }
        try {
            byte[] byArray = string.getBytes("Cp850");
            String string2 = new String(byArray, "Cp850");
            if (string.equals(string2)) {
                return "Cp850";
            }
            byArray = string.getBytes("UTF8");
            string2 = new String(byArray, "UTF8");
            if (string.equals(string2)) {
                return "UTF8";
            }
            return InternalZipConstants.CHARSET_DEFAULT;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return InternalZipConstants.CHARSET_DEFAULT;
        }
        catch (Exception exception) {
            return InternalZipConstants.CHARSET_DEFAULT;
        }
    }

    public static int getEncodedStringLength(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input string is null, cannot calculate encoded String length");
        }
        String string2 = Zip4jUtil.detectCharSet(string);
        return Zip4jUtil.getEncodedStringLength(string, string2);
    }

    public static int getEncodedStringLength(String string, String string2) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input string is null, cannot calculate encoded String length");
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            throw new ZipException("encoding is not defined, cannot calculate string length");
        }
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = string2.equals("Cp850") ? ByteBuffer.wrap(string.getBytes("Cp850")) : (string2.equals("UTF8") ? ByteBuffer.wrap(string.getBytes("UTF8")) : ByteBuffer.wrap(string.getBytes(string2)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byteBuffer = ByteBuffer.wrap(string.getBytes());
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
        return byteBuffer.limit();
    }

    public static boolean isSupportedCharset(String string) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("charset is null or empty, cannot check if it is supported");
        }
        try {
            new String("a".getBytes(), string);
            return true;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    public static ArrayList getSplitZipFiles(ZipModel zipModel) throws ZipException {
        if (zipModel == null) {
            throw new ZipException("cannot get split zip files: zipmodel is null");
        }
        if (zipModel.getEndCentralDirRecord() == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = zipModel.getZipFile();
        String string2 = new File(string).getName();
        String string3 = null;
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("cannot get split zip files: zipfile is null");
        }
        if (!zipModel.isSplitArchive()) {
            arrayList.add(string);
            return arrayList;
        }
        int n2 = zipModel.getEndCentralDirRecord().getNoOfThisDisk();
        if (n2 == 0) {
            arrayList.add(string);
            return arrayList;
        }
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 == n2) {
                arrayList.add(zipModel.getZipFile());
                continue;
            }
            String string4 = ".z0";
            if (i2 > 9) {
                string4 = ".z";
            }
            string3 = string2.indexOf(".") >= 0 ? string.substring(0, string.lastIndexOf(".")) : string;
            string3 = string3 + string4 + (i2 + 1);
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static String getRelativeFileName(String string, String string2, String string3) throws ZipException {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string)) {
            throw new ZipException("input file path/name is empty, cannot calculate relative file name");
        }
        String string4 = null;
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string3)) {
            File file;
            String string5;
            File file2 = new File(string3);
            String string6 = file2.getPath();
            if (!string6.endsWith(InternalZipConstants.FILE_SEPARATOR)) {
                string6 = string6 + InternalZipConstants.FILE_SEPARATOR;
            }
            if ((string5 = string.substring(string6.length())).startsWith(System.getProperty("file.separator"))) {
                string5 = string5.substring(1);
            }
            if ((file = new File(string)).isDirectory()) {
                string5 = string5.replaceAll("\\\\", "/");
                string5 = string5 + "/";
            } else {
                String string7 = string5.substring(0, string5.lastIndexOf(file.getName()));
                string7 = string7.replaceAll("\\\\", "/");
                string5 = string7 + file.getName();
            }
            string4 = string5;
        } else {
            File file = new File(string);
            string4 = file.isDirectory() ? file.getName() + "/" : Zip4jUtil.getFileNameFromFilePath(new File(string));
        }
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            string4 = string2 + string4;
        }
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string4)) {
            throw new ZipException("Error determining file name");
        }
        return string4;
    }

    public static long[] getAllHeaderSignatures() {
        long[] lArray = new long[]{67324752L, 134695760L, 33639248L, 101010256L, 84233040L, 134630224L, 134695760L, 117853008L, 101075792L, 1L, 39169L};
        return lArray;
    }
}

