/*
 * Decompiled with CFR 0.152.
 */
package com.fr.write;

import com.fr.data.impl.FormulaDictionary;
import com.fr.form.ui.ComboBox;
import com.fr.form.ui.DictionaryContainer;
import com.fr.general.ModuleContext;
import com.fr.main.impl.WorkBook;
import com.fr.report.cell.DefaultTemplateCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.CellInsertPolicyAttr;
import com.fr.report.report.ECReport;
import com.fr.report.report.WriteECReport;
import com.fr.report.worksheet.WorkSheet;
import com.fr.stable.ActorFactory;
import com.fr.stable.ColumnRow;
import com.fr.write.WriteException;
import com.fr.write.main.WriteRWorkBook;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class WriteTest
extends TestCase {
    public void testInsertPolicy() {
        ModuleContext.startModule("com.fr.report.module.EngineModule");
        WorkSheet workSheet = new WorkSheet();
        DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(2, 2);
        workSheet.addCellElement(defaultTemplateCellElement);
        CellExpandAttr cellExpandAttr = new CellExpandAttr();
        cellExpandAttr.setDirection((byte)0);
        defaultTemplateCellElement.setCellExpandAttr(cellExpandAttr);
        defaultTemplateCellElement.setValue("cell22");
        DefaultTemplateCellElement defaultTemplateCellElement2 = new DefaultTemplateCellElement(3, 2);
        CellInsertPolicyAttr cellInsertPolicyAttr = new CellInsertPolicyAttr();
        cellInsertPolicyAttr.setInsertPolicy(CellInsertPolicyAttr.INSERT_POLICY_COPY);
        defaultTemplateCellElement2.setCellInsertPolicyAttr(cellInsertPolicyAttr);
        defaultTemplateCellElement.setCellInsertPolicyAttr(cellInsertPolicyAttr);
        defaultTemplateCellElement2.setValue("cell32");
        workSheet.addCellElement(defaultTemplateCellElement2);
        WorkBook workBook = new WorkBook(workSheet);
        ECReport eCReport = (ECReport)workBook.execute(new HashMap(), ActorFactory.getActor("write")).getReport(0);
        WriteTest.checkInsert(eCReport, 2, 2, "cell22", "cell32");
        cellInsertPolicyAttr.setInsertPolicy(CellInsertPolicyAttr.INSERT_POLICY_DEFAULT);
        cellInsertPolicyAttr.setDefaultInsertValue("new cell");
        eCReport = (ECReport)workBook.execute(new HashMap(), ActorFactory.getActor("write")).getReport(0);
        WriteTest.checkInsert(eCReport, 2, 2, "new cell", "new cell");
        cellInsertPolicyAttr.setInsertPolicy(CellInsertPolicyAttr.INSERT_POLICY_NULL);
        eCReport = (ECReport)workBook.execute(new HashMap(), ActorFactory.getActor("write")).getReport(0);
        WriteTest.checkInsert(eCReport, 2, 2, null, null);
    }

    private static void checkInsert(ECReport eCReport, int n2, int n3, Object object, Object object2) {
        try {
            ((WriteECReport)eCReport).simpleAppendData(ColumnRow.valueOf(n3, n2), false, 1, true, false);
            WriteTest.assertEquals((Object)eCReport.getCellValue(n3, n2 + 1), (Object)object);
            WriteTest.assertEquals((Object)eCReport.getCellValue(n3 + 1, n2 + 1), (Object)object2);
        }
        catch (WriteException writeException) {
            WriteTest.assertTrue((String)writeException.getMessage(), (boolean)false);
        }
    }

    public void testInsertWidgetRelation() {
        WorkSheet workSheet = new WorkSheet();
        DefaultTemplateCellElement defaultTemplateCellElement = new DefaultTemplateCellElement(2, 2);
        workSheet.addCellElement(defaultTemplateCellElement);
        CellExpandAttr cellExpandAttr = new CellExpandAttr();
        cellExpandAttr.setDirection((byte)0);
        defaultTemplateCellElement.setCellExpandAttr(cellExpandAttr);
        defaultTemplateCellElement.setValue("cell22");
        DefaultTemplateCellElement defaultTemplateCellElement2 = new DefaultTemplateCellElement(3, 2);
        DefaultTemplateCellElement defaultTemplateCellElement3 = new DefaultTemplateCellElement(4, 2);
        CellInsertPolicyAttr cellInsertPolicyAttr = new CellInsertPolicyAttr();
        cellInsertPolicyAttr.setInsertPolicy(CellInsertPolicyAttr.INSERT_POLICY_COPY);
        defaultTemplateCellElement2.setCellInsertPolicyAttr(cellInsertPolicyAttr);
        defaultTemplateCellElement.setCellInsertPolicyAttr(cellInsertPolicyAttr);
        defaultTemplateCellElement3.setCellInsertPolicyAttr(cellInsertPolicyAttr);
        defaultTemplateCellElement2.setValue("cell32");
        ComboBox comboBox = new ComboBox();
        FormulaDictionary formulaDictionary = new FormulaDictionary();
        formulaDictionary.setProduceFormula("=C3+D3");
        comboBox.setDictionary(formulaDictionary);
        defaultTemplateCellElement3.setWidget(comboBox);
        workSheet.addCellElement(defaultTemplateCellElement2);
        workSheet.addCellElement(defaultTemplateCellElement3);
        WriteECReport writeECReport = ((WriteRWorkBook)new WorkBook(workSheet).execute(new HashMap(), ActorFactory.getActor("write"))).getWriteReport(0);
        try {
            writeECReport.simpleAppendData(ColumnRow.valueOf(2, 2), false, 1, true, false);
            Map map = ((DictionaryContainer)((Object)writeECReport.getWriteCellElement(4, 3).getWidget())).getDependenceMap();
            WriteTest.assertEquals(map.get("C3"), (Object)"C4");
            WriteTest.assertEquals(map.get("D3"), (Object)"D4");
        }
        catch (WriteException writeException) {
            WriteTest.assertTrue((String)writeException.getMessage(), (boolean)false);
        }
    }
}

