/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream;

import com.fr.third.javax.xml.stream.Entity;
import com.fr.third.javax.xml.stream.PropertyManager;
import com.fr.third.javax.xml.stream.XMLEntityManager;
import com.fr.third.javax.xml.stream.XMLErrorReporter;
import com.fr.third.javax.xml.stream.xerces.util.URI;
import com.fr.third.javax.xml.stream.xerces.util.XMLResourceIdentifierImpl;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLComponentManager;
import com.fr.third.javax.xml.stream.xerces.xni.parser.XMLConfigurationException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

public class XMLEntityStorage {
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    protected static final String WARN_ON_DUPLICATE_ENTITYDEF = "http://apache.org/xml/features/warn-on-duplicate-entitydef";
    protected boolean fWarnDuplicateEntityDef;
    protected Hashtable fEntities = new Hashtable();
    protected Entity.ScannedEntity fCurrentEntity;
    private XMLEntityManager fEntityManager;
    protected XMLErrorReporter fErrorReporter;
    protected PropertyManager fPropertyManager;
    private static String gUserDir;
    private static String gEscapedUserDir;
    private static boolean[] gNeedEscaping;
    private static char[] gAfterEscaping1;
    private static char[] gAfterEscaping2;
    private static char[] gHexChs;

    static {
        gNeedEscaping = new boolean[32857];
        gAfterEscaping1 = new char[32857];
        gAfterEscaping2 = new char[32857];
        gHexChs = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int n2 = 0;
        while (n2 <= 31) {
            XMLEntityStorage.gNeedEscaping[n2] = true;
            XMLEntityStorage.gAfterEscaping1[n2] = gHexChs[n2 >> 4];
            XMLEntityStorage.gAfterEscaping2[n2] = gHexChs[n2 & 0xF];
            ++n2;
        }
        XMLEntityStorage.gNeedEscaping[127] = true;
        XMLEntityStorage.gAfterEscaping1[127] = 55;
        XMLEntityStorage.gAfterEscaping2[127] = 70;
        char[] cArray = new char[]{' ', '<', '>', '#', '%', '\"', '{', '}', '|', '\\', '^', '~', '[', ']', '`'};
        int n3 = cArray.length;
        int n4 = 0;
        while (n4 < n3) {
            char c2 = cArray[n4];
            XMLEntityStorage.gNeedEscaping[c2] = true;
            XMLEntityStorage.gAfterEscaping1[c2] = gHexChs[c2 >> 4];
            XMLEntityStorage.gAfterEscaping2[c2] = gHexChs[c2 & 0xF];
            ++n4;
        }
    }

    public XMLEntityStorage(PropertyManager propertyManager) {
        this.fPropertyManager = propertyManager;
    }

    public XMLEntityStorage(XMLEntityManager xMLEntityManager) {
        this.fEntityManager = xMLEntityManager;
    }

    public void reset(PropertyManager propertyManager) {
        this.fErrorReporter = (XMLErrorReporter)propertyManager.getProperty(ERROR_REPORTER);
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    public void reset() {
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        try {
            this.fWarnDuplicateEntityDef = xMLComponentManager.getFeature(WARN_ON_DUPLICATE_ENTITYDEF);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fWarnDuplicateEntityDef = false;
        }
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fEntities.clear();
        this.fCurrentEntity = null;
    }

    public Hashtable getDeclaredEntities() {
        return this.fEntities;
    }

    public void addInternalEntity(String string, String string2) {
        if (!this.fEntities.containsKey(string)) {
            this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
            Entity.InternalEntity internalEntity = new Entity.InternalEntity(string, string2, false);
            this.fEntities.put(string, internalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public void addExternalEntity(String string, String string2, String string3, String string4) {
        if (!this.fEntities.containsKey(string)) {
            if (string4 == null && this.fCurrentEntity != null && this.fCurrentEntity.entityLocation != null) {
                string4 = this.fCurrentEntity.entityLocation.getExpandedSystemId();
            }
            this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
            Entity.ExternalEntity externalEntity = new Entity.ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, XMLEntityStorage.expandSystemId(string3, string4)), null, true);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public boolean isExternalEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isExternal();
    }

    public boolean isEntityDeclInExternalSubset(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isEntityDeclInExternalSubset();
    }

    public void addUnparsedEntity(String string, String string2, String string3, String string4, String string5) {
        this.fCurrentEntity = this.fEntityManager.getCurrentEntity();
        if (!this.fEntities.containsKey(string)) {
            Entity.ExternalEntity externalEntity = new Entity.ExternalEntity(string, new XMLResourceIdentifierImpl(string2, string3, string4, null), string5, false);
            this.fEntities.put(string, externalEntity);
        } else if (this.fWarnDuplicateEntityDef) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1998/REC-xml-19980210", "MSG_DUPLICATE_ENTITY_DEFINITION", new Object[]{string}, (short)0);
        }
    }

    public boolean isUnparsedEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        if (entity == null) {
            return false;
        }
        return entity.isUnparsed();
    }

    public boolean isDeclaredEntity(String string) {
        Entity entity = (Entity)this.fEntities.get(string);
        return entity != null;
    }

    public static String expandSystemId(String string) {
        return XMLEntityStorage.expandSystemId(string, null);
    }

    private static synchronized String getUserDir() {
        int n2;
        String string = "";
        try {
            string = System.getProperty("user.dir");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string.length() == 0) {
            return "";
        }
        if (string.equals(gUserDir)) {
            return gEscapedUserDir;
        }
        gUserDir = string;
        char c2 = File.separatorChar;
        string = string.replace(c2, '/');
        int n3 = string.length();
        StringBuffer stringBuffer = new StringBuffer(n3 * 3);
        if (n3 >= 2 && string.charAt(1) == ':' && (n2 = (int)Character.toUpperCase(string.charAt(0))) >= 65 && n2 <= 90) {
            stringBuffer.append('/');
        }
        n2 = 0;
        while (n2 < n3) {
            char c3 = string.charAt(n2);
            if (c3 >= '\u0080') break;
            if (gNeedEscaping[c3]) {
                stringBuffer.append('%');
                stringBuffer.append(gAfterEscaping1[c3]);
                stringBuffer.append(gAfterEscaping2[c3]);
            } else {
                stringBuffer.append(c3);
            }
            ++n2;
        }
        if (n2 < n3) {
            byte[] byArray = null;
            try {
                byArray = string.substring(n2).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
            n3 = byArray.length;
            n2 = 0;
            while (n2 < n3) {
                byte by = byArray[n2];
                if (by < 0) {
                    int n4 = by + 256;
                    stringBuffer.append('%');
                    stringBuffer.append(gHexChs[n4 >> 4]);
                    stringBuffer.append(gHexChs[n4 & 0xF]);
                } else if (gNeedEscaping[by]) {
                    stringBuffer.append('%');
                    stringBuffer.append(gAfterEscaping1[by]);
                    stringBuffer.append(gAfterEscaping2[by]);
                } else {
                    stringBuffer.append((char)by);
                }
                ++n2;
            }
        }
        if (!string.endsWith("/")) {
            stringBuffer.append('/');
        }
        gEscapedUserDir = stringBuffer.toString();
        return gEscapedUserDir;
    }

    public static String expandSystemId(String string, String string2) {
        Object object;
        if (string == null || string.length() == 0) {
            return string;
        }
        try {
            object = new URI(string);
            if (object != null) {
                return string;
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            // empty catch block
        }
        object = XMLEntityStorage.fixURI(string);
        URI uRI = null;
        URI uRI2 = null;
        try {
            if (string2 == null || string2.length() == 0 || string2.equals(string)) {
                String string3 = XMLEntityStorage.getUserDir();
                uRI = new URI("file", "", string3, null, null);
            } else {
                try {
                    uRI = new URI(XMLEntityStorage.fixURI(string2));
                }
                catch (URI.MalformedURIException malformedURIException) {
                    if (string2.indexOf(58) != -1) {
                        uRI = new URI("file", "", XMLEntityStorage.fixURI(string2), null, null);
                    }
                    String string4 = XMLEntityStorage.getUserDir();
                    string4 = String.valueOf(string4) + XMLEntityStorage.fixURI(string2);
                    uRI = new URI("file", "", string4, null, null);
                }
            }
            uRI2 = new URI(uRI, (String)object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRI2 == null) {
            return string;
        }
        return uRI2.toString();
    }

    protected static String fixURI(String string) {
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2) {
            char c2 = string.charAt(1);
            if (c2 == ':') {
                char c3 = Character.toUpperCase(string.charAt(0));
                if (c3 >= 'A' && c3 <= 'Z') {
                    string = "/" + string;
                }
            } else if (c2 == '/' && string.charAt(0) == '/') {
                string = "file:" + string;
            }
        }
        return string;
    }
}

