/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.JaiI18N;
import com.fr.third.JAI.RasterFactory;
import com.fr.third.JAI.SeekableStream;
import com.fr.third.JAI.SimpleRenderedImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

class PNMImage
extends SimpleRenderedImage {
    private static final int PBM_ASCII = 49;
    private static final int PGM_ASCII = 50;
    private static final int PPM_ASCII = 51;
    private static final int PBM_RAW = 52;
    private static final int PGM_RAW = 53;
    private static final int PPM_RAW = 54;
    private static final int LINE_FEED = 10;
    private SeekableStream input;
    private byte[] lineSeparator;
    private int variant;
    private int maxValue;
    private Raster theTile = null;
    private int numBands;
    private int dataType;

    public PNMImage(SeekableStream seekableStream) {
        this.input = seekableStream;
        String string = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
        this.lineSeparator = string.getBytes();
        try {
            if (this.input.read() != 80) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder0"));
            }
            this.variant = this.input.read();
            if (this.variant < 49 || this.variant > 54) {
                throw new RuntimeException(JaiI18N.getString("PNMImageDecoder1"));
            }
            this.width = this.readInteger(this.input);
            this.height = this.readInteger(this.input);
            this.maxValue = this.variant == 49 || this.variant == 52 ? 1 : this.readInteger(this.input);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("PNMImageDecoder2"));
        }
        if (this.isRaw(this.variant) && this.maxValue >= 256) {
            this.maxValue = 255;
        }
        this.tileWidth = this.width;
        this.tileHeight = this.height;
        this.numBands = this.variant == 51 || this.variant == 54 ? 3 : 1;
        this.dataType = this.maxValue < 256 ? 0 : (this.maxValue < 65536 ? 1 : 3);
        if (this.variant == 49 || this.variant == 52) {
            this.sampleModel = new MultiPixelPackedSampleModel(0, this.width, this.height, 1);
            this.colorModel = ImageCodec.createGrayIndexColorModel(this.sampleModel, false);
        } else {
            int[] nArray;
            if (this.numBands == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            int[] nArray4 = nArray;
            this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.numBands, this.tileWidth * this.numBands, nArray4);
            this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
        }
    }

    private boolean isRaw(int n2) {
        return n2 >= 52;
    }

    private int readInteger(SeekableStream seekableStream) throws IOException {
        int n2;
        int n3 = 0;
        boolean bl = false;
        while ((n2 = seekableStream.read()) != -1) {
            char c2 = (char)n2;
            if (Character.isDigit(c2)) {
                n3 = n3 * 10 + Character.digit(c2, 10);
                bl = true;
                continue;
            }
            if (c2 == '#') {
                int n4 = this.lineSeparator.length;
                while ((n2 = seekableStream.read()) != -1) {
                    boolean bl2 = false;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        if (n2 != this.lineSeparator[i2]) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) continue;
                    break;
                }
                if (n2 == -1) break;
            }
            if (!bl) continue;
            break;
        }
        return n3;
    }

    private Raster computeTile(int n2, int n3) {
        Point point = new Point(this.tileXToX(n2), this.tileYToY(n3));
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = writableRaster.getBounds();
        try {
            block18: {
                block1 : switch (this.variant) {
                    case 49: 
                    case 52: {
                        DataBuffer dataBuffer = writableRaster.getDataBuffer();
                        if (this.isRaw(this.variant)) {
                            byte[] byArray = ((DataBufferByte)dataBuffer).getData();
                            this.input.readFully(byArray, 0, byArray.length);
                            break;
                        }
                        byte[] byArray = new byte[8 * this.width];
                        boolean bl = false;
                        for (int i2 = 0; i2 < this.tileHeight; i2 += 8) {
                            int n4 = Math.min(8, this.tileHeight - i2);
                            int n5 = (n4 * this.width + 7) / 8;
                            for (int i3 = 0; i3 < n4 * this.width; ++i3) {
                                byArray[i3] = (byte)this.readInteger(this.input);
                            }
                            this.sampleModel.setDataElements(rectangle.x, i2, rectangle.width, n4, byArray, dataBuffer);
                        }
                        break;
                    }
                    case 50: 
                    case 51: 
                    case 53: 
                    case 54: {
                        int n6 = this.width * this.height * this.numBands;
                        switch (this.dataType) {
                            case 0: {
                                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                                byte[] byArray = dataBufferByte.getData();
                                if (this.isRaw(this.variant)) {
                                    this.input.readFully(byArray);
                                    break block1;
                                }
                                for (int i4 = 0; i4 < n6; ++i4) {
                                    byArray[i4] = (byte)this.readInteger(this.input);
                                }
                                break block18;
                            }
                            case 1: {
                                DataBufferUShort dataBufferUShort = (DataBufferUShort)writableRaster.getDataBuffer();
                                short[] sArray = dataBufferUShort.getData();
                                for (int i5 = 0; i5 < n6; ++i5) {
                                    sArray[i5] = (short)this.readInteger(this.input);
                                }
                                break block18;
                            }
                            case 3: {
                                DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
                                int[] nArray = dataBufferInt.getData();
                                for (int i6 = 0; i6 < n6; ++i6) {
                                    nArray[i6] = this.readInteger(this.input);
                                }
                            }
                        }
                    }
                }
            }
            this.input.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("PNMImageDecoder3"));
        }
        return writableRaster;
    }

    public synchronized Raster getTile(int n2, int n3) {
        if (n2 != 0 || n3 != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("PNMImageDecoder4"));
        }
        if (this.theTile == null) {
            this.theTile = this.computeTile(n2, n3);
        }
        return this.theTile;
    }
}

