/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.map;

import com.fr.stable.collections.array.Array;
import com.fr.stable.collections.utils.GdxRuntimeException;
import com.fr.stable.collections.utils.MathUtils;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSet<T>
implements Iterable<T> {
    private static final int PRIME1 = -1105259343;
    private static final int PRIME2 = -1262997959;
    private static final int PRIME3 = -825114047;
    public int size;
    T[] keyTable;
    int capacity;
    int stashSize;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private ObjectSetIterator iterator1;
    private ObjectSetIterator iterator2;

    public ObjectSet() {
        this(51, 0.8f);
    }

    public ObjectSet(int n2) {
        this(n2, 0.8f);
    }

    public ObjectSet(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if ((n2 = MathUtils.nextPowerOfTwo((int)Math.ceil((float)n2 / f2))) > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = n2;
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new Object[this.capacity + this.stashCapacity];
    }

    public ObjectSet(ObjectSet objectSet) {
        this((int)Math.floor((float)objectSet.capacity * objectSet.loadFactor), objectSet.loadFactor);
        this.stashSize = objectSet.stashSize;
        System.arraycopy(objectSet.keyTable, 0, this.keyTable, 0, objectSet.keyTable.length);
        this.size = objectSet.size;
    }

    public boolean add(T t2) {
        int n2;
        if (t2 == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        T[] TArray = this.keyTable;
        int n3 = t2.hashCode();
        int n4 = n3 & this.mask;
        T t3 = TArray[n4];
        if (t2.equals(t3)) {
            return false;
        }
        int n5 = this.hash2(n3);
        T t4 = TArray[n5];
        if (t2.equals(t4)) {
            return false;
        }
        int n6 = this.hash3(n3);
        T t5 = TArray[n6];
        if (t2.equals(t5)) {
            return false;
        }
        int n7 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n7; ++n2) {
            if (!t2.equals(TArray[n2])) continue;
            return false;
        }
        if (t3 == null) {
            TArray[n4] = t2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (t4 == null) {
            TArray[n5] = t2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        if (t5 == null) {
            TArray[n6] = t2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return true;
        }
        this.push(t2, n4, t3, n5, t4, n6, t5);
        return true;
    }

    public void addAll(Array<? extends T> array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(Array<? extends T> array, int n2, int n3) {
        if (n2 + n3 > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n2 + " + " + n3 + " <= " + array.size);
        }
        this.addAll(array.items, n2, n3);
    }

    public void addAll(T ... TArray) {
        this.addAll(TArray, 0, TArray.length);
    }

    public void addAll(T[] TArray, int n2, int n3) {
        int n4;
        this.ensureCapacity(n3);
        int n5 = n4 + n3;
        for (n4 = n2; n4 < n5; ++n4) {
            this.add(TArray[n4]);
        }
    }

    public void addAll(ObjectSet<T> objectSet) {
        this.ensureCapacity(objectSet.size);
        for (Object e2 : objectSet) {
            this.add(e2);
        }
    }

    private void addResize(T t2) {
        int n2 = t2.hashCode();
        int n3 = n2 & this.mask;
        T t3 = this.keyTable[n3];
        if (t3 == null) {
            this.keyTable[n3] = t2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n4 = this.hash2(n2);
        T t4 = this.keyTable[n4];
        if (t4 == null) {
            this.keyTable[n4] = t2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash3(n2);
        T t5 = this.keyTable[n5];
        if (t5 == null) {
            this.keyTable[n5] = t2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(t2, n3, t3, n4, t4, n5, t5);
    }

    private void push(T t2, int n2, T t3, int n3, T t4, int n4, T t5) {
        T t6;
        T[] TArray = this.keyTable;
        int n5 = this.mask;
        int n6 = 0;
        int n7 = this.pushIterations;
        while (true) {
            switch (MathUtils.random(2)) {
                case 0: {
                    t6 = t3;
                    TArray[n2] = t2;
                    break;
                }
                case 1: {
                    t6 = t4;
                    TArray[n3] = t2;
                    break;
                }
                default: {
                    t6 = t5;
                    TArray[n4] = t2;
                }
            }
            int n8 = t6.hashCode();
            n2 = n8 & n5;
            t3 = TArray[n2];
            if (t3 == null) {
                TArray[n2] = t6;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n3 = this.hash2(n8);
            t4 = TArray[n3];
            if (t4 == null) {
                TArray[n3] = t6;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n4 = this.hash3(n8);
            t5 = TArray[n4];
            if (t5 == null) {
                TArray[n4] = t6;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n6 == n7) break;
            t2 = t6;
        }
        this.addStash(t6);
    }

    private void addStash(T t2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.add(t2);
            return;
        }
        int n2 = this.capacity + this.stashSize;
        this.keyTable[n2] = t2;
        ++this.stashSize;
        ++this.size;
    }

    public boolean remove(T t2) {
        int n2 = t2.hashCode();
        int n3 = n2 & this.mask;
        if (t2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            --this.size;
            return true;
        }
        n3 = this.hash2(n2);
        if (t2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            --this.size;
            return true;
        }
        n3 = this.hash3(n2);
        if (t2.equals(this.keyTable[n3])) {
            this.keyTable[n3] = null;
            --this.size;
            return true;
        }
        return this.removeStash(t2);
    }

    boolean removeStash(T t2) {
        int n2;
        T[] TArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!t2.equals(TArray[n2])) continue;
            this.removeStashIndex(n2);
            --this.size;
            return true;
        }
        return false;
    }

    void removeStashIndex(int n2) {
        --this.stashSize;
        int n3 = this.capacity + this.stashSize;
        if (n2 < n3) {
            this.keyTable[n2] = this.keyTable[n3];
        }
    }

    public void shrink(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("maximumCapacity must be >= 0: " + n2);
        }
        if (this.size > n2) {
            n2 = this.size;
        }
        if (this.capacity <= n2) {
            return;
        }
        n2 = MathUtils.nextPowerOfTwo(n2);
        this.resize(n2);
    }

    public void clear(int n2) {
        if (this.capacity <= n2) {
            this.clear();
            return;
        }
        this.size = 0;
        this.resize(n2);
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        T[] TArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            TArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
    }

    public boolean contains(T t2) {
        int n2 = t2.hashCode();
        int n3 = n2 & this.mask;
        if (!(t2.equals(this.keyTable[n3]) || t2.equals(this.keyTable[n3 = this.hash2(n2)]) || t2.equals(this.keyTable[n3 = this.hash3(n2)]))) {
            return this.containsKeyStash(t2);
        }
        return true;
    }

    private boolean containsKeyStash(T t2) {
        int n2;
        T[] TArray = this.keyTable;
        int n3 = n2 + this.stashSize;
        for (n2 = this.capacity; n2 < n3; ++n2) {
            if (!t2.equals(TArray[n2])) continue;
            return true;
        }
        return false;
    }

    public T first() {
        T[] TArray = this.keyTable;
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (TArray[i2] == null) continue;
            return TArray[i2];
        }
        throw new IllegalStateException("ObjectSet is empty.");
    }

    public void ensureCapacity(int n2) {
        int n3 = this.size + n2;
        if (n3 >= this.threshold) {
            this.resize(MathUtils.nextPowerOfTwo((int)Math.ceil((float)n3 / this.loadFactor)));
        }
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        T[] TArray = this.keyTable;
        this.keyTable = new Object[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                T t2 = TArray[i2];
                if (t2 == null) continue;
                this.addResize(t2);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.keyTable[i2] == null) continue;
            n2 += this.keyTable[i2].hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ObjectSet)) {
            return false;
        }
        ObjectSet objectSet = (ObjectSet)object;
        if (objectSet.size != this.size) {
            return false;
        }
        int n2 = this.capacity + this.stashSize;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.keyTable[i2] == null || objectSet.contains(this.keyTable[i2])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return '{' + this.toString(", ") + '}';
    }

    public String toString(String string) {
        T t2;
        if (this.size == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        T[] TArray = this.keyTable;
        int n2 = TArray.length;
        while (n2-- > 0) {
            t2 = TArray[n2];
            if (t2 == null) continue;
            stringBuilder.append(t2);
            break;
        }
        while (n2-- > 0) {
            t2 = TArray[n2];
            if (t2 == null) continue;
            stringBuilder.append(string);
            stringBuilder.append(t2);
        }
        return stringBuilder.toString();
    }

    @Override
    public ObjectSetIterator<T> iterator() {
        if (this.iterator1 == null) {
            this.iterator1 = new ObjectSetIterator(this);
            this.iterator2 = new ObjectSetIterator(this);
        }
        if (!this.iterator1.valid) {
            this.iterator1.reset();
            this.iterator1.valid = true;
            this.iterator2.valid = false;
            return this.iterator1;
        }
        this.iterator2.reset();
        this.iterator2.valid = true;
        this.iterator1.valid = false;
        return this.iterator2;
    }

    public static <T> ObjectSet<T> with(T ... TArray) {
        ObjectSet<T> objectSet = new ObjectSet<T>();
        objectSet.addAll(TArray);
        return objectSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ObjectSetIterator<K>
    implements Iterable<K>,
    Iterator<K> {
        public boolean hasNext;
        final ObjectSet<K> set;
        int nextIndex;
        int currentIndex;
        boolean valid = true;

        public ObjectSetIterator(ObjectSet<K> objectSet) {
            this.set = objectSet;
            this.reset();
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        void findNextIndex() {
            this.hasNext = false;
            T[] TArray = this.set.keyTable;
            int n2 = this.set.capacity + this.set.stashSize;
            while (++this.nextIndex < n2) {
                if (TArray[this.nextIndex] == null) continue;
                this.hasNext = true;
                break;
            }
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException("next must be called before remove.");
            }
            if (this.currentIndex >= this.set.capacity) {
                this.set.removeStashIndex(this.currentIndex);
                this.nextIndex = this.currentIndex - 1;
                this.findNextIndex();
            } else {
                this.set.keyTable[this.currentIndex] = null;
            }
            this.currentIndex = -1;
            --this.set.size;
        }

        @Override
        public boolean hasNext() {
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            return this.hasNext;
        }

        @Override
        public K next() {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            if (!this.valid) {
                throw new GdxRuntimeException("#iterator() cannot be used nested.");
            }
            Object t2 = this.set.keyTable[this.nextIndex];
            this.currentIndex = this.nextIndex;
            this.findNextIndex();
            return (K)t2;
        }

        @Override
        public ObjectSetIterator<K> iterator() {
            return this;
        }

        public Array<K> toArray(Array<K> array) {
            while (this.hasNext) {
                array.add(this.next());
            }
            return array;
        }

        public Array<K> toArray() {
            return this.toArray(new Array(true, this.set.size));
        }
    }
}

