/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Ascii85InputStream
extends FilterInputStream {
    private int index = 0;
    private int n = 0;
    private boolean eof = false;
    private byte[] ascii = new byte[5];
    private byte[] b = new byte[4];

    public Ascii85InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public final int read() throws IOException {
        if (this.index >= this.n) {
            byte by;
            byte by2;
            if (this.eof) {
                return -1;
            }
            this.index = 0;
            do {
                if ((by = (byte)this.in.read()) != -1) continue;
                this.eof = true;
                return -1;
            } while ((by2 = (byte)by) == 10 || by2 == 13 || by2 == 32);
            if (by2 == 126 | by2 == 120) {
                this.eof = true;
                this.b = null;
                this.ascii = null;
                this.n = 0;
                return -1;
            }
            if (by2 == 122) {
                this.b[3] = 0;
                this.b[2] = 0;
                this.b[1] = 0;
                this.b[0] = 0;
                this.n = 4;
            } else {
                int n2;
                this.ascii[0] = by2;
                for (n2 = 1; n2 < 5; ++n2) {
                    do {
                        if ((by = (byte)this.in.read()) != -1) continue;
                        this.eof = true;
                        return -1;
                    } while ((by2 = (byte)by) == 10 || by2 == 13 || by2 == 32);
                    this.ascii[n2] = by2;
                    if (by2 == 126 | by2 == 120) break;
                }
                this.n = n2 - 1;
                if (this.n == 0) {
                    this.eof = true;
                    this.b = null;
                    this.ascii = null;
                    return -1;
                }
                if (n2 < 5) {
                    ++n2;
                    while (n2 < 5) {
                        this.ascii[n2] = 33;
                        ++n2;
                    }
                    this.eof = true;
                }
                long l2 = 0L;
                for (n2 = 0; n2 < 5; ++n2) {
                    by2 = (byte)(this.ascii[n2] - 33);
                    if (by2 < 0 || by2 > 93) {
                        this.n = 0;
                        this.eof = true;
                        this.b = null;
                        this.ascii = null;
                        throw new IOException("Invalid data in Ascii85 stream");
                    }
                    l2 = l2 * 85L + (long)by2;
                }
                for (n2 = 3; n2 >= 0; --n2) {
                    this.b[n2] = (byte)(l2 & 0xFFL);
                    l2 >>>= 8;
                }
            }
        }
        return this.b[this.index++] & 0xFF;
    }

    public final int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.eof && this.index >= this.n) {
            return -1;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.index < this.n) {
                byArray[i2 + n2] = this.b[this.index++];
                continue;
            }
            int n4 = this.read();
            if (n4 == -1) {
                return i2;
            }
            byArray[i2 + n2] = (byte)n4;
        }
        return n3;
    }

    public void close() throws IOException {
        this.ascii = null;
        this.eof = true;
        this.b = null;
        super.close();
    }

    public boolean markSupported() {
        return false;
    }

    public long skip(long l2) {
        return 0L;
    }

    public int available() {
        return 0;
    }

    public void mark(int n2) {
    }

    public void reset() throws IOException {
        throw new IOException("Reset is not supported");
    }
}

