/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.fun.impl;

import com.fr.base.GraphHelper;
import com.fr.base.Style;
import com.fr.general.Inter;
import com.fr.report.fun.impl.AbstractVerticalTextProcessor;
import com.fr.report.fun.impl.SymbolConverter;
import com.fr.stable.ArrayUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.unit.PT;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.List;

public class DefaultVerticalTextProcessor
extends AbstractVerticalTextProcessor {
    private static int ONECHARACTERLEN = 6;
    private static final char SBC_SPACE = '\u3000';
    private static final char DBC_SPACE = ' ';
    private static final char DBC_CHAR_END = '\u007f';
    private static final int CONVERT_STEP = 65248;

    public String[] getComboxOption() {
        return new String[]{Inter.getLocText("FR-Designer_Vertical-LeftToRight"), Inter.getLocText("FR-Designer_Vertical-RightToLeft")};
    }

    public String[] process(String string, Style style, Font font, double d2, double d3, int n2) {
        if (font == null) {
            font = style.getFRFont();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null || string.length() <= 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (style.getRotation() != 0) {
            arrayList.add(string);
            return new String[]{string};
        }
        string = SymbolConverter.converVerticalSymbol(style, string);
        string = DefaultVerticalTextProcessor.half2Full(string);
        ArrayList arrayList2 = new ArrayList();
        int n3 = 0;
        FontMetrics fontMetrics = GraphHelper.getFontMetrics(font);
        int n4 = fontMetrics.getHeight();
        int n5 = style.getTextStyle();
        int n6 = style.getVerticalAlignment();
        int[] nArray = new int[2];
        nArray[0] = n3;
        if (n5 == 0) {
            DefaultVerticalTextProcessor.lineTextListWrapText(arrayList2, n6, string, d2, nArray, n4, style, n2);
        } else {
            DefaultVerticalTextProcessor.lineTextListNotWrapText(arrayList2, string, nArray);
        }
        DefaultVerticalTextProcessor.verticalToHorizontal(arrayList2, arrayList, fontMetrics, nArray, style);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void lineTextListWrapText(List list, int n2, String string, double d2, int[] nArray, int n3, Style style, int n4) {
        double d3 = d2;
        boolean bl = true;
        int n5 = 0;
        int n6 = 0;
        n3 = (int)((double)n3 + PT.pt2pix(style.getSpacingBefore(), n4) + PT.pt2pix(style.getSpacingAfter(), n4) + PT.pt2pix(style.getLineSpacing(), n4));
        int n7 = (int)d3 / n3;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ' && !bl) continue;
            if (c2 == '\n') {
                list.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                n6 = 0;
                n5 = 0;
                continue;
            }
            if (c2 != ' ') {
                bl = false;
            }
            if (c2 == '\\' && i2 + 1 < string.length() && string.charAt(i2 + 1) == 'n') {
                ++i2;
                list.add(stringBuffer.toString());
                stringBuffer.delete(0, stringBuffer.length());
                n6 = 0;
                nArray[0] = Math.max(nArray[0], ++n5);
                n5 = 0;
                continue;
            }
            stringBuffer.append(c2);
            n6 += n3;
            nArray[0] = Math.max(nArray[0], ++n5);
            if (!((double)n6 > d3)) continue;
            list.add(stringBuffer.substring(0, stringBuffer.length() - 1));
            stringBuffer.delete(0, stringBuffer.length() - 1);
            n6 = n3;
            nArray[0] = Math.min(nArray[0], n5 - 1);
            n5 = 1;
        }
        DefaultVerticalTextProcessor.addLastVerticalText(list, stringBuffer, n7, n2);
    }

    private static void addLastVerticalText(List list, StringBuffer stringBuffer, int n2, int n3) {
        if (list.isEmpty()) {
            list.add(stringBuffer.toString());
        } else {
            DefaultVerticalTextProcessor.verticaltextlistAddLastString(list, stringBuffer.toString(), n2, n3);
        }
    }

    private static void verticaltextlistAddLastString(List list, String string, int n2, int n3) {
        int n4 = string.length();
        int n5 = n2 - n4;
        StringBuffer stringBuffer = new StringBuffer();
        if (n3 == 0) {
            int n6;
            int n7 = n5 / 2;
            int n8 = n5 - n7;
            for (n6 = 0; n6 < n7; ++n6) {
                stringBuffer.append('\u3000');
            }
            stringBuffer.append(string);
            for (n6 = 0; n6 < n8; ++n6) {
                stringBuffer.append('\u3000');
            }
            list.add(stringBuffer.toString());
        } else if (n3 == 1) {
            int n9 = n5;
            stringBuffer.append(string);
            for (int i2 = 0; i2 < n9; ++i2) {
                stringBuffer.append('\u3000');
            }
            list.add(stringBuffer.toString());
        } else if (n3 == 3) {
            int n10 = n5;
            for (int i3 = 0; i3 < n10; ++i3) {
                stringBuffer.append('\u3000');
            }
            stringBuffer.append(string);
            list.add(stringBuffer.toString());
        }
    }

    private static void lineTextListNotWrapText(List list, String string, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2;
            if (i2 >= string.length() || (c2 = string.charAt(i2)) == '\n') continue;
            if (c2 == '\\') {
                if (i2 + 1 < string.length() && string.charAt(i2 + 1) == 'n') {
                    ++i2;
                    continue;
                }
                stringBuffer.append(c2);
                nArray[0] = nArray[0] + 1;
                continue;
            }
            stringBuffer.append(c2);
            nArray[0] = nArray[0] + 1;
        }
        list.add(stringBuffer.toString());
        stringBuffer.delete(0, stringBuffer.length());
    }

    private static void verticalToHorizontal(List list, List list2, FontMetrics fontMetrics, int[] nArray, Style style) {
        for (int i2 = 0; i2 < nArray[0]; ++i2) {
            char c2;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            if (style.getTextDirection() == 1) {
                for (n2 = 0; n2 < list.size(); ++n2) {
                    if (((String)list.get(n2)).length() > i2) {
                        c2 = ((String)list.get(n2)).charAt(i2);
                        stringBuffer.append(c2);
                        if (fontMetrics.charWidth(c2) != ONECHARACTERLEN) continue;
                        stringBuffer.append(' ');
                        continue;
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(' ');
                }
            } else {
                for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    if (((String)list.get(n2)).length() > i2) {
                        c2 = ((String)list.get(n2)).charAt(i2);
                        stringBuffer.append(c2);
                        if (fontMetrics.charWidth(c2) != ONECHARACTERLEN) continue;
                        stringBuffer.append(' ');
                        continue;
                    }
                    stringBuffer.append(' ');
                    stringBuffer.append(' ');
                }
            }
            list2.add(stringBuffer.toString());
        }
    }

    private static String half2Full(String string) {
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == ' ') {
                cArray[i2] = 12288;
                continue;
            }
            if (cArray[i2] <= ' ' || cArray[i2] >= '\u007f') continue;
            cArray[i2] = (char)(cArray[i2] + 65248);
        }
        return new String(cArray);
    }
}

