/*
 * Decompiled with CFR 0.152.
 */
package com.fr.record;

import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.data.core.db.dialect.HSQLDialect;
import com.fr.data.core.db.dml.Delete;
import com.fr.data.core.db.dml.Table;
import com.fr.data.core.db.dml.Where;
import com.fr.general.DateUtils;
import com.fr.general.FRLogCleanAttr;
import com.fr.general.FRLogger;
import com.fr.general.IOUtils;
import com.fr.record.DBRecordManager;
import com.fr.record.JdbcTemplate;
import com.fr.stable.StableUtils;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class DBRecordUtils {
    private static int DAYOFWEEK = 7;
    private static int DAYOFMOUTH = 30;
    private static int HOUROFDAY = 24;
    private static int SECONDOFHOUR = 3600;
    private static int THOUSAND = 1000;
    private static String[] TABLES_LOG = new String[]{"fr_errrecord", "fr_fsrecord", "fr_schedulerecord"};
    private static String[] TABLES_RECORD_PROTECT = new String[]{"fr_exerecord", "fr_exprecord", "fr_ptrecord", "fr_functionrecord"};

    public static void cleanLogTables() {
        FRLogCleanAttr fRLogCleanAttr = ConfigManager.getProviderInstance().getLogCleanAttr();
        String string = FRContext.getCurrentEnv().getPath();
        String string2 = StableUtils.pathJoin(string, "logdb");
        String string3 = DateUtils.getDate2AllIncludeSSS(new Date(System.currentTimeMillis()));
        String string4 = StableUtils.pathJoin(string, "logdbcopy", "logdb" + string3);
        try {
            IOUtils.copyFilesInDirByPath(string2, string4);
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error("Logdb Copy failed! : " + iOException.getMessage(), iOException);
        }
        DBRecordUtils.cleanNormalTables(fRLogCleanAttr);
        DBRecordUtils.cleanProtectedTables(fRLogCleanAttr);
    }

    private static void doTableClean(String string, Where where) throws Exception {
        Delete delete = new Delete(new Table(string), where, new HSQLDialect());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(DBRecordManager.getDB());
        jdbcTemplate.execute(delete);
    }

    private static void cleanNormalTables(FRLogCleanAttr fRLogCleanAttr) {
        int n2 = fRLogCleanAttr.getFrLogCleanRate() / DAYOFMOUTH;
        Date date = n2 == 0 ? new Date(System.currentTimeMillis() - (long)fRLogCleanAttr.getFrLogCleanRate() * (long)HOUROFDAY * (long)SECONDOFHOUR * (long)THOUSAND) : DBRecordUtils.getOffsetMonth1st(-n2);
        Where where = new Where();
        where.addColumn("logtime", 93, 4, date);
        for (String string : TABLES_LOG) {
            try {
                DBRecordUtils.doTableClean(string, where);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Log_DelTimerTask action failed! exception occur in cleaning " + string);
            }
        }
    }

    private static void cleanProtectedTables(FRLogCleanAttr fRLogCleanAttr) {
        Where where = new Where();
        int n2 = fRLogCleanAttr.getFrLogCleanRate() / DAYOFMOUTH;
        int n3 = n2 == 0 ? -1 : -n2;
        Date date = DBRecordUtils.getOffsetMonth1st(n3);
        where.addColumn("logtime", 93, 4, date);
        for (String string : TABLES_RECORD_PROTECT) {
            try {
                DBRecordUtils.doTableClean(string, where);
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("Log_DelTimerTask action failed! exception occur in cleaning " + string);
            }
        }
    }

    public static Date getOffsetMonth1st(int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.add(2, n2);
        return calendar.getTime();
    }
}

