/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.dao;

import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.performance.dao.FileManager;
import com.fr.performance.dao.InfoReader;
import com.fr.performance.info.InfoCreator;
import com.fr.performance.info.PerformanceInfo;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONInfoReader<T extends PerformanceInfo>
implements InfoReader<T> {
    private InputStream in;
    private static final int IMPOSSIBILITY_LEN = 0x100000;
    private byte[] fillMarkBuf = new byte[FileManager.INFO_MARK.length];
    private byte[] jsonBuf = new byte[0];
    private InfoCreator<T> infoCreator;

    public void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public void setInfoCreator(InfoCreator<T> infoCreator) {
        this.infoCreator = infoCreator;
    }

    @Override
    public T read() {
        T t2;
        block6: {
            if (this.in == null) {
                return null;
            }
            t2 = null;
            try {
                t2 = this.readObject();
            }
            catch (EOFException eOFException) {
                return null;
            }
            catch (IOException iOException) {
                if (this.in == null) break block6;
                try {
                    this.in.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }
        return t2;
    }

    @Override
    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private T readObject() throws IOException {
        this.nextMark();
        int n2 = this.readInt();
        if (n2 > 0x100000) {
            return this.rereadObject();
        }
        this.ensureBufCapacity(n2);
        this.in.read(this.jsonBuf, 0, n2);
        try {
            JSONObject jSONObject = new JSONObject(new String(this.jsonBuf, "UTF-8"));
            T t2 = this.newInfo();
            try {
                t2.parseJSON(jSONObject);
            }
            catch (Exception exception) {
                throw new JSONException(exception);
            }
            return t2;
        }
        catch (JSONException jSONException) {
            return this.rereadObject();
        }
    }

    private T rereadObject() throws IOException {
        return this.readObject();
    }

    private void ensureBufCapacity(int n2) {
        if (n2 > this.jsonBuf.length) {
            this.jsonBuf = new byte[n2];
        }
    }

    private int readInt() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.in.read();
        if ((n5 | (n4 = this.in.read()) | (n3 = this.in.read()) | (n2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
    }

    private boolean nextMark() throws IOException {
        int n2;
        int n3 = 0;
        while ((n2 = this.in.read()) != -1) {
            if ((byte)n2 == FileManager.INFO_MARK[n3]) {
                if (++n3 != FileManager.INFO_MARK.length) continue;
                return true;
            }
            n3 = 0;
        }
        return false;
    }

    protected T newInfo() {
        return this.infoCreator.newInfo();
    }
}

