/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.stable;

import com.fr.base.ChartPreStyleServerManager;
import com.fr.base.ConfigManager;
import com.fr.base.FRContext;
import com.fr.data.TableDataSource;
import com.fr.form.main.ExtraFormClassManager;
import com.fr.form.main.Form;
import com.fr.form.stable.fun.AbstractFormActor;
import com.fr.general.DeclareRecordType;
import com.fr.general.ExecuteInfo;
import com.fr.general.FRLogManager;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.LogDuration;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.StringUtils;
import com.fr.stable.fun.JavaScriptPlaceHolder;
import com.fr.stable.fun.StylePlaceHolder;
import com.fr.stable.web.Repository;
import com.fr.web.Browser;
import com.fr.web.RepositoryDeal;
import com.fr.web.ResourceHelper;
import com.fr.web.core.FormSessionIDInfor;
import com.fr.web.core.SessionDealWith;
import com.fr.web.core.SessionIDInfor;
import com.fr.web.utils.WebUtils;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultFormActor
extends AbstractFormActor {
    private String CONFIG = "config";
    private String PARA_CONFIG = "paraConfig";
    private String DOCTYPE = "DOCTYPE";
    private long TEN = 10L;
    private String[] EXCLUDE_PARA = new String[]{this.CONFIG, this.PARA_CONFIG, this.DOCTYPE};
    private static DefaultFormActor defaultFormActor;

    private DefaultFormActor() {
    }

    public static DefaultFormActor getInstance() {
        if (defaultFormActor == null) {
            defaultFormActor = new DefaultFormActor();
        }
        return defaultFormActor;
    }

    @Override
    public String panelType() {
        return "form";
    }

    @Override
    public void dealWithFormData(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        FormSessionIDInfor formSessionIDInfor = (FormSessionIDInfor)SessionDealWith.getSessionIDInfor((String)string);
        if (formSessionIDInfor == null) {
            return;
        }
        RepositoryDeal repositoryDeal = new RepositoryDeal(httpServletRequest, (SessionIDInfor)formSessionIDInfor, 96);
        if (repositoryDeal.getDevice().isMobile()) {
            this.writeJSON(httpServletResponse, formSessionIDInfor, repositoryDeal);
        } else {
            boolean bl = !Browser.resolve(httpServletRequest).shouldCheckHTMLType();
            this.writeHtml(httpServletResponse, formSessionIDInfor, repositoryDeal, string, bl);
        }
    }

    @Override
    public int currentAPILevel() {
        return super.currentAPILevel();
    }

    private JSONObject getJSON(HttpServletResponse httpServletResponse, FormSessionIDInfor formSessionIDInfor, Repository repository) throws Exception {
        Form form = formSessionIDInfor.getForm2Show();
        Calculator calculator = this.mixCalculate2Form(form);
        form.initWidgetData(repository, calculator);
        return form.createPara4Mobile(repository, (SessionIDInfor)formSessionIDInfor);
    }

    private void writeJSON(HttpServletResponse httpServletResponse, FormSessionIDInfor formSessionIDInfor, Repository repository) throws Exception {
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(this.getJSON(httpServletResponse, formSessionIDInfor, repository));
        printWriter.flush();
        printWriter.close();
    }

    private void writeHtml(HttpServletResponse httpServletResponse, FormSessionIDInfor formSessionIDInfor, Repository repository, String string, boolean bl) throws Exception {
        this.noCache(httpServletResponse);
        Map<String, Object> map = this.initMap4Form(formSessionIDInfor, repository, string, bl);
        WebUtils.writeOutTemplate((String)"/com/fr/web/core/form.html", (HttpServletResponse)httpServletResponse, map);
    }

    private Map<String, Object> initMap4Form(FormSessionIDInfor formSessionIDInfor, Repository repository, String string, boolean bl) {
        Form form = formSessionIDInfor.getForm2Show();
        Calculator calculator = this.mixCalculate2Form(form);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            String string2;
            String string3;
            hashMap.put("charset", ConfigManager.getProviderInstance().getServerCharset());
            hashMap.put("formlet_title", formSessionIDInfor.getWebTitle());
            JSONObject jSONObject = form.createParaJSONConfig(repository, calculator);
            hashMap.put("paraConfig", jSONObject.optBoolean("paraDisplay") ? jSONObject : JSONObject.EMPTY);
            hashMap.put("config", form.createContentJSONConfig(repository, calculator, false));
            hashMap.put("Baidu", ChartPreStyleServerManager.getProviderInstance().getBaiduSource());
            hashMap.put("Google", ChartPreStyleServerManager.getProviderInstance().getGoogleSource());
            hashMap.put("csslink", WebUtils.getCSSLinks((Calculator)calculator));
            hashMap.put("jslink", WebUtils.getJSLinks((Calculator)calculator));
            hashMap.put("__v__", GeneralUtils.readBuildNO());
            hashMap.put("jsVersion", ResourceHelper.getJsVersion());
            hashMap.put("cssVersion", ResourceHelper.getCssVersion());
            if (bl) {
                hashMap.put("DOCTYPE", "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">");
            }
            if (StringUtils.isNotEmpty(string3 = this.createScriptPlaceHolderString())) {
                hashMap.put("FormScript", string3);
            }
            if (StringUtils.isNotEmpty(string2 = this.createStylePlaceHolderString())) {
                hashMap.put("FormStyle", string2);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().error(exception.getMessage());
        }
        return hashMap;
    }

    private String createScriptPlaceHolderString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set set = ExtraFormClassManager.getInstance().getArray("JavaScriptPlaceHolder");
        for (JavaScriptPlaceHolder javaScriptPlaceHolder : set) {
            stringBuilder.append(javaScriptPlaceHolder.placeHolderContent());
        }
        return stringBuilder.toString();
    }

    private String createStylePlaceHolderString() {
        StringBuilder stringBuilder = new StringBuilder();
        Set set = ExtraFormClassManager.getInstance().getArray("StylePlaceHolder");
        for (StylePlaceHolder stylePlaceHolder : set) {
            stringBuilder.append(stylePlaceHolder.placeHolderContent());
        }
        return stringBuilder.toString();
    }

    private Map<String, Object> getPara4EC(FormSessionIDInfor formSessionIDInfor, Form form, Repository repository) {
        Map map = formSessionIDInfor.getParameterMap4Execute();
        Map<String, Object> map2 = form.getWidgetDefaultValueMap(map, repository);
        map2.putAll(map);
        return map2;
    }

    private void noCache(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Pragma", "No-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store");
        httpServletResponse.setDateHeader("Expires", -this.TEN);
    }

    private Calculator mixCalculate2Form(Form form) {
        Calculator calculator = Calculator.createCalculator();
        calculator.setAttribute(TableDataSource.KEY, (Object)form);
        return calculator;
    }

    private void formExecuteLogRecord(FormSessionIDInfor formSessionIDInfor, long l2, long l3, Map map, String string) {
        FRLogManager.setSession((LogDuration)formSessionIDInfor);
        try {
            String string2 = FRLogger.createParamString(map, this.EXCLUDE_PARA);
            long l4 = l3 - l2;
            ExecuteInfo executeInfo = new ExecuteInfo(string2, l4, string);
            FRContext.getLogger().getRecordManager().recordExecuteInfo(formSessionIDInfor.getBookPath(), DeclareRecordType.EXECUTE_TYPE_FORM, executeInfo);
        }
        catch (Throwable throwable) {
            FRContext.getLogger().log(Level.WARNING, throwable.getMessage(), throwable);
            FRContext.getLogger().log(Level.WARNING, "RecordManager error. Record is close.");
        }
    }
}

