/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.general.Inter;
import com.fr.stable.ParameterProvider;
import com.fr.stable.fun.impl.AbstractTableDataProvider;
import com.fr.stable.script.CalculatorProvider;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EscapeSqlHelper
extends AbstractTableDataProvider {
    private static final EscapeSqlHelper ESCAPE_SQL_HELPER = new EscapeSqlHelper();
    private Set<String> selectedForbidWordSet = new LinkedHashSet<String>();
    private Set<Pattern> forbidWordPatternSet = new LinkedHashSet<Pattern>();
    private Set<String> selectedSpecialCharSet = new LinkedHashSet<String>();
    private boolean useForbidWord = false;
    private boolean useEscapeSpecialChar = false;

    private EscapeSqlHelper() {
    }

    public void setSelectedForbidWord(String[] stringArray) {
        this.selectedForbidWordSet.clear();
        Collections.addAll(this.selectedForbidWordSet, stringArray);
        this.compileForbidWord(this.selectedForbidWordSet);
    }

    private void compileForbidWord(Iterable<String> iterable) {
        this.forbidWordPatternSet.clear();
        for (String string : iterable) {
            Pattern pattern = Pattern.compile(string);
            this.forbidWordPatternSet.add(pattern);
        }
    }

    public void addSelectedForbidWord(String string) {
        this.selectedForbidWordSet.add(string);
        this.compileForbidWord(this.selectedForbidWordSet);
    }

    public void setSelectedSpecialChar(String[] stringArray) {
        this.selectedSpecialCharSet.clear();
        Collections.addAll(this.selectedSpecialCharSet, stringArray);
    }

    public void addSelectedSpecialChar(String string) {
        this.selectedSpecialCharSet.add(string);
    }

    public void delSelectedForbidWord(String[] stringArray) {
        for (String string : stringArray) {
            this.selectedForbidWordSet.remove(string);
        }
        this.compileForbidWord(this.selectedForbidWordSet);
    }

    public void delSelectedSpecialChar(String[] stringArray) {
        for (String string : stringArray) {
            this.selectedSpecialCharSet.remove(string);
        }
    }

    public void setUseForbidWord(boolean bl) {
        this.useForbidWord = bl;
    }

    public void setUseEscapeSpecialChar(boolean bl) {
        this.useEscapeSpecialChar = bl;
    }

    public static EscapeSqlHelper getInstance() {
        return ESCAPE_SQL_HELPER;
    }

    private boolean hasForbidWord(String string) {
        for (Pattern pattern : this.forbidWordPatternSet) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private String escapeSpecialChar(String string) {
        String string2 = string;
        for (String string3 : this.selectedSpecialCharSet) {
            string2 = string2.replaceAll(string3, "");
        }
        return string2;
    }

    private void processEscape(ParameterProvider[] parameterProviderArray) {
        for (ParameterProvider parameterProvider : parameterProviderArray) {
            Object object = parameterProvider.getValue();
            if (!(object instanceof String)) continue;
            String string = (String)object;
            if (this.useEscapeSpecialChar) {
                string = this.escapeSpecialChar(string);
                parameterProvider.setValue(string);
            }
            if (!this.useForbidWord || !this.hasForbidWord(string)) continue;
            throw new RuntimeException(Inter.getLocText("FS-PSqlInj-Forbid_Word_Error"));
        }
    }

    @Override
    public String mark4Provider() {
        return this.getClass().getName();
    }

    @Override
    public int currentAPILevel() {
        return 1;
    }

    @Override
    public void processParametersBeforeAnalyzeSQL(ParameterProvider[] parameterProviderArray, CalculatorProvider calculatorProvider) {
        this.processEscape(parameterProviderArray);
    }

    @Override
    public String processTableDataSQL(ParameterProvider[] parameterProviderArray, String string, CalculatorProvider calculatorProvider) {
        return string;
    }
}

