/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.core;

import com.fr.base.ClassComparator;
import com.fr.base.TableData;
import com.fr.data.Dictionary;
import com.fr.data.condition.CommonCondition;
import com.fr.data.condition.FormulaCondition;
import com.fr.data.condition.ListCondition;
import com.fr.data.condition.ObjectCondition;
import com.fr.data.core.datasource.FileDataSource;
import com.fr.data.core.datasource.URLDataSource;
import com.fr.data.impl.Connection;
import com.fr.data.impl.CustomDictionary;
import com.fr.data.impl.DBTableData;
import com.fr.data.impl.DatabaseDictionary;
import com.fr.data.impl.EmbeddedTableData;
import com.fr.data.impl.JDBCDatabaseConnection;
import com.fr.data.impl.JNDIDatabaseConnection;
import com.fr.data.impl.NameDatabaseConnection;
import com.fr.data.impl.NameTableData;
import com.fr.data.impl.RecursionTableData;
import com.fr.data.impl.TableDataDictionary;
import com.fr.data.impl.storeproc.StoreProcedure;
import com.fr.data.util.function.DataFunction;
import com.fr.data.util.function.NoneFunction;
import com.fr.file.DatasourceManager;
import com.fr.file.DatasourceManagerProvider;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.data.Condition;
import com.fr.general.data.DataSource;
import com.fr.stable.StableUtils;
import com.fr.stable.xml.XMLObject;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.util.Comparator;

public class DataCoreXmlUtils {
    private DataCoreXmlUtils() {
    }

    public static void writeXMLConnection(XMLPrintWriter xMLPrintWriter, Connection connection) {
        DataCoreXmlUtils.writeXMLConnection(xMLPrintWriter, connection, null);
    }

    public static void writeXMLConnection(XMLPrintWriter xMLPrintWriter, Connection connection, String string) {
        if (connection == null) {
            return;
        }
        xMLPrintWriter.startTAG("Connection");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", connection.getClass().getName());
        connection.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeXMLTableData(XMLPrintWriter xMLPrintWriter, TableData tableData) {
        DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, tableData, null);
    }

    public static void writeXMLTableDataArray(XMLPrintWriter xMLPrintWriter, TableData[] tableDataArray) {
        int n2;
        xMLPrintWriter.startTAG("TableDatas");
        int n3 = n2 = tableDataArray == null ? 0 : tableDataArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            DataCoreXmlUtils.writeXMLTableData(xMLPrintWriter, tableDataArray[i2], null);
        }
        xMLPrintWriter.end();
    }

    public static void writeXMLTableData(XMLPrintWriter xMLPrintWriter, TableData tableData, String string) {
        if (tableData == null) {
            return;
        }
        xMLPrintWriter.startTAG("TableData");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", tableData.getClass().getName());
        tableData.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeXMLStoreProcedure(XMLPrintWriter xMLPrintWriter, StoreProcedure storeProcedure, String string) {
        if (storeProcedure == null) {
            return;
        }
        xMLPrintWriter.startTAG("StoreProcedure");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", storeProcedure.getClass().getName());
        storeProcedure.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static void writeXMLDictionary(XMLPrintWriter xMLPrintWriter, Dictionary dictionary) {
        DataCoreXmlUtils.writeXMLDictionary(xMLPrintWriter, dictionary, null);
    }

    public static void writeXMLDictionary(XMLPrintWriter xMLPrintWriter, Dictionary dictionary, String string) {
        if (dictionary == null) {
            return;
        }
        xMLPrintWriter.startTAG("Dictionary");
        if (string != null) {
            xMLPrintWriter.attr("name", string);
        }
        xMLPrintWriter.attr("class", dictionary.getClass().getName());
        dictionary.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static DataFunction readXMLDataFunction(String string) {
        string = StableUtils.replaceAllString(string, "com.fr.data.function", "com.fr.data.impl.function");
        string = StableUtils.replaceAllString(string, "com.fr.data.impl.function", "com.fr.data.util.function");
        try {
            return (DataFunction)GeneralUtils.classForName(string).newInstance();
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage(), exception);
            return new NoneFunction();
        }
    }

    public static Connection readXMLConnectionMap(XMLableReader xMLableReader) {
        final DatasourceManagerProvider datasourceManagerProvider = DatasourceManager.getProviderInstance();
        XMLObject xMLObject = new XMLObject(null){

            public void readXML(XMLableReader xMLableReader) {
                if (xMLableReader.isAttr()) {
                    datasourceManagerProvider.clearAllConnection();
                }
                if (xMLableReader.isChildNode() && "Connection".equals(xMLableReader.getTagName())) {
                    String string = null;
                    String string2 = null;
                    string2 = xMLableReader.getAttrAsString("name", null);
                    if (string2 != null) {
                        string = string2;
                    }
                    if (string == null) {
                        return;
                    }
                    this.obj = DataCoreXmlUtils.readXMLConnection(xMLableReader);
                    datasourceManagerProvider.putConnection(string, (Connection)this.obj);
                }
            }
        };
        xMLableReader.readXMLObject(xMLObject);
        return (Connection)xMLObject.getObject();
    }

    public static Connection readXMLConnection(XMLableReader xMLableReader) {
        Connection connection = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.indexOf(".JDBCDatabase") > 0) {
                connection = new JDBCDatabaseConnection();
            } else if (string.indexOf(".JNDIDatabase") > 0) {
                connection = new JNDIDatabaseConnection();
            } else if (string.endsWith(".NameDatabase")) {
                connection = new NameDatabaseConnection();
            } else {
                try {
                    connection = (Connection)GeneralUtils.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
            }
            if (connection != null) {
                xMLableReader.readXMLObject(connection);
            }
        }
        return connection;
    }

    public static StoreProcedure readXMLStoreProcedure(XMLableReader xMLableReader) {
        StoreProcedure storeProcedure = null;
        storeProcedure = new StoreProcedure();
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null && string.endsWith(".StoreProcedure")) {
            xMLableReader.readXMLObject(storeProcedure);
        }
        return storeProcedure;
    }

    public static TableData readXMLTableData(XMLableReader xMLableReader) {
        TableData tableData = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".TableData$1")) {
                tableData = TableData.EMPTY_TABLEDATA;
            } else {
                boolean bl;
                boolean bl2 = bl = string.endsWith(".DBTableData") || string.endsWith(".JDBCTableData");
                if (bl || string.equals("JDBCTableData")) {
                    tableData = new DBTableData();
                } else if (string.endsWith(".EmbeddedTableData")) {
                    tableData = new EmbeddedTableData();
                } else if (string.endsWith(".NameTableData")) {
                    tableData = new NameTableData();
                } else if (string.endsWith(".GlobalRecursionTableData")) {
                    tableData = new RecursionTableData();
                } else {
                    try {
                        tableData = (TableData)GeneralUtils.classForName(string).newInstance();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                xMLableReader.readXMLObject(tableData);
            }
        }
        return tableData;
    }

    public static Dictionary readXMLDictionary(XMLableReader xMLableReader) {
        Dictionary dictionary = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            boolean bl;
            boolean bl2 = string.endsWith(".TableDataDict") || string.endsWith(".TableDataMap");
            boolean bl3 = string.endsWith(".DBDict") || string.endsWith(".DBMap");
            boolean bl4 = string.endsWith(".JDBCMap") || string.endsWith(".SimpleDBMap");
            boolean bl5 = bl3 || bl4;
            boolean bl6 = string.endsWith(".CustomDictionary") || string.endsWith(".CustomDict");
            boolean bl7 = bl = string.endsWith(".CustomMap") || string.endsWith(".ListMap");
            if (string.endsWith(".TableDataDictionary") || bl2) {
                dictionary = new TableDataDictionary();
            } else if (string.endsWith(".DatabaseDictionary") || bl5) {
                dictionary = new DatabaseDictionary();
            } else if (bl6 || bl) {
                dictionary = new CustomDictionary();
            } else {
                try {
                    dictionary = (Dictionary)GeneralUtils.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                    dictionary = new CustomDictionary();
                }
            }
            xMLableReader.readXMLObject(dictionary);
        }
        return dictionary;
    }

    public static Condition readCondition(XMLableReader xMLableReader) {
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            try {
                Condition condition = (Condition)GeneralUtils.classForName(string).newInstance();
                xMLableReader.readXMLObject(condition);
                return condition;
            }
            catch (Exception exception) {
                FRLogger.getLogger().error(exception.getMessage(), exception);
            }
        }
        return null;
    }

    public static Comparator readXMLComparator(XMLableReader xMLableReader) {
        Comparator comparator = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".ClassComparator")) {
                comparator = new ClassComparator();
            } else {
                try {
                    comparator = (Comparator)GeneralUtils.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
            }
            if (comparator instanceof XMLable) {
                xMLableReader.readXMLObject((XMLReadable)((Object)comparator));
            }
        }
        return comparator;
    }

    public static void writeXMLComparator(XMLPrintWriter xMLPrintWriter, Comparator comparator) {
        if (comparator == null) {
            return;
        }
        xMLPrintWriter.startTAG("Comparator").attr("class", comparator.getClass().getName());
        if (comparator instanceof XMLable) {
            ((XMLable)((Object)comparator)).writeXML(xMLPrintWriter);
        }
        xMLPrintWriter.end();
    }

    public static Condition readXMLCondition(XMLableReader xMLableReader) {
        Condition condition = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if (string.endsWith(".CommonCondition")) {
                condition = new CommonCondition();
            } else if (string.endsWith(".FormulaCondition")) {
                condition = new FormulaCondition();
            } else if (string.endsWith(".ListCondition")) {
                condition = new ListCondition();
            } else if (string.endsWith(".ObjectCondition")) {
                condition = new ObjectCondition();
            } else {
                try {
                    Class clazz = GeneralUtils.classForName(string);
                    condition = (Condition)clazz.newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                    condition = new ListCondition();
                }
            }
            xMLableReader.readXMLObject(condition);
        }
        return condition;
    }

    public static void writeXMLCondition(XMLPrintWriter xMLPrintWriter, Condition condition) {
        if (condition == null) {
            return;
        }
        xMLPrintWriter.startTAG("Condition").attr("class", condition.getClass().getName());
        condition.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }

    public static DataSource readXMLDataSource(XMLableReader xMLableReader) {
        DataSource dataSource = null;
        String string = xMLableReader.getAttrAsString("class", null);
        if (string != null) {
            if ((string = string.trim()).endsWith(".FileDataSource")) {
                dataSource = new FileDataSource();
            } else if (string.endsWith(".URLDataSource")) {
                dataSource = new URLDataSource();
            } else {
                try {
                    dataSource = (DataSource)GeneralUtils.classForName(string).newInstance();
                }
                catch (Exception exception) {
                    FRLogger.getLogger().error(exception.getMessage(), exception);
                }
            }
            if (dataSource instanceof XMLable) {
                xMLableReader.readXMLObject(dataSource);
            }
        }
        return dataSource;
    }

    public static void writeXMLDataSource(XMLPrintWriter xMLPrintWriter, DataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        xMLPrintWriter.startTAG("DataSource").attr("class", dataSource.getClass().getName());
        dataSource.writeXML(xMLPrintWriter);
        xMLPrintWriter.end();
    }
}

