/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.web;

import com.fr.base.Base64;
import com.fr.base.MapXMLHelper;
import com.fr.chart.base.ChartBaseUtils;
import com.fr.chart.base.ColorSelect4Shape;
import com.fr.chart.chartglyph.MapAttr;
import com.fr.chart.chartglyph.MapPlotGlyph;
import com.fr.chart.chartglyph.MapShapeValue;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.web.Device;
import com.fr.web.Browser;
import com.fr.web.core.ActionNoSessionCMD;
import com.fr.web.utils.WebUtils;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.JPanel;

public class ChartMapLayerAction
extends ActionNoSessionCMD {
    private static final double RSIZE = 5.0;

    public void actionCMD(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws Exception {
        JSONObject jSONObject = new JSONObject();
        String string2 = CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"mapName"));
        String string3 = CodeUtils.cjkDecode(WebUtils.getHTTPRequestParameter((HttpServletRequest)httpServletRequest, (String)"storedID"));
        MapAttr mapAttr = (MapAttr)MapXMLHelper.getInstance().getMapAttr(string2);
        if (mapAttr == null || mapAttr.getMapImage() == null) {
            return;
        }
        if (string3 != null && ComparatorUtils.equals(string3, "-1")) {
            jSONObject.put("versionid", mapAttr.getVersionID());
            PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
            printWriter.print(jSONObject);
            printWriter.flush();
            printWriter.close();
            return;
        }
        Image image = mapAttr.getMapImage();
        int n2 = image.getWidth(new JPanel());
        int n3 = image.getHeight(new JPanel());
        ColorSelect4Shape colorSelect4Shape = new ColorSelect4Shape();
        colorSelect4Shape.makesureImage(image);
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("mapName", string2);
        jSONObject2.put("mapWidth", n2);
        jSONObject2.put("mapHeight", n3);
        Device device = WebUtils.getDevice((HttpServletRequest)httpServletRequest);
        if (device.isMobile()) {
            jSONObject2.put("img", Base64.encode(image, "png"));
        } else if (Browser.resolve(httpServletRequest).isIE()) {
            jSONObject2.put("onie", ChartBaseUtils.addImageAsEmb(image));
        } else {
            jSONObject2.put("onsrc", "data:image/png;base64," + Base64.encode(image, "png"));
        }
        jSONArray.put(jSONObject2);
        jSONObject.put("mapName", string2);
        jSONObject.put("imageBounds", jSONArray);
        jSONObject.put("versionid", mapAttr.getVersionID());
        HashMap hashMap = this.dealShapePaths(mapAttr, colorSelect4Shape);
        MapPlotGlyph.putPathMap2Json(device, mapAttr, hashMap, jSONObject);
        PrintWriter printWriter = WebUtils.createPrintWriter((HttpServletResponse)httpServletResponse);
        printWriter.print(jSONObject);
        printWriter.flush();
        printWriter.close();
    }

    private HashMap dealShapePaths(MapAttr mapAttr, ColorSelect4Shape colorSelect4Shape) {
        HashMap<String, GeneralPath> hashMap = new HashMap<String, GeneralPath>();
        Iterator iterator = mapAttr.shapeValuesIterator();
        while (iterator.hasNext()) {
            GeneralPath generalPath;
            String string = (String)iterator.next();
            MapShapeValue mapShapeValue = mapAttr.getShapeValue(string);
            if (mapShapeValue == null) continue;
            Point[] pointArray = mapShapeValue.getShape();
            if (mapShapeValue.getMarkType() == 0) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)pointArray[0].getX(), (float)pointArray[0].getY());
                double d2 = 5.0;
                double d3 = pointArray[0].getX() - d2;
                double d4 = pointArray[0].getY() - d2;
                generalPath.append(new Arc2D.Double(d3, d4, d2 * 2.0, d2 * 2.0, 0.0, 360.0, 0), false);
                hashMap.put(mapShapeValue.getName(), generalPath);
                continue;
            }
            generalPath = new GeneralPath();
            for (int i2 = 0; i2 < pointArray.length; ++i2) {
                colorSelect4Shape.makesureClickPoint(pointArray[i2].getX(), pointArray[i2].getY());
                GeneralPath generalPath2 = colorSelect4Shape.getSelectedPath();
                generalPath.append(generalPath2, false);
            }
            hashMap.put(mapShapeValue.getName(), generalPath);
        }
        return hashMap;
    }

    public String getCMD() {
        return "map_layerto";
    }
}

