/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.FCloneable;
import com.fr.stable.StringUtils;
import java.io.Serializable;

public class StockLabel
implements FCloneable,
Serializable {
    public static final String VOLUMEN = Inter.getLocText("Chart-Stock_Volume");
    public static final String OPEN = Inter.getLocText("Chart-Stock_Open");
    public static final String HIGHT = Inter.getLocText("Chart-Stock_High");
    public static final String LOW = Inter.getLocText("Chart-Stock_Low");
    public static final String CLOSE = Inter.getLocText("FR-Chart-Stock_Close");
    private String volumeLabel = VOLUMEN;
    private String openLabel = OPEN;
    private String highLabel = HIGHT;
    private String lowLabel = LOW;
    private String closeLabel = CLOSE;
    private String volumnTip = "(" + VOLUMEN + ")";
    private String openTip = "(" + OPEN + ")";
    private String highTip = "(" + HIGHT + ")";
    private String lowTip = "(" + LOW + ")";
    private String closeTip = "(" + CLOSE + ")";

    public StockLabel() {
    }

    public StockLabel(String string, String string2, String string3, String string4, String string5) {
        this.volumeLabel = StringUtils.isEmpty(string) ? VOLUMEN : string;
        this.openLabel = StringUtils.isEmpty(string2) ? OPEN : string2;
        this.highLabel = StringUtils.isEmpty(string3) ? HIGHT : string3;
        this.lowLabel = StringUtils.isEmpty(string4) ? LOW : string4;
        this.closeLabel = StringUtils.isEmpty(string5) ? CLOSE : string5;
        this.dealWithLabelRule();
    }

    private void dealWithLabelRule() {
        if (!ComparatorUtils.equals(this.volumeLabel, VOLUMEN)) {
            this.volumeLabel = StringUtils.cutStringEndWith(this.volumeLabel, this.volumnTip);
        }
        if (!ComparatorUtils.equals(this.openLabel, OPEN)) {
            this.openLabel = StringUtils.cutStringEndWith(this.openLabel, this.openTip);
        }
        if (!ComparatorUtils.equals(this.highLabel, HIGHT)) {
            this.highLabel = StringUtils.cutStringEndWith(this.highLabel, this.highTip);
        }
        if (!ComparatorUtils.equals(this.lowLabel, LOW)) {
            this.lowLabel = StringUtils.cutStringEndWith(this.lowLabel, this.lowTip);
        }
        if (!ComparatorUtils.equals(this.closeLabel, CLOSE)) {
            this.closeLabel = StringUtils.cutStringEndWith(this.closeLabel, this.closeTip);
        }
    }

    public String getVolumeLabel() {
        return this.volumeLabel;
    }

    public String getOpenLabel() {
        return this.openLabel;
    }

    public String getHighLabel() {
        return this.highLabel;
    }

    public String getLowLabel() {
        return this.lowLabel;
    }

    public String getCloseLabel() {
        return this.closeLabel;
    }

    public boolean equals(Object object) {
        return object instanceof StockLabel && ComparatorUtils.equals(((StockLabel)object).getVolumeLabel(), this.getVolumeLabel()) && ComparatorUtils.equals(((StockLabel)object).getOpenLabel(), this.getOpenLabel()) && ComparatorUtils.equals(((StockLabel)object).getHighLabel(), this.getHighLabel()) && ComparatorUtils.equals(((StockLabel)object).getLowLabel(), this.getLowLabel()) && ComparatorUtils.equals(((StockLabel)object).getCloseLabel(), this.getCloseLabel());
    }

    public Object clone() throws CloneNotSupportedException {
        StockLabel stockLabel = (StockLabel)super.clone();
        stockLabel.volumeLabel = this.volumeLabel;
        stockLabel.openLabel = this.openLabel;
        stockLabel.highLabel = this.highLabel;
        stockLabel.lowLabel = this.lowLabel;
        stockLabel.closeLabel = this.closeLabel;
        return stockLabel;
    }
}

