/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartdata;

import com.fr.base.FRContext;
import com.fr.base.Formula;
import com.fr.base.Utils;
import com.fr.base.chart.chartdata.BaseReportDefinition;
import com.fr.base.chart.chartdata.ChartData;
import com.fr.base.chart.chartdata.model.DataProcessor;
import com.fr.calculate.SuperExecutor;
import com.fr.calculate.cell.BoxCEProvider;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartdata.BaseMapAreaValue;
import com.fr.chart.chartdata.BaseMapTitleValue;
import com.fr.chart.chartdata.MapChartData;
import com.fr.chart.chartdata.MapSingleLayerReportDefinition;
import com.fr.chart.chartdata.SeriesDefinition;
import com.fr.chart.chartdata.TopDefinition;
import com.fr.general.ComparatorUtils;
import com.fr.general.FArray;
import com.fr.general.data.MOD_COLUMN_ROW;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.FCloneable;
import com.fr.stable.Primitive;
import com.fr.stable.StringUtils;
import com.fr.stable.UtilEvalError;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReportDataDefinition
extends TopDefinition
implements BaseReportDefinition {
    private static final long serialVersionUID = -7944306985328284088L;
    public static final String XML_TAG = "ReportDataDefinition";
    private Object categoryName = null;

    public void setCategoryName(Object object) {
        this.categoryName = object;
    }

    public Object getCategoryName() {
        return this.categoryName;
    }

    @Override
    public String[] dependence(CalculatorProvider calculatorProvider) {
        return new String[0];
    }

    @Override
    public void modDefinitionFormulaString(MOD_COLUMN_ROW mOD_COLUMN_ROW) {
        mOD_COLUMN_ROW.mod_object(this.categoryName);
    }

    public abstract ChartData createChartData(Calculator var1);

    @Override
    public ChartData executeData(SuperExecutor superExecutor, BoxCEProvider boxCEProvider, Calculator calculator, CalculatorKey calculatorKey, DataProcessor dataProcessor) {
        return this.executeData(superExecutor, boxCEProvider, calculator, calculatorKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FArray calculateChartDataDefinition(Object object, Calculator calculator) {
        FArray fArray;
        Formula formula;
        if (object instanceof String) {
            String string = (String)object;
            if (!string.startsWith("=")) return new FArray<Object>(new Object[]{object});
            object = string.substring(1);
            formula = new Formula(object.toString());
        } else {
            if (!(object instanceof Formula)) return new FArray();
            formula = (Formula)object;
        }
        try {
            fArray = calculator.eval(formula.getContent());
        }
        catch (UtilEvalError utilEvalError) {
            fArray = new FArray();
            FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
        }
        if (!(fArray instanceof FArray)) return new FArray<Object>(new Object[]{fArray});
        return fArray;
    }

    protected HashMap<String, IntegerWrapper> dealFArrayInList(ArrayList arrayList, FArray fArray, Calculator calculator) {
        HashMap<String, IntegerWrapper> hashMap = new HashMap<String, IntegerWrapper>();
        if (this.checkAllBoxCE(fArray)) {
            this.dealWidthAllBoxCE(arrayList, fArray, calculator, hashMap);
        } else {
            FArray fArray2 = fArray;
            int n2 = fArray2.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (fArray2.elementAt(i2) instanceof List) {
                    List list = (List)fArray2.elementAt(i2);
                    int n3 = list.size();
                    for (int i3 = 0; i3 < n3; ++i3) {
                        if (!(list.get(i3) instanceof BoxCEProvider)) continue;
                        BoxCEProvider boxCEProvider = (BoxCEProvider)list.get(i3);
                        String string = Utils.objectToString(this.dealChartValueFormula(boxCEProvider.getValue(), calculator));
                        if (boxCEProvider.isExtend()) {
                            this.putIntoMap(hashMap, "", boxCEProvider.getRows());
                        }
                        arrayList.add(string);
                    }
                    continue;
                }
                arrayList.add(Utils.objectToString(fArray2.elementAt(i2)));
            }
        }
        return hashMap;
    }

    private void dealWidthAllBoxCE(ArrayList arrayList, FArray fArray, Calculator calculator, HashMap<String, IntegerWrapper> hashMap) {
        for (BoxCEProvider boxCEProvider : this.collectAndSortAsBoxArray(fArray, false)) {
            if (!(boxCEProvider.getValue() instanceof Primitive)) {
                Object object;
                int n2 = boxCEProvider.getColumnSpan();
                int n3 = boxCEProvider.getRowSpan();
                if (n2 > 1 || n3 > 1) {
                    object = Utils.objectToString(this.dealChartValueFormula(boxCEProvider.getValue(), calculator));
                    arrayList.add(object);
                    if (!boxCEProvider.isExtend()) continue;
                    this.putIntoMap(hashMap, (String)object, boxCEProvider.getRows());
                    continue;
                }
                object = boxCEProvider.getBeFrom();
                int n4 = object.get_ce_from().getColumnSpan();
                int n5 = object.get_ce_from().getRowSpan();
                int n6 = n2 - n4 + n3 - n5 + 1;
                for (int i2 = 0; i2 < n6; ++i2) {
                    String string = Utils.objectToString(this.dealChartValueFormula(boxCEProvider.getValue(), calculator));
                    arrayList.add(string);
                    if (!boxCEProvider.isExtend()) continue;
                    this.putIntoMap(hashMap, string, boxCEProvider.getRows());
                }
                continue;
            }
            arrayList.add("");
            if (!boxCEProvider.isExtend()) continue;
            this.putIntoMap(hashMap, "", boxCEProvider.getRows());
        }
    }

    private void putIntoMap(HashMap<String, IntegerWrapper> hashMap, String string, int[] nArray) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        if (!hashMap.containsKey(string)) {
            hashMap.put(string, new IntegerWrapper(nArray));
            return;
        }
        IntegerWrapper integerWrapper = hashMap.get(string);
        int[] nArray2 = ArrayUtils.addAll(integerWrapper.values, nArray);
        hashMap.remove(string);
        hashMap.put(string, new IntegerWrapper(nArray2));
    }

    private Object dealChartValueFormula(Object object, Calculator calculator) {
        Object object2;
        block5: {
            object2 = null;
            if (object instanceof Formula) {
                Formula formula = (Formula)object;
                try {
                    if (formula.getResult() != null) {
                        object2 = formula.getResult();
                        break block5;
                    }
                    object2 = calculator.evalValue(formula.getContent());
                }
                catch (UtilEvalError utilEvalError) {
                    FRContext.getLogger().error(utilEvalError.getMessage(), utilEvalError);
                }
            } else {
                object2 = object;
            }
        }
        return object2;
    }

    private boolean checkAllBoxCE(FArray fArray) {
        int n2 = fArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (fArray.elementAt(i2) instanceof List) continue;
            return false;
        }
        return true;
    }

    private BoxCEProvider[] collectAndSortAsBoxArray(FArray fArray, boolean bl) {
        if (fArray == null || fArray.length() == 0) {
            return new BoxCEProvider[0];
        }
        AbstractCollection abstractCollection = bl ? new HashSet() : new ArrayList();
        int n2 = fArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            List list;
            if (!(fArray.elementAt(i2) instanceof List) || (list = (List)fArray.elementAt(i2)).isEmpty()) continue;
            abstractCollection.addAll(list);
        }
        BoxCEProvider[] boxCEProviderArray = abstractCollection.toArray(new BoxCEProvider[abstractCollection.size()]);
        Arrays.sort(boxCEProviderArray, new Comparator(){

            public int compare(Object object, Object object2) {
                BoxCEProvider boxCEProvider = (BoxCEProvider)object;
                BoxCEProvider boxCEProvider2 = (BoxCEProvider)object2;
                int n2 = boxCEProvider.getRow() - boxCEProvider2.getRow();
                return n2 != 0 ? n2 : boxCEProvider.getColumn() - boxCEProvider2.getColumn();
            }
        });
        return boxCEProviderArray;
    }

    protected void dealValue2DList(FArray fArray, ArrayList arrayList, Calculator calculator) {
        ArrayList arrayList2 = new ArrayList();
        this.dealFArrayInList(arrayList2, fArray, calculator);
        arrayList.add(arrayList2);
    }

    public ChartData calculateChartDataWithFormCalculator(Calculator calculator) {
        ChartData chartData = null;
        try {
            ReportDataDefinition reportDataDefinition = (ReportDataDefinition)this.clone();
            if (reportDataDefinition != null) {
                chartData = reportDataDefinition.createChartData(calculator);
            }
            if (chartData != null) {
                chartData = reportDataDefinition.createTopChartData(chartData, calculator);
            }
        }
        catch (Exception exception) {
            FRContext.getLogger().errorWithServerLevel(exception.getMessage(), exception);
        }
        return chartData;
    }

    @Override
    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string;
            String string2 = xMLableReader.getTagName();
            if (ComparatorUtils.equals(string2, "Category")) {
                xMLableReader.readXMLObject(new XMLReadable(){

                    public void readXML(XMLableReader xMLableReader) {
                        if (xMLableReader.isChildNode() && ComparatorUtils.equals("O", xMLableReader.getTagName())) {
                            ReportDataDefinition.this.categoryName = GeneralXMLTools.readObject(xMLableReader);
                        }
                    }
                });
            } else if ((ComparatorUtils.equals(string2, "CategoryDefinition") || ComparatorUtils.equals(string2, "CategoryDefintion")) && (string = xMLableReader.getAttrAsString("value", null)) != null) {
                this.setCategoryName(ChartUtils.string2FormulaStr(string));
            }
        }
    }

    @Override
    public JSONObject createDataConfig() throws JSONException {
        return new JSONObject();
    }

    @Override
    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        if (this.getCategoryName() != null) {
            xMLPrintWriter.startTAG("Category");
            GeneralXMLTools.writeObject(xMLPrintWriter, this.getCategoryName());
            xMLPrintWriter.end();
        }
        super.writeXML(xMLPrintWriter);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ReportDataDefinition reportDataDefinition = (ReportDataDefinition)super.clone();
        if (this.categoryName instanceof FCloneable) {
            reportDataDefinition.categoryName = ((FCloneable)this.categoryName).clone();
        } else {
            reportDataDefinition.setCategoryName(this.getCategoryName());
        }
        return reportDataDefinition;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ReportDataDefinition && ComparatorUtils.equals(((ReportDataDefinition)object).categoryName, this.categoryName) && super.equals(object);
    }

    protected void dealDouble(ArrayList arrayList, HashMap<String, IntegerWrapper> hashMap) {
        if (arrayList.size() != hashMap.size()) {
            arrayList.clear();
            Set<String> set = hashMap.keySet();
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
        }
    }

    @Override
    public boolean isSupportAutoRefresh() {
        return false;
    }

    protected void dealDefinition4Map(MapSingleLayerReportDefinition mapSingleLayerReportDefinition, MapChartData mapChartData, Calculator calculator) {
        Object object;
        Object object2;
        int n2;
        ArrayList arrayList = this.getAreaNameWithDefinition(mapSingleLayerReportDefinition, calculator);
        int n3 = mapSingleLayerReportDefinition.getTitleValueSize();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (n2 = 0; n2 < n3; ++n2) {
            SeriesDefinition seriesDefinition = mapSingleLayerReportDefinition.getTitleValueWithIndex(n2);
            arrayList3.add(seriesDefinition.getSeriesName());
            object2 = new ArrayList();
            object = this.calculateChartDataDefinition(seriesDefinition.getValue(), calculator);
            this.dealFArrayInList((ArrayList)object2, (FArray)object, calculator);
            arrayList2.add(object2);
        }
        int n4 = arrayList.size();
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = arrayList.get(n2);
            if (object2 == null || !StringUtils.isNotEmpty(object2.toString())) continue;
            object = StableFactory.getMarkedInstanceObjectFromClass("BaseMapAreaValue", BaseMapAreaValue.class);
            mapChartData.addMapData(object2, object);
            int n5 = Math.min(arrayList3.size(), arrayList2.size());
            for (int i2 = 0; i2 < n5; ++i2) {
                Object e2 = arrayList3.get(i2);
                ArrayList arrayList4 = (ArrayList)arrayList2.get(i2);
                if (n2 >= arrayList4.size()) continue;
                Object e3 = arrayList4.get(n2);
                if (e2 == null || !StringUtils.isNotEmpty(e2.toString())) continue;
                Number number = Utils.objectToNumber(e3, false);
                BaseMapTitleValue baseMapTitleValue = StableFactory.getMarkedInstanceObjectFromClass("BaseMapTitleValue", BaseMapTitleValue.class);
                baseMapTitleValue.setTitle(e2.toString());
                baseMapTitleValue.setValue(number.doubleValue());
                object.addTitleValue(baseMapTitleValue);
            }
        }
    }

    private ArrayList getAreaNameWithDefinition(MapSingleLayerReportDefinition mapSingleLayerReportDefinition, Calculator calculator) {
        ArrayList arrayList = new ArrayList();
        if (mapSingleLayerReportDefinition != null) {
            FArray fArray = this.calculateChartDataDefinition(mapSingleLayerReportDefinition.getCategoryName(), calculator);
            this.dealFArrayInList(arrayList, fArray, calculator);
        }
        return arrayList;
    }

    protected static class IntegerWrapper {
        int[] values;

        public int[] getValues() {
            return this.values;
        }

        public IntegerWrapper(int[] nArray) {
            this.values = nArray;
        }
    }
}

