/*
 * Decompiled with CFR 0.152.
 */
package com.fr.chart.chartattr;

import com.fr.base.chart.chartdata.ChartData;
import com.fr.chart.base.ChartFunctionProcessor;
import com.fr.chart.base.ChartTypeValueCollection;
import com.fr.chart.base.ChartUtils;
import com.fr.chart.chartattr.Plot;
import com.fr.chart.chartdata.NormalChartData;
import com.fr.chart.chartglyph.DonutPlotGlyph;
import com.fr.general.Inter;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;

public abstract class DonutPlot
extends Plot {
    private static final long serialVersionUID = 3112525412275559985L;
    private static final double DEFAULT_INNERRADIUS_PERCENT = 0.5;
    private static final double DEFAULT_SERIES_GAP = 0.05;
    private static final double DEFAULT_CATEGORY_GAP = 0.2;
    private double innerRadiusPercent = 0.5;
    private double seriesGap = 0.05;
    private double categoryGap = 0.2;
    private static final Object[] DONUT_SERIES_NAME = new Object[]{Inter.getLocText("FR-Chart-Data_Series") + "1", Inter.getLocText("FR-Chart-Data_Series") + "2", Inter.getLocText("FR-Chart-Data_Series") + "3"};
    public static final Object[][] DONUT_VALUES = new Object[][]{{"40", "50", "30"}, {"35", "25", "15"}, {"25", "45", "55"}};
    private static final ChartData DONUT_DATA = new NormalChartData(ChartUtils.CATEGORY_STRING, DONUT_SERIES_NAME, DONUT_VALUES);

    public String getPlotName() {
        return Inter.getLocText("FR-Chart-Type_Donut");
    }

    public void setInnerRadiusPercent(double d2) {
        this.innerRadiusPercent = d2;
    }

    public double getInnerRadiusPercent() {
        return this.innerRadiusPercent;
    }

    public ChartData defaultChartData() {
        return DONUT_DATA;
    }

    public boolean matchPlotType(Plot plot) {
        return plot instanceof DonutPlot;
    }

    public void setCategoryGap(double d2) {
        this.categoryGap = d2;
    }

    public double getCategoryGap() {
        return this.categoryGap;
    }

    public void setSeriesGap(double d2) {
        this.seriesGap = d2;
    }

    public boolean isHaveAxis() {
        return false;
    }

    public boolean isSupportCate() {
        return true;
    }

    public double getSeriesGap() {
        return this.seriesGap;
    }

    public void install4PlotGlyph(DonutPlotGlyph donutPlotGlyph, ChartData chartData) {
        super.install4PlotGlyph(donutPlotGlyph, chartData);
        donutPlotGlyph.setInnerRadiusPercent(this.innerRadiusPercent);
        donutPlotGlyph.setSeriesGap(this.seriesGap);
        donutPlotGlyph.setCategoryGap(this.categoryGap);
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && "DonutAttr".equals(string = xMLableReader.getTagName())) {
            this.setInnerRadiusPercent(xMLableReader.getAttrAsDouble("innterRadiusPercent", 0.5));
            this.setSeriesGap(xMLableReader.getAttrAsDouble("seriesGap", 0.05));
            this.setCategoryGap(xMLableReader.getAttrAsDouble("categoryGap", 0.2));
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("DonutAttr").attr("innterRadiusPercent", this.innerRadiusPercent).attr("seriesGap", this.seriesGap).attr("categoryGap", this.categoryGap).end();
    }

    public boolean equals(Object object) {
        return object instanceof DonutPlot && super.equals(object) && ((DonutPlot)object).getInnerRadiusPercent() == this.getInnerRadiusPercent() && ((DonutPlot)object).getSeriesGap() == this.getSeriesGap() && ((DonutPlot)object).getCategoryGap() == this.getCategoryGap();
    }

    public String getPlotSmallIconPath() {
        return "com/fr/design/images/toolbar/donut/" + this.getDetailType();
    }

    public ChartTypeValueCollection getPlotType() {
        return ChartTypeValueCollection.DONUT;
    }

    public String getPlotID() {
        return "FineReportDonutChart";
    }

    public FunctionProcessor getFunctionToRecord() {
        return ChartFunctionProcessor.DONUT_CHART;
    }
}

