/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.MultiFieldParameter;
import com.fr.base.Parameter;
import com.fr.general.DateUtils;
import com.fr.general.FRLogger;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.stable.FormulaProvider;
import com.fr.stable.bridge.StableFactory;
import java.text.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ParameterTypeHandler {
    String{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            parameter.setValue(jSONObject.getString("value"));
            return parameter;
        }
    }
    ,
    Integer{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            parameter.setValue(java.lang.Integer.valueOf(jSONObject.getString("value")));
            return parameter;
        }
    }
    ,
    Double{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            parameter.setValue(java.lang.Double.valueOf(jSONObject.getString("value")));
            return parameter;
        }
    }
    ,
    Date{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            String string = jSONObject.getString("value");
            try {
                parameter.setValue(DateUtils.DATEFORMAT2.parse(string));
            }
            catch (ParseException parseException) {
                FRLogger.getLogger().error(parseException.getMessage(), parseException);
            }
            return parameter;
        }
    }
    ,
    Boolean{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            parameter.setValue(jSONObject.getBoolean("value"));
            return parameter;
        }
    }
    ,
    Formula{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            FormulaProvider formulaProvider = (FormulaProvider)((Object)StableFactory.createXmlObject("Formula"));
            formulaProvider.setContent(jSONObject.getString("value"));
            parameter.setValue(formulaProvider);
            return parameter;
        }
    }
    ,
    Long{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            parameter.setValue(java.lang.Long.valueOf(jSONObject.getString("value")));
            return parameter;
        }
    }
    ,
    Multi{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            return ParameterTypeHandler.processMultiPara(jSONObject, parameter);
        }
    }
    ,
    JSONArray{

        public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
            return ParameterTypeHandler.processMultiPara(jSONObject, parameter);
        }
    };


    private static Parameter processMultiPara(JSONObject jSONObject, Parameter parameter) throws JSONException {
        MultiFieldParameter multiFieldParameter = new MultiFieldParameter(parameter.getName());
        JSONArray jSONArray = jSONObject.getJSONArray("value");
        multiFieldParameter.parseValueJSON(jSONArray);
        return multiFieldParameter;
    }

    public Parameter parseJson(JSONObject jSONObject, Parameter parameter) throws JSONException {
        return parameter;
    }
}

