/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.general.ComparatorUtils;
import com.fr.general.Inter;
import com.fr.stable.StableUtils;
import com.fr.stable.unit.INCH;
import com.fr.stable.unit.MM;
import com.fr.stable.unit.UNIT;
import java.io.Serializable;
import java.util.Locale;

public class PaperSize
implements Cloneable,
Serializable {
    public static final PaperSize PAPERSIZE_9X11 = new PaperSize(new INCH(9.0f), new INCH(11.0f));
    public static final PaperSize PAPERSIZE_10X11 = new PaperSize(new INCH(10.0f), new INCH(11.0f));
    public static final PaperSize PAPERSIZE_10X14 = new PaperSize(new INCH(10.0f), new INCH(14.0f));
    public static final PaperSize PAPERSIZE_11X17 = new PaperSize(new INCH(11.0f), new INCH(17.0f));
    public static final PaperSize PAPERSIZE_15x11 = new PaperSize(new INCH(15.0f), new INCH(11.0f));
    public static final PaperSize PAPERSIZE_LETTER = new PaperSize(new INCH(8.5f), new INCH(11.0f));
    public static final PaperSize PAPERSIZE_NOTE = new PaperSize(new INCH(7.5f), new INCH(10.0f));
    public static final PaperSize PAPERSIZE_LEGAL = new PaperSize(new INCH(8.5f), new INCH(14.0f));
    public static final PaperSize PAPERSIZE_A0 = new PaperSize(new MM(841.0f), new MM(1189.0f));
    public static final PaperSize PAPERSIZE_A1 = new PaperSize(new MM(594.0f), new MM(841.0f));
    public static final PaperSize PAPERSIZE_A2 = new PaperSize(new MM(420.0f), new MM(594.0f));
    public static final PaperSize PAPERSIZE_A3 = new PaperSize(new MM(297.0f), new MM(420.0f));
    public static final PaperSize PAPERSIZE_A3_XL = new PaperSize(new MM(322.0f), new MM(445.0f));
    public static final PaperSize PAPERSIZE_A4 = new PaperSize(new MM(210.0f), new MM(297.0f));
    public static final PaperSize PAPERSIZE_A4_XL = new PaperSize(new MM(235.5f), new MM(322.3f));
    public static final PaperSize PAPERSIZE_A4_ML = new PaperSize(new MM(210.0f), new MM(330.0f));
    public static final PaperSize PAPERSIZE_A5 = new PaperSize(new MM(148.0f), new MM(210.0f));
    public static final PaperSize PAPERSIZE_A5_XL = new PaperSize(new MM(174.0f), new MM(235.0f));
    public static final PaperSize PAPERSIZE_A6 = new PaperSize(new MM(105.0f), new MM(148.0f));
    public static final PaperSize PAPERSIZE_A7 = new PaperSize(new MM(74.0f), new MM(105.0f));
    public static final PaperSize PAPERSIZE_A8 = new PaperSize(new MM(52.0f), new MM(74.0f));
    public static final PaperSize PAPERSIZE_B0 = new PaperSize(new MM(1000.0f), new MM(1414.0f));
    public static final PaperSize PAPERSIZE_B1 = new PaperSize(new MM(707.0f), new MM(1000.0f));
    public static final PaperSize PAPERSIZE_B2 = new PaperSize(new MM(500.0f), new MM(707.0f));
    public static final PaperSize PAPERSIZE_B3 = new PaperSize(new MM(353.0f), new MM(500.0f));
    public static final PaperSize PAPERSIZE_B4 = new PaperSize(new MM(250.0f), new MM(353.0f));
    public static final PaperSize PAPERSIZE_B4_JIS = new PaperSize(new MM(257.0f), new MM(364.0f));
    public static final PaperSize PAPERSIZE_B5_JIS = new PaperSize(new MM(182.0f), new MM(257.0f));
    public static final PaperSize PAPERSIZE_B6_JIS = new PaperSize(new MM(128.0f), new MM(182.0f));
    public static final PaperSize PAPERSIZE_A3_ROTATE = PAPERSIZE_A3.rotate();
    public static final PaperSize PAPERSIZE_A4_ROTATE = PAPERSIZE_A4.rotate();
    public static final PaperSize PAPERSIZE_A5_ROTATE = PAPERSIZE_A5.rotate();
    public static final PaperSize PAPERSIZE_A6_ROTATE = PAPERSIZE_A6.rotate();
    public static final PaperSize PAPERSIZE_B4_JIS_ROTATE = PAPERSIZE_B4_JIS.rotate();
    public static final PaperSize PAPERSIZE_B5_JIS_ROTATE = PAPERSIZE_B5_JIS.rotate();
    public static final PaperSize PAPERSIZE_B6_JIS_ROTATE = PAPERSIZE_B6_JIS.rotate();
    public static final PaperSize PAPERSIZE_TABLOID = new PaperSize(new INCH(11.0f), new INCH(17.0f));
    public static final PaperSize PAPERSIZE_LEDGER = new PaperSize(new INCH(17.0f), new INCH(11.0f));
    public static final PaperSize PAPERSIZE_HALFLETTER = new PaperSize(new INCH(5.5f), new INCH(8.5f));
    public static final PaperSize PAPERSIZE_EXECUTIVE = new PaperSize(new INCH(7.25f), new INCH(10.5f));
    public static final PaperSize PAPERSIZE_FOLIO = new PaperSize(new INCH(8.5f), new INCH(13.0f));
    public static final PaperSize PAPERSIZE_QUARTO = new PaperSize(new INCH(8.5f), new MM(10.83f));
    public static final int PREDEFINED = 0;
    public static final int USERDEFINED = 1;
    private UNIT width;
    private UNIT height;

    public PaperSize() {
        this(PAPERSIZE_A4.getWidth(), PAPERSIZE_A4.getHeight());
    }

    public PaperSize(UNIT uNIT, UNIT uNIT2) {
        this.setWidth(uNIT);
        this.setHeight(uNIT2);
    }

    public UNIT getWidth() {
        return this.width;
    }

    public void setWidth(UNIT uNIT) {
        this.width = uNIT;
    }

    public UNIT getHeight() {
        return this.height;
    }

    public void setHeight(UNIT uNIT) {
        this.height = uNIT;
    }

    public PaperSize rotate() {
        return new PaperSize(this.getHeight(), this.getWidth());
    }

    public boolean equals(Object object) {
        if (!(object instanceof PaperSize)) {
            return false;
        }
        PaperSize paperSize = (PaperSize)object;
        return this.toString().equals(paperSize.toString());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        Locale locale = FRContext.getLocale();
        if (ComparatorUtils.equals(Locale.CHINA, locale)) {
            return StableUtils.doubleToString(this.getWidth().toMMValue4Scale2()) + "x" + StableUtils.doubleToString(this.getHeight().toMMValue4Scale2()) + Inter.getLocText("PageSetup-mm");
        }
        return this.getWidth().toINCHValue4Scale3() + "x" + this.getHeight().toINCHValue4Scale3() + Inter.getLocText("PageSetup-inches");
    }
}

