/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.recorder;

import com.fr.general.FRLogger;
import com.fr.performance.dao.PerformanceSaverManager;
import com.fr.performance.info.IExportInfo;
import com.fr.performance.info.IReportPerformanceInfo;
import com.fr.performance.info.ISubmitInfo;
import com.fr.performance.info.ReportPerformanceInfo;
import com.fr.performance.recorder.PerformanceInfoRecorder;
import java.util.Map;

class PerformanceInfoRecorderImpl
implements PerformanceInfoRecorder {
    private IReportPerformanceInfo reportPerformanceInfo = this.createReportPerformanceInfo();
    private static final String UNKNOWN_NAME = "unknown";
    private String dsName = "unknown";

    public void setReportPerformanceInfo(IReportPerformanceInfo iReportPerformanceInfo) {
        this.reportPerformanceInfo = iReportPerformanceInfo;
    }

    private ReportPerformanceInfo createReportPerformanceInfo() {
        return ReportPerformanceInfo.newInstance();
    }

    public void setWorkBookName(String string) {
        this.reportPerformanceInfo.setWorkBookName(string);
    }

    public void recordDataModelRowCount(String string, int n) {
        this.reportPerformanceInfo.putDataModelRowCount(string, n);
    }

    public void recordDataModelColCount(String string, int n) {
        this.reportPerformanceInfo.putDataModelColCount(string, n);
    }

    public void recordSqlExecuteTime(String string, long l) {
        this.reportPerformanceInfo.putDataSourceExecuteTime(string, l);
    }

    public void recordTransferTime(String string, long l) {
        this.reportPerformanceInfo.putDataSourceTransferTime(string, l);
    }

    public void recordBuildDataTime(String string, long l) {
        this.reportPerformanceInfo.addBuildDataTime(string, l);
    }

    public void recordCellCalculateTime(String string, long l) {
        this.reportPerformanceInfo.putCellCalculateTime(string, l);
    }

    public void recordCalculateTime(long l) {
        this.reportPerformanceInfo.setCalculateTime(l);
    }

    public void addCellFilterTime(String string, long l) {
        this.reportPerformanceInfo.addCellFilterTime(string, l);
    }

    public void addCellCustomDisplayTime(String string, long l) {
        this.reportPerformanceInfo.addCellCustomDisplayTime(string, l);
    }

    public void addCellPresentTime(String string, long l) {
        this.reportPerformanceInfo.addCellPresentTime(string, l);
    }

    public void addCellHighlightTime(String string, long l) {
        this.reportPerformanceInfo.addCellHighlightTime(string, l);
    }

    public void addDynamicTime(String string, long l) {
    }

    public void addCellHyperlinkTime(String string, long l) {
        this.reportPerformanceInfo.addCellHyperlinkTime(string, l);
    }

    public void recordReportMemory(String string, long l) {
        this.reportPerformanceInfo.putReportMemory(string, l);
    }

    public void recordExportInfo(IExportInfo iExportInfo) {
        this.reportPerformanceInfo.addExportInfo(iExportInfo);
    }

    public void recordSubmitInfo(ISubmitInfo iSubmitInfo) {
        this.reportPerformanceInfo.addSubmitInfo(iSubmitInfo);
    }

    public void completeRecorder() {
        PerformanceSaverManager.saveReportPerformanceInfo(this.reportPerformanceInfo);
    }

    public void recordParameterMap(Map map) {
        String string = FRLogger.createParamString((Map)map);
        this.reportPerformanceInfo.putParameterString(string);
    }

    public void recordSQLFun(String string, long l) {
        this.reportPerformanceInfo.addSqlFunExecuteTimes(string, l);
    }

    public void recordToImageFun(String string, long l, boolean bl) {
        this.reportPerformanceInfo.addImageMemory(string, l, bl);
    }

    public void recordToImageFun(String string, long l) {
        this.reportPerformanceInfo.addImageMemory(string, l);
    }

    public void recordReportFromCache() {
        this.reportPerformanceInfo.setCalculateTime(-2L);
    }

    public void beginDataSourceRecord(String string) {
        this.dsName = string;
    }

    public void endDataSourceRecord(String string) {
        this.dsName = UNKNOWN_NAME;
    }

    public String getRecordingDsName() {
        return this.dsName;
    }

    public void recordBuildDataTime(long l) {
        this.recordBuildDataTime(this.dsName, l);
    }

    public void recordSqlExecuteTime(long l) {
        this.recordSqlExecuteTime(this.dsName, l);
    }

    public void recordTransferTime(long l) {
        this.recordTransferTime(this.dsName, l);
    }

    public void addCellDynamicParameter(String string, long l) {
        this.reportPerformanceInfo.addCellDynamicParameter(string, l);
    }

    public IReportPerformanceInfo getReportPerformanceInfo() {
        return this.reportPerformanceInfo;
    }
}

