/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.netsign.asn1.util.DerUtil;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.pkcs.Item;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;

public class SubjectPublicKeyInfo {
    private Item alg = new Item();
    private Item param = new Item();
    private Item pkn = new Item();
    private Item pke = new Item();
    private static byte[] rsaAlgByte = new byte[]{42, -122, 72, -122, -9, 13, 1, 1, 1};

    public final Item getAlg() {
        return this.alg;
    }

    public final Item getParam() {
        return this.param;
    }

    public final Item getPkn() {
        return this.pkn;
    }

    public final Item getPke() {
        return this.pke;
    }

    public PublicKey getPublicKey(byte[] input) throws CryptoException {
        if (input != null && this.pke != null && this.pkn != null) {
            byte[] n = new byte[this.pkn.length];
            byte[] e = new byte[this.pke.length];
            System.arraycopy(input, this.pkn.offset, n, 0, this.pkn.length);
            System.arraycopy(input, this.pke.offset, e, 0, this.pke.length);
            if (DerUtil.debug) {
                DerUtil.printBytes(n, 0, n.length, 16);
                DerUtil.printBytes(e, 0, e.length, 16);
            }
            try {
                if (e.length > 0 && n.length > 0) {
                    if (DerUtil.debug) {
                        System.out.println("PKE=" + new BigInteger(e) + "\nPKN=" + new BigInteger(n));
                    }
                    RSAPublicKeySpec publicSpec = new RSAPublicKeySpec(new BigInteger(n), new BigInteger(e));
                    KeyFactory keyFactory = null;
                    PublicKey publicKey = null;
                    keyFactory = KeyFactory.getInstance("RSA", "INFOSEC");
                    publicKey = keyFactory.generatePublic(publicSpec);
                    return publicKey;
                }
            }
            catch (Throwable exp) {
                throw new CryptoException("Generate Publickey error :" + exp.toString(), exp);
            }
        }
        return null;
    }

    public SubjectPublicKeyInfo() {
    }

    public SubjectPublicKeyInfo(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    private void parse(byte[] input, int offset, int length) {
        Item tmpitem;
        ArrayList al = new ArrayList();
        ArrayList aal = new ArrayList();
        DerUtil.parseSequence(input, offset, length, al);
        if (al.size() > 0) {
            tmpitem = new Item((Item)al.get(0));
            DerUtil.parseSequence(input, tmpitem.offset, tmpitem.length, aal);
            if (aal.size() > 0) {
                this.alg = new Item((Item)aal.get(0));
            }
            if (DerUtil.debug) {
                System.out.println("algorithm=" + DerUtil.toDERObjectIdentifier(input, this.alg.offset, this.alg.length));
            }
            if (aal.size() > 1) {
                this.param = new Item((Item)aal.get(1));
            }
            aal.clear();
        }
        if (al.size() > 0 && DerUtil.isEqual(input, this.alg.offset, rsaAlgByte, 0, rsaAlgByte.length)) {
            tmpitem = new Item((Item)al.get(1));
            int current_offset = 0;
            current_offset = tmpitem.offset;
            DerUtil.computeOffset(input, tmpitem, current_offset, 0);
            DerUtil.parseSequence(input, tmpitem.offset + current_offset, tmpitem.length, aal);
            if (aal.size() > 0) {
                this.pkn = new Item((Item)aal.get(0));
            }
            if (aal.size() > 1) {
                this.pke = new Item((Item)aal.get(1));
            }
            if (DerUtil.debug) {
                System.out.println("PKN=" + this.pkn + "\nPKE=" + this.pke);
            }
        }
    }
}

