/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.pkcs.Item;
import java.math.BigInteger;

public class SerialNumber {
    public static final int MAXLENGTH = 32;
    private byte[] sn = null;
    private int length;

    public SerialNumber(byte[] input, int offset, int length) {
        this.sn = new byte[length];
        this.length = length;
        if (length > 0 && offset + length < input.length) {
            System.arraycopy(input, offset, this.sn, 0, length);
        }
    }

    public SerialNumber(byte[] input, Item it) {
        this(input, it.offset, it.length);
    }

    public byte[] getSn() {
        return this.sn;
    }

    public BigInteger getSerialNumber() {
        if (this.sn != null) {
            return new BigInteger(this.sn);
        }
        return BigInteger.ZERO;
    }

    public void setSn(byte[] sn) {
        if (sn != null && sn.length > 0) {
            System.arraycopy(sn, 0, this.sn, 0, sn.length);
        }
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public SerialNumber() {
        this.sn = new byte[32];
        this.length = 0;
    }
}

