/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.netsign.asn1.util.DerUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.pkcs.EnvelopedData;
import cn.com.infosec.pkcs.FX509Certificate;
import cn.com.infosec.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.pkcs.Item;
import cn.com.infosec.pkcs.RawData;
import cn.com.infosec.pkcs.SignedAndEnvelopedData;
import cn.com.infosec.pkcs.SignedData;
import cn.com.infosec.pkcs.SignerInfo;
import java.security.PublicKey;
import java.util.ArrayList;

public class FastPkcs7 {
    private byte[] p7b;
    private int contentType = 0;
    private Item contents;
    private ArrayList certs = new ArrayList();
    private ArrayList crls = new ArrayList();
    private ArrayList daset = new ArrayList();
    private ArrayList signerInfos = new ArrayList();
    private Item signCert = new Item();
    private String digestAlgorithm = null;
    private String digestEncryptionAlgorithm = null;
    private Item digest = new Item();
    private Item data = new Item();
    private Item rawData = new Item();
    private EnvelopedData envelopedData = null;
    private SignedAndEnvelopedData signedAndEnvelopedData = null;
    private PublicKey pk = null;

    public boolean pkcs7SignedData(byte[] input, String provider) {
        Item tmpitem = new Item();
        int position = 0;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        this.contentType = DerUtil.getContentType(input, tmpitem.offset, 0);
        position = tmpitem.offset + tmpitem.length;
        DerUtil.computeOffset(input, tmpitem, 0, position);
        this.contents = new Item(tmpitem);
        switch (this.contentType) {
            case 1: {
                this.data = new Item(tmpitem);
                if (this.data.length <= 0) break;
                DerUtil.computeOffset(input, this.rawData, this.data.offset, 0);
                this.rawData.offset += this.data.offset;
                break;
            }
            case 2: {
                SignedData sd = new SignedData(input, this.contents);
                if (sd.getContentInfo().getContentType() == 1) {
                    Item cii = new Item(sd.getContentInfo().getContent());
                    RawData rd = new RawData(input, cii);
                    byte[] rdd = new byte[rd.getData().length];
                    System.arraycopy(rd.getData(), 0, rdd, 0, rdd.length);
                    this.rawData = new Item(rd.getRawData());
                }
                ArrayList tmpsi = new ArrayList();
                this.certs.addAll(sd.getCertificates());
                this.crls.addAll(sd.getCrls());
                if (this.daset.addAll(sd.getDigestAlgorithms())) {
                    if (DerUtil.debug) {
                        int i = 0;
                        while (i < this.daset.size()) {
                            DerUtil.printItemAndTag(input, (Item)this.daset.get(i));
                            System.out.println("Digest Algorithms: " + DerUtil.toDERObjectIdentifier(input, ((Item)this.daset.get((int)i)).offset, ((Item)this.daset.get((int)i)).length));
                            ++i;
                        }
                    }
                    this.digestAlgorithm = DerUtil.toDERObjectIdentifier(input, ((Item)this.daset.get((int)0)).offset, ((Item)this.daset.get((int)0)).length);
                }
                if (!tmpsi.addAll(sd.getSignerInfos())) break;
                int i = 0;
                while (i < tmpsi.size()) {
                    SignerInfo si = new SignerInfo(input, (Item)tmpsi.get(i));
                    this.signerInfos.add(si);
                    if (DerUtil.debug) {
                        this.printSignerInfo(input, si);
                    }
                    IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(input, si.getIssuerAndSerialNumber());
                    Item issuerItem = new Item(iasn.getIssuer());
                    int index = 0;
                    while (index < this.certs.size()) {
                        FX509Certificate fx = new FX509Certificate(input, (Item)this.certs.get(index));
                        if (DerUtil.isEqual(input, issuerItem.offset, input, fx.getIssuer().offset, issuerItem.length) && DerUtil.isEqual(input, fx.getSerialNumber().offset, iasn.getSerialNumber().getSn(), 0, fx.getSerialNumber().length)) {
                            this.signCert = new Item((Item)this.certs.get(index));
                            this.digestAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestAlgorithm().offset, si.getDigestAlgorithm().length);
                            this.digestEncryptionAlgorithm = DerUtil.toDERObjectIdentifier(input, si.getDigestEncryptionAlgorithm().offset, si.getDigestEncryptionAlgorithm().length);
                            this.digest = new Item(si.getEncryptedDigest());
                        }
                        ++index;
                    }
                    ++i;
                }
                tmpsi.clear();
                break;
            }
            case 3: {
                this.envelopedData = new EnvelopedData(input, this.contents);
                if (!DerUtil.debug) break;
                System.out.println("Version is " + this.envelopedData.getVer());
                DerUtil.printItem(input, this.envelopedData.getEncryptedContentInfo());
                break;
            }
            case 4: {
                this.signedAndEnvelopedData = new SignedAndEnvelopedData(input, this.contents);
                break;
            }
        }
        return true;
    }

    public final EnvelopedData getEnvelopedData() {
        return this.envelopedData;
    }

    public final ArrayList getCerts() {
        return this.certs;
    }

    public final ArrayList getCrls() {
        return this.crls;
    }

    public final Item getSignCert() {
        return this.signCert;
    }

    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final String getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public final Item getDigest() {
        return this.digest;
    }

    public final Item getRawData() {
        return this.rawData;
    }

    public byte[] getPkcs7(byte[] p7) {
        if (p7[0] == 48) {
            return p7;
        }
        return Base64.decode(p7);
    }

    public int getContentType() {
        return this.contentType;
    }

    public void printSignerInfo(byte[] input, SignerInfo si) {
        System.out.println("getAaSequence:");
        DerUtil.printItem(input, si.getAaSequence());
        System.out.println("getAuthenticatedAttributes:");
        DerUtil.printItem(input, si.getAuthenticatedAttributes());
        System.out.println("getDigestAlgorithm: " + DerUtil.toDERObjectIdentifier(input, si.getDigestAlgorithm().offset, si.getDigestAlgorithm().length));
        DerUtil.printItem(input, si.getDigestAlgorithm());
        System.out.println("getDigestEncryptionAlgorithm: " + DerUtil.toDERObjectIdentifier(input, si.getDigestEncryptionAlgorithm().offset, si.getDigestEncryptionAlgorithm().length));
        DerUtil.printItem(input, si.getDigestEncryptionAlgorithm());
        System.out.println("getIssuerAndSerialNumber:");
        DerUtil.printItem(input, si.getIssuerAndSerialNumber());
        IssuerAndSerialNumber iasn = new IssuerAndSerialNumber(input, si.getIssuerAndSerialNumber());
        System.out.println("SN=" + iasn.getSerialNumber().getSerialNumber());
        System.out.println("getUnauthenticatedAttributes:");
        DerUtil.printItem(input, si.getUnauthenticatedAttributes());
    }
}

