/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.netsign.asn1.util.DerUtil;
import cn.com.infosec.pkcs.Item;
import java.io.FileInputStream;
import java.util.Vector;

public class FX509CRL {
    private Item nTBSCertList;
    private Item signatureAlgorithm;
    private Item signatureValue;
    private Item version;
    private Item signature;
    private Item issuer;
    private Item thisUpdate;
    private Item nextUpdate;
    private Item revokedCertificates = new Item();
    private Item crlExtensions = new Item();
    private Vector vsn = new Vector(0);

    public FX509CRL() {
    }

    public FX509CRL(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public void parse(byte[] input, int offset, int length) {
        int position = 0;
        Item tmpitem = new Item();
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        tmpitem.offset += offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        this.nTBSCertList = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.signatureAlgorithm = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        tmpitem.offset += offset;
        this.signatureValue = new Item(tmpitem);
        position = this.nTBSCertList.offset - offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        this.version = new Item(tmpitem);
        this.version.offset += offset;
        position = tmpitem.offset + tmpitem.length;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.signature = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("signature:");
            DerUtil.printItem(input, this.signature);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.issuer = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("issuer:");
            DerUtil.printItem(input, this.issuer);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.thisUpdate = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("thisUpdate:");
            DerUtil.printItem(input, this.thisUpdate);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.nextUpdate = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("nextUpdate:");
            DerUtil.printItem(input, this.nextUpdate);
        }
        if (position < length && (input[position] & 0xFF) != 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.revokedCertificates = new Item(tmpitem);
            if (DerUtil.debug) {
                System.out.println("revokedCertificates:");
            }
            this.fetchSN(input, this.revokedCertificates.offset, this.revokedCertificates.length, this.vsn);
        }
        if (position < length && (input[position] & 0xFF) == 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            tmpitem.offset += offset;
            this.crlExtensions = new Item(tmpitem);
            if (DerUtil.debug) {
                System.out.println("crlExtensions:");
                DerUtil.printItem(input, this.crlExtensions);
            }
        }
    }

    private void fetchSN(byte[] input, int offset, int length, Vector vsn) {
        Item tmpitem = new Item();
        Item snitem = new Item();
        int position = 0;
        while (position < length - 2) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            DerUtil.computeOffset(input, snitem, offset, tmpitem.offset);
            position = tmpitem.offset + tmpitem.length;
            snitem.offset += offset;
            if (DerUtil.debug) {
                DerUtil.printItem(input, snitem);
            }
            vsn.add(snitem);
        }
    }

    public final Item getIssuer() {
        return this.issuer;
    }

    public final Item getThisUpdate() {
        return this.thisUpdate;
    }

    public final Item getNextUpdate() {
        return this.nextUpdate;
    }

    public final Vector getRevokedCertificateSNs() {
        return this.vsn;
    }

    public final Item getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public final Item getSignatureValue() {
        return this.signatureValue;
    }

    static byte[] readCRL(String filename) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filename);
            int size = fis.available();
            byte[] crl = new byte[size];
            fis.read(crl);
            fis.close();
            byte[] byArray = crl;
            return byArray;
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void main(String[] args) throws Exception {
        FX509CRL fcp = new FX509CRL();
        int i = 0;
        while (i < args.length) {
            System.out.println(args[i]);
            ++i;
        }
        byte[] crl = FX509CRL.readCRL("D:/wangzongbin/PKITS_data/crls/BasicSelfIssuedOldKeySelfIssuedCertCRL.crl");
        System.out.println("\nFast:\n");
        fcp.parse(crl, 0, crl.length);
        Vector vrcsn = fcp.getRevokedCertificateSNs();
        int i2 = 0;
        while (i2 < vrcsn.size()) {
            System.out.print("SN[" + (i2 + 1) + "]=");
            Item snitem = new Item((Item)vrcsn.get(i2));
            DerUtil.printItem(crl, snitem);
            ++i2;
        }
    }
}

