/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.netsign.asn1.util.DerUtil;
import cn.com.infosec.pkcs.EncryptedContentInfo;
import cn.com.infosec.pkcs.Item;
import cn.com.infosec.pkcs.RecipientInfo;
import java.util.ArrayList;

public class EnvelopedData {
    private Item version = new Item();
    private Item recipientInfos = new Item();
    private Item encryptedContentInfo = new Item();
    private ArrayList vRecipientInfo = new ArrayList(1);
    private EncryptedContentInfo oEncryptedContentInfo = new EncryptedContentInfo();

    public EnvelopedData() {
    }

    public EnvelopedData(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public void parse(byte[] input, int offset, int length) {
        int position = 0;
        if (DerUtil.debug) {
            DerUtil.printBytes(input, offset, length, 16);
        }
        Item tmpitem = new Item();
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.version = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.recipientInfos = new Item(tmpitem);
        DerUtil.computeOffset(input, tmpitem, offset, position);
        tmpitem.offset += offset;
        this.encryptedContentInfo = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("Version is (" + this.version.offset + "," + this.version.length + ")\nRecipientInfos is (" + this.recipientInfos.offset + "," + this.recipientInfos.length + ")\nencryptedContentInfo is (" + this.encryptedContentInfo.offset + "," + this.encryptedContentInfo.length + ")");
        }
        this.oEncryptedContentInfo.parse(input, this.encryptedContentInfo.offset, this.encryptedContentInfo.length);
        position = 0;
        while (position < this.recipientInfos.length) {
            DerUtil.computeOffset(input, tmpitem, this.recipientInfos.offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += this.recipientInfos.offset;
            RecipientInfo ri = new RecipientInfo();
            ri.parse(input, tmpitem.offset, tmpitem.length);
            if (DerUtil.debug) {
                DerUtil.printItem(input, tmpitem);
            }
            this.vRecipientInfo.add(ri);
        }
    }

    public final Item getVer() {
        return this.version;
    }

    public final Item getRecipientInfos() {
        return this.recipientInfos;
    }

    public final Item getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public final ArrayList getVRecipientInfo() {
        return this.vRecipientInfo;
    }

    public final EncryptedContentInfo getEncryptedContentInfoObject() {
        return this.oEncryptedContentInfo;
    }
}

