/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.netsign.asn1.util.DerUtil;
import cn.com.infosec.pkcs.DigestedData;
import cn.com.infosec.pkcs.EncryptedData;
import cn.com.infosec.pkcs.EnvelopedData;
import cn.com.infosec.pkcs.Item;
import cn.com.infosec.pkcs.RawData;
import cn.com.infosec.pkcs.SignedAndEnvelopedData;
import cn.com.infosec.pkcs.SignedData;

public class ContentInfo {
    private int contentType = 0;
    private Item content = new Item();

    public ContentInfo(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public ContentInfo(byte[] input, int offset, int length) {
        this.parse(input, offset, length);
    }

    public void parse(byte[] input, int offset, int length) {
        int position = 0;
        Item tmpitem = new Item();
        if (DerUtil.debug) {
            System.out.println("Entering ContentInfo parsing @ (" + offset + "," + length + ")");
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        this.contentType = DerUtil.getContentType(input, position + offset);
        if (DerUtil.debug) {
            System.out.println("ContentType=" + this.contentType);
        }
        if ((position += tmpitem.length) >= length || position + offset > input.length - 1 || (input[position + offset] & 0xA0) != 160) {
            if (DerUtil.debug) {
                System.out.println("No Explicit !\nposition=" + position + ",offset=" + offset + ",length=" + length);
            }
            return;
        }
        if (DerUtil.debug) {
            System.out.println("position=" + position + ",offset=" + offset + ",length=" + length);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        tmpitem.offset += offset;
        this.content = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("Content is " + this.content);
        }
    }

    public final int getContentType() {
        return this.contentType;
    }

    public final Item getContent() {
        return this.content;
    }

    public Object getParsedContentInfo(byte[] input) {
        if (DerUtil.debug) {
            System.out.println("Content @ " + this.content);
        }
        switch (this.contentType) {
            case 1: {
                return new RawData(input, this.content);
            }
            case 2: {
                return new SignedData(input, this.content);
            }
            case 3: {
                return new EnvelopedData(input, this.content);
            }
            case 4: {
                return new SignedAndEnvelopedData(input, this.content);
            }
            case 5: {
                return new DigestedData(input, this.content);
            }
            case 6: {
                return new EncryptedData(input, this.content);
            }
        }
        return null;
    }
}

