/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.der.util.CRLGenerater;
import cn.com.infosec.netsign.der.util.CRLParameters;
import cn.com.infosec.netsign.der.util.RevokedCertificate;
import cn.com.infosec.oscca.SDFJNI;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class MakeEccCRL {
    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        CryptoUtil.debug = true;
        SDFJNI.connectDev();
        SDFJNI.openSession();
        MakeEccCRL.makeCRL();
    }

    private static void makeCRL() throws Exception {
        System.out.println("Generate SM2 crl");
        CRLParameters cp = new CRLParameters();
        cp.setSignatureAlgOid("1.2.156.197.1.501");
        System.out.print("Issuer dn:");
        byte[] readed = new byte[100];
        System.in.read(readed);
        String str = new String(readed).trim();
        cp.setIssuer(str);
        cp.setThisUpdate(new Date());
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        System.out.print("Next update(yyyyMMddHHmmss):");
        readed = new byte[100];
        System.in.read(readed);
        str = new String(readed).trim();
        Date nextUpdate = format.parse(str);
        cp.setNextUpdate(nextUpdate);
        ArrayList<RevokedCertificate> rl = new ArrayList<RevokedCertificate>();
        while (true) {
            System.out.print("Serialnumber of revoked certificate(radix 16):");
            readed = new byte[100];
            System.in.read(readed);
            str = new String(readed).trim();
            if (str == null || str.equals("")) break;
            RevokedCertificate rc = new RevokedCertificate();
            rc.setRevokedSerialNumber(new BigInteger(str, 16));
            rc.setRevokedTime(new Date());
            rl.add(rc);
        }
        cp.setRevokedCertificates(rl);
        CRLGenerater cg = new CRLGenerater(cp);
        byte[] tbs = cg.generateTBSCRL();
        System.out.print("Sign key index:");
        readed = new byte[100];
        System.in.read(readed);
        str = new String(readed).trim();
        int keyIndex = Integer.parseInt(str);
        System.out.print("Sign key password:");
        readed = new byte[100];
        System.in.read(readed);
        str = new String(readed).trim();
        byte[] signed = SDFJNI.SM2SignWithInnerKey(tbs, "SM3", keyIndex, str, null, null);
        cg.setSignature(signed);
        byte[] crl = cg.generateCRL();
        CryptoUtil.debug("CRL content", crl);
        FileOutputStream out = new FileOutputStream("1.crl");
        out.write(crl);
        out.flush();
        out.close();
        System.out.println("CRL generated.");
    }
}

