/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.SignedData;
import cn.com.infosec.asn1.pkcs.SignerInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.CertificateList;
import cn.com.infosec.asn1.x509.X509CertificateStructure;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.provider.X509CRLObject;
import cn.com.infosec.jce.provider.X509CertificateObject;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.pkcs.FX509Certificate;
import cn.com.infosec.pkcs.FastPkcs7;
import cn.com.infosec.pkcs.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    public static final String UNSTANDARD_PKCS7_PBCSHLOCALCLEARING = "PBC Shanghai local clearing";
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private DERObject[] certsEncoded;
    private Hashtable isAndsns;
    private X509Certificate signCert;
    private byte[] digest;
    private String digestAlgorithmName;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private transient PrivateKey privKey;
    private byte[] signCertTBS;
    private byte[] contentData;
    private final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";
    private final String SIGNWITH = "withRSA";
    private byte[] pucid;
    private boolean usingQ7 = false;

    public PKCS7SignedData(byte[] in) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(in, "INFOSEC");
    }

    public void PKCS7SignedData1(byte[] in, String provider) throws SecurityException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Enumeration ec;
        DERObject pkcs;
        DERInputStream din = new DERInputStream((InputStream)new ByteArrayInputStream(in));
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance((Object)pkcs);
        if (!content.getContentType().equals((Object)signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance((Object)content.getContent());
        this.certs = new ArrayList();
        if (data.getCertificates() != null) {
            ec = ASN1Set.getInstance((Object)data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                try {
                    this.certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(ec.nextElement())));
                }
                catch (Exception e) {
                    throw new SecurityException("Parse Certificate Exception:" + e.toString());
                }
            }
        }
        this.crls = new ArrayList();
        if (data.getCRLs() != null) {
            ec = ASN1Set.getInstance((Object)data.getCRLs()).getObjects();
            while (ec.hasMoreElements()) {
                try {
                    this.crls.add(new X509CRLObject(CertificateList.getInstance(ec.nextElement())));
                }
                catch (Exception e) {
                    throw new SecurityException("Parse Certificate Exception:" + e.toString());
                }
            }
        }
        this.version = data.getVersion().getValue().intValue();
        ContentInfo dataContentInfo = data.getContentInfo();
        DEREncodable derEnc = dataContentInfo.getContent();
        if (derEnc != null) {
            ASN1OctetString asn1octet = (ASN1OctetString)derEnc;
            this.contentData = asn1octet.getOctets();
        } else {
            this.contentData = null;
        }
        this.digestalgos = new HashSet();
        Enumeration e = data.getDigestAlgorithms().getObjects();
        while (e.hasMoreElements()) {
            DERConstructedSequence s = (DERConstructedSequence)e.nextElement();
            DERObjectIdentifier o = (DERObjectIdentifier)s.getObjectAt(0);
            this.digestalgos.add(o.getId());
        }
        DERConstructedSet signerinfos = (DERConstructedSet)data.getSignerInfos();
        if (signerinfos.getSize() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance((Object)signerinfos.getObjectAt(0));
        this.signerversion = signerInfo.getVersion().getValue().intValue();
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        Iterator i = this.certs.iterator();
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            if (!serialNumber.equals(cert.getSerialNumber()) || !issuer.equals((Object)cert.getIssuerDN())) continue;
            this.signCert = cert;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + serialNumber.toString(16));
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByOId(this.digestAlgorithm);
        if (digestam == null) {
            throw new SecurityException("The DigestAlgorithm " + this.digestAlgorithm + " can not be supported by software");
        }
        this.digest = signerInfo.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        String signwithwhat = String.valueOf(digestam.getName()) + "withRSA";
        this.sig = Signature.getInstance(signwithwhat, provider);
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PKCS7SignedData(byte[] in, String provider) throws SecurityException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        CryptoUtil.debug("signed message:", in);
        FastPkcs7 fp7 = new FastPkcs7();
        if (!fp7.pkcs7SignedData(in, "INFOSEC")) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        try {
            Item item = fp7.getSignCert();
            byte[] bs = new byte[item.length];
            System.arraycopy(in, item.offset, bs, 0, item.length);
            this.signCertTBS = FX509Certificate.getTbsCertificate(bs);
            ByteArrayInputStream stream = new ByteArrayInputStream(bs);
            this.certs = new ArrayList();
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            this.signCert = (X509Certificate)cf.generateCertificate(stream);
            CryptoUtil.debug("cert tbs:", this.signCert.getTBSCertificate());
            CryptoUtil.debug("Signcert:" + this.signCert.getSubjectDN().getName());
            this.certs = new ArrayList();
            this.certs.add(this.signCert);
        }
        catch (Exception e) {
            SecurityException se = new SecurityException("Construct SignCert error :" + e.toString());
            se.setStackTrace(e.getStackTrace());
            throw se;
        }
        this.digestAlgorithm = fp7.getDigestAlgorithm();
        CryptoUtil.debug(this.digestAlgorithm);
        String da_name = AlgorithmUtil.getDigestAlgByOId(this.digestAlgorithm).getName();
        this.digestEncryptionAlgorithm = fp7.getDigestEncryptionAlgorithm();
        this.crls = new ArrayList();
        Item item = fp7.getRawData();
        if (item != null) {
            this.contentData = new byte[item.length];
            System.arraycopy(in, item.offset, this.contentData, 0, this.contentData.length);
        }
        item = fp7.getDigest();
        this.digest = new byte[item.length];
        System.arraycopy(in, item.offset, this.digest, 0, this.digest.length);
        CryptoUtil.debug(String.valueOf(da_name) + "withRSA");
        this.sig = Signature.getInstance(String.valueOf(da_name) + "withRSA", provider);
        this.sig.initVerify(this.signCert.getPublicKey());
    }

    public PKCS7SignedData(PrivateKey privKey, Certificate[] certChain, DERObject[] certChainEncoded, Hashtable isAndsns, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, certChainEncoded, isAndsns, null, hashAlgorithm, provider);
    }

    public PKCS7SignedData(PrivateKey privKey, Certificate[] certChain, DERObject[] certChainEncoded, Hashtable isAndsns, CRL[] crlList, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.privKey = privKey;
        DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName(hashAlgorithm);
        if (digestam == null) {
            throw new SecurityException("The DigestAlgorithm " + hashAlgorithm + " can not be supported by software");
        }
        this.digestAlgorithm = digestam.getOId();
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        int i = 0;
        while (i < certChain.length) {
            this.certs.add(certChain[i]);
            ++i;
        }
        this.certsEncoded = certChainEncoded;
        this.isAndsns = isAndsns;
        if (crlList != null) {
            i = 0;
            while (i < crlList.length) {
                this.crls.add(crlList[i]);
                ++i;
            }
        }
        this.digestEncryptionAlgorithm = privKey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        String signwithwhat = String.valueOf(digestam.getName()) + "withRSA";
        this.sig = Signature.getInstance(signwithwhat, provider);
        this.sig.initSign(privKey);
    }

    public PKCS7SignedData(SM2PrivateKey privkey, String digestAlg, SM2Certificate cert, DERObject[] certChainEncoded, Hashtable isAndsns, byte[] id) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.digestAlgorithmName = digestAlg;
        DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName(this.digestAlgorithmName);
        if (digestam == null) {
            throw new SecurityException("The DigestAlgorithm " + this.digestAlgorithmName + " can not be supported");
        }
        this.digestalgos = new HashSet();
        this.digestAlgorithm = digestam.getOId();
        this.digestalgos.add(this.digestAlgorithm);
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.signCert = cert;
        this.certs.add(cert);
        this.certsEncoded = certChainEncoded;
        this.digestEncryptionAlgorithm = "1.2.156.10197.1.301.1";
        this.isAndsns = isAndsns;
        this.pucid = id;
        this.privKey = privkey;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[0]);
    }

    public byte[] getSignCertTBS() {
        return this.signCertTBS;
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public void update(byte[] buf) throws SignatureException {
        if (this.sig == null) {
            byte[] contentData = new byte[buf.length];
            System.arraycopy(buf, 0, contentData, 0, buf.length);
        } else {
            this.sig.update(buf);
        }
    }

    public void update(byte[] buf, int off, int len) throws SignatureException {
        if (this.sig != null) {
            this.sig.update(buf, off, len);
        } else {
            this.contentData = new byte[len];
            System.arraycopy(buf, off, this.contentData, 0, len);
        }
    }

    public boolean verify() throws SignatureException {
        throw new NoSuchMethodError("Support verify no more, see cn.com.infosec.netsign.base.util.PKCS7SignedDataFX");
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream((InputStream)new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    private byte[] getEncoded() {
        return this.getEncoded(null);
    }

    public byte[] getEncoded(byte[] _contentData, String standard) {
        if (UNSTANDARD_PKCS7_PBCSHLOCALCLEARING.equals(standard)) {
            return this.getPBCSHLCEncoded(_contentData);
        }
        return this.getEncoded(_contentData);
    }

    private byte[] getPBCSHLCEncoded(byte[] _contentData) {
        try {
            if (this.digest == null) {
                this.digest = this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.301") ? SDFJNI.SM2SignWithExternalKey(this.contentData, this.digestAlgorithmName, ((SM2PrivateKey)this.privKey).getD(), ((SM2Certificate)this.signCert).getSM2PublicKey(), this.pucid) : this.sig.sign();
            }
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject((DEREncodable)a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject((DEREncodable)new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1"));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, (DEREncodable)octets);
                contentinfo.addObject((DEREncodable)tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            int i2 = 0;
            int length = this.certsEncoded.length;
            while (i2 < length) {
                dercertificates.addObject((DEREncodable)this.certsEncoded[i2]);
                ++i2;
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject((DEREncodable)new DERInteger(this.signerversion));
            IssuerAndSerialNumber isAnds = (IssuerAndSerialNumber)this.isAndsns.get(String.valueOf(this.signCert.getIssuerDN().getName()) + this.signCert.getSerialNumber().toString(10));
            signerinfo.addObject((DEREncodable)isAnds);
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            if (this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.301")) {
                signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier("1.2.156.10197.1.501"), null));
                signerinfo.addObject((DEREncodable)DERConstructedSequence.fromByteArray((byte[])this.digest));
            } else {
                signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
                signerinfo.addObject((DEREncodable)new DEROctetString(this.digest));
            }
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject((DEREncodable)new DERInteger(this.version));
            body.addObject((DEREncodable)algos);
            body.addObject((DEREncodable)contentinfo);
            body.addObject((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)dercertificates));
            if (this.crls != null && this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream((InputStream)new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject((DEREncodable)t.readObject());
                }
                body.addObject((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject((DEREncodable)signerinfo);
            body.addObject((DEREncodable)signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject((DEREncodable)new DERObjectIdentifier("1.2.156.10197.6.1.4.2.2"));
            whole.addObject((DEREncodable)new DERTaggedObject(0, (DEREncodable)body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream((OutputStream)bOut);
            dout.writeObject((Object)whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Throwable e) {
            RuntimeException re = new RuntimeException("Encode p7 error :" + e.toString());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    private byte[] getEncoded(byte[] _contentData) {
        try {
            if (this.digest == null) {
                this.digest = this.digestEncryptionAlgorithm.startsWith("1.2.156.197.1.301") || this.digestEncryptionAlgorithm.startsWith("1.2.156.10197.1.301") ? SDFJNI.SM2SignWithExternalKey(this.contentData, this.digestAlgorithmName, ((SM2PrivateKey)this.privKey).getD(), ((SM2Certificate)this.signCert).getSM2PublicKey(), this.pucid) : this.sig.sign();
            }
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject((DEREncodable)a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            if (!this.usingQ7) {
                contentinfo.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            } else {
                contentinfo.addObject((DEREncodable)new DERObjectIdentifier("1.2.156.10197.6.1.4.2.1"));
            }
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, (DEREncodable)octets);
                contentinfo.addObject((DEREncodable)tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            int i2 = 0;
            int length = this.certsEncoded.length;
            while (i2 < length) {
                dercertificates.addObject((DEREncodable)this.certsEncoded[i2]);
                ++i2;
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject((DEREncodable)new DERInteger(this.signerversion));
            IssuerAndSerialNumber isAnds = (IssuerAndSerialNumber)this.isAndsns.get(String.valueOf(this.signCert.getIssuerDN().getName()) + this.signCert.getSerialNumber().toString(10));
            signerinfo.addObject((DEREncodable)isAnds);
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject((DEREncodable)new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject((DEREncodable)new DERInteger(this.version));
            body.addObject((DEREncodable)algos);
            body.addObject((DEREncodable)contentinfo);
            body.addObject((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)dercertificates));
            if (this.crls != null && this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream((InputStream)new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject((DEREncodable)t.readObject());
                }
                body.addObject((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject((DEREncodable)signerinfo);
            body.addObject((DEREncodable)signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            if (!this.usingQ7) {
                whole.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            } else {
                whole.addObject((DEREncodable)new DERObjectIdentifier("1.2.156.10197.6.1.4.2.2"));
            }
            whole.addObject((DEREncodable)new DERTaggedObject(0, (DEREncodable)body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream((OutputStream)bOut);
            dout.writeObject((Object)whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Throwable e) {
            RuntimeException re = new RuntimeException("Encode p7 error :" + e.toString());
            re.setStackTrace(e.getStackTrace());
            throw re;
        }
    }

    public void setUsingQ7(boolean usingQ7) {
        this.usingQ7 = usingQ7;
    }

    public static void main(String[] args) throws Exception {
    }
}

