/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.SignedData;
import cn.com.infosec.asn1.pkcs.SignerInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.CertificateList;
import cn.com.infosec.asn1.x509.X509CertificateStructure;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.provider.X509CRLObject;
import cn.com.infosec.jce.provider.X509CertificateObject;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.HardCryptoImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PKCS7HardSignedData
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private Collection crls;
    private X509Certificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private int signatureHardAlg;
    private byte[] privKey;
    private byte[] contentData;
    private final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private final String ID_MD5 = "1.2.840.113549.2.5";
    private final String ID_MD2 = "1.2.840.113549.2.2";
    private final String ID_SHA1 = "1.3.14.3.2.26";
    private final String ID_RSA = "1.2.840.113549.1.1.1";
    private final String ID_DSA = "1.2.840.10040.4.1";
    private static HardCryptoImpl handler = null;
    private static String digestAlg;
    private byte[] sourceData;

    public static void SetCryptoHandler(HardCryptoImpl handler1) {
        handler = handler1;
    }

    public PKCS7HardSignedData(byte[] in) throws SecurityException {
        this(in, "INFOSEC");
    }

    public PKCS7HardSignedData(byte[] in, String provider) throws SecurityException {
        Enumeration ec;
        DERObject pkcs;
        DERInputStream din = new DERInputStream((InputStream)new ByteArrayInputStream(in));
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance((Object)pkcs);
        if (!content.getContentType().equals((Object)signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance((Object)content.getContent());
        this.certs = new ArrayList();
        if (data.getCertificates() != null) {
            ec = ASN1Set.getInstance((Object)data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                try {
                    this.certs.add(new X509CertificateObject(X509CertificateStructure.getInstance(ec.nextElement())));
                }
                catch (Exception e) {
                    throw new SecurityException("Parse Certiricate Exception:" + e.toString());
                }
            }
        }
        this.crls = new ArrayList();
        if (data.getCRLs() != null) {
            ec = ASN1Set.getInstance((Object)data.getCRLs()).getObjects();
            while (ec.hasMoreElements()) {
                try {
                    this.crls.add(new X509CRLObject(CertificateList.getInstance(ec.nextElement())));
                }
                catch (Exception e) {
                    throw new SecurityException("Get Certificate Exception:" + e.toString());
                }
            }
        }
        this.version = data.getVersion().getValue().intValue();
        ContentInfo dataContentInfo = data.getContentInfo();
        DEREncodable derEnc = dataContentInfo.getContent();
        if (derEnc != null) {
            ASN1OctetString asn1octet = (ASN1OctetString)derEnc;
            this.contentData = asn1octet.getOctets();
        } else {
            this.contentData = null;
        }
        this.digestalgos = new HashSet();
        Enumeration e = data.getDigestAlgorithms().getObjects();
        while (e.hasMoreElements()) {
            DERConstructedSequence s = (DERConstructedSequence)e.nextElement();
            DERObjectIdentifier o = (DERObjectIdentifier)s.getObjectAt(0);
            this.digestalgos.add(o.getId());
        }
        DERConstructedSet signerinfos = (DERConstructedSet)data.getSignerInfos();
        if (signerinfos.getSize() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance((Object)signerinfos.getObjectAt(0));
        this.signerversion = signerInfo.getVersion().getValue().intValue();
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        Iterator i = this.certs.iterator();
        while (i.hasNext()) {
            X509Certificate cert = (X509Certificate)i.next();
            if (!serialNumber.equals(cert.getSerialNumber()) || !issuer.equals((Object)cert.getIssuerDN())) continue;
            this.signCert = cert;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with serial " + serialNumber.toString(16));
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByOId(this.digestAlgorithm);
        if (digestam == null) {
            throw new SecurityException("The DigestAlgorithm " + this.digestAlgorithm + " can not be supported by hardware");
        }
        digestAlg = digestam.getName();
        this.signatureHardAlg = digestam.getValue();
        this.digest = signerInfo.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
    }

    public String getDigAlg() {
        return digestAlg;
    }

    public PKCS7HardSignedData(byte[] privKeyname, Certificate[] certChain, String hashAlgorithm, String cryptoAlgorithm) throws NoSuchAlgorithmException {
        this(privKeyname, certChain, null, hashAlgorithm, cryptoAlgorithm);
    }

    public PKCS7HardSignedData(byte[] privKeyname, Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String cryptoAlgorithm) throws NoSuchAlgorithmException {
        this.privKey = privKeyname;
        DigestAlgorithm digathm = AlgorithmUtil.getDigestAlgByName(hashAlgorithm.toUpperCase());
        if (digathm == null) {
            throw new SecurityException("The DigestAlgorithm " + hashAlgorithm + " can not be supported by hardware");
        }
        this.digestAlgorithm = digathm.getOId();
        this.signatureHardAlg = digathm.getValue();
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        int i = 0;
        while (i < certChain.length) {
            this.certs.add(certChain[i]);
            ++i;
        }
        if (crlList != null) {
            i = 0;
            while (i < crlList.length) {
                this.crls.add(crlList[i]);
                ++i;
            }
        }
        this.digestEncryptionAlgorithm = cryptoAlgorithm;
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.113549.1.1.1";
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = "1.2.840.10040.4.1";
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
    }

    public String getDigestAlgorithm() {
        String da = this.digestAlgorithm;
        String dea = this.digestEncryptionAlgorithm;
        da = AlgorithmUtil.getDigestAlgByOId(this.digestAlgorithm).getName();
        if (this.digestEncryptionAlgorithm.equals("1.2.840.113549.1.1.1")) {
            dea = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals("1.2.840.10040.4.1")) {
            dea = "DSA";
        }
        return String.valueOf(da) + "with" + dea;
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[0]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public void updateContent(byte[] buf) {
        this.contentData = buf;
    }

    public void update(byte[] buf) {
        this.sourceData = buf;
    }

    public boolean verify(byte[] Enchash) throws CryptoException {
        byte[] hash = handler.DecryptHash(Enchash, this.getCertificates()[0].getPublicKey());
        return Arrays.equals(hash, this.digest);
    }

    public boolean verify() throws CryptoException {
        return handler.verify(this.getCertificates()[0].getPublicKey(), this.contentData, this.digest, this.signatureHardAlg);
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream((InputStream)new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded() throws CryptoException {
        return this.getEncoded(null);
    }

    public byte[] getEncoded(byte[] _contentData) throws CryptoException {
        try {
            this.digest = handler.SignWithAlg(this.privKey, this.sourceData, this.signatureHardAlg);
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject((DEREncodable)a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, (DEREncodable)octets);
                contentinfo.addObject((DEREncodable)tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream((InputStream)new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject((DEREncodable)tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject((DEREncodable)new DERInteger(this.signerversion));
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name((ASN1Sequence)((DERConstructedSequence)this.getIssuer(this.signCert.getTBSCertificate()))), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject((DEREncodable)isAnds);
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject((DEREncodable)new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject((DEREncodable)new DERInteger(this.version));
            body.addObject((DEREncodable)algos);
            body.addObject((DEREncodable)contentinfo);
            body.addObject((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream((InputStream)new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject((DEREncodable)t.readObject());
                }
                body.addObject((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject((DEREncodable)signerinfo);
            body.addObject((DEREncodable)signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject((DEREncodable)new DERTaggedObject(0, (DEREncodable)body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream((OutputStream)bOut);
            dout.writeObject((Object)whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }
}

