/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.netsign.crypto.algorithm.SymmetricalAlgorithm;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.HardCryptoImpl;
import cn.com.infosec.netsign.crypto.util.PKCS7EnvelopedDataUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.crypto.SecretKey;

public class PKCS7HardEnvelopedData
implements PKCSObjectIdentifiers {
    public static SecretKey key;
    public static final int TRIPLE_DES_CBC = 1;
    public static final int DES_CBC = 2;
    public static final int RC2_CBC = 3;
    public static final int RC4 = 4;
    public static final int IV_LENGTH = 8;
    private static final String OID_ENVELOPEDDATATYPE = "1.2.840.113549.1.7.3";
    private static final String OID_ENCRYPTCONTENT = "1.2.840.113549.1.7.1";
    private static final String OID_RSA_ECB_PKCS1PADDING = "1.2.840.113549.1.1.1";
    private String encAlg;

    public String getEncAlg() {
        return this.encAlg;
    }

    public byte[] decrypt(byte[] prilabel, byte[] envelopeddata, Certificate cert, HardCryptoImpl hardcryptoimpl) throws SecurityException, CertificateNotMatchException, CryptoException, NoSuchAlgorithmException {
        DERObject pkcs;
        ByteArrayInputStream bais = new ByteArrayInputStream(envelopeddata);
        DERInputStream din = new DERInputStream((InputStream)bais);
        DERConstructedSequence seq = null;
        try {
            pkcs = din.readObject();
        }
        catch (IOException ex) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance((Object)pkcs);
        if (!content.getContentType().equals((Object)envelopedData)) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header " + content.getContentType().getId());
        }
        seq = (DERConstructedSequence)pkcs;
        DERConstructedSequence env = (DERConstructedSequence)DERConstructedSequence.getInstance((ASN1TaggedObject)((DERTaggedObject)seq.getObjectAt(1)), (boolean)true);
        DERConstructedSet ds = (DERConstructedSet)DERSet.getInstance((Object)env.getObjectAt(1));
        DERConstructedSequence recpientInfos = (DERConstructedSequence)DERConstructedSequence.getInstance((Object)ds.getObjectAt(0));
        IssuerAndSerialNumber isAndSN = IssuerAndSerialNumber.getInstance((Object)recpientInfos.getObjectAt(1));
        String issuer = isAndSN.getName().toString();
        String sn = isAndSN.getCertificateSerialNumber().getValue().toString(10);
        String certIssuer = ((X509Certificate)cert).getIssuerDN().toString();
        String certSN = ((X509Certificate)cert).getSerialNumber().toString(10);
        if (!certIssuer.equals(issuer) || !certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certification is not match");
        }
        DEROctetString encKey = (DEROctetString)recpientInfos.getObjectAt(3);
        DERConstructedSequence cont = (DERConstructedSequence)DERConstructedSequence.getInstance((Object)env.getObjectAt(2));
        AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance((Object)cont.getObjectAt(1));
        String algOid = alg.getObjectId().getId();
        SymmetricalAlgorithm symmalg = AlgorithmUtil.getSymmetricalAlgByOId(algOid);
        if (symmalg == null) {
            throw new NoSuchAlgorithmException("Unsupport symmetrical algorithm " + algOid);
        }
        this.encAlg = symmalg.getName();
        byte[] iv = null;
        DEROctetString algParam = null;
        DEREncodable obj = alg.getParameters();
        if (obj instanceof DEROctetString) {
            algParam = (DEROctetString)obj;
        }
        if (obj instanceof DERConstructedSequence) {
            DERConstructedSequence se11 = (DERConstructedSequence)alg.getParameters();
            if (se11.getSize() == 0) {
                throw new SecurityException("The ALGParam Sequence size is 0");
            }
            algParam = (DEROctetString)se11.getObjectAt(se11.getSize() - 1);
        }
        if (symmalg.hasIv()) {
            iv = algParam.getOctets();
        }
        DEROctetString encdata = (DEROctetString)DEROctetString.getInstance((ASN1TaggedObject)((DERTaggedObject)cont.getObjectAt(2)), (boolean)true);
        byte[] out = hardcryptoimpl.DecryptWithRSAPrivateKeyWithAlg(prilabel, encdata.getOctets(), encKey.getOctets(), symmalg.getType(), symmalg.getAlgorithm(), symmalg.hasIv(), iv);
        return out;
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String alg, HardCryptoImpl hardimpl) throws WriteEnvDataException, CryptoException {
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        IssuerAndSerialNumber isAndSN = new IssuerAndSerialNumber((X509Name)((X509Principal)((X509Certificate)cert).getIssuerDN()), new DERInteger(((X509Certificate)cert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier(OID_RSA_ECB_PKCS1PADDING), null);
        SymmetricalAlgorithm syalg = AlgorithmUtil.getSymmetricalAlgByName(alg);
        List list = PKCS7EnvelopedDataUtil.getAlgorithmIdentifier(syalg);
        AlgorithmIdentifier derAlg = (AlgorithmIdentifier)list.get(0);
        Object param = null;
        DEROctetString paramtemp = (DEROctetString)list.get(1);
        byte[] IV = null;
        if (paramtemp != null) {
            IV = paramtemp.getOctets();
        }
        byte[][] temp = hardimpl.EncryptWithRSAPublicKeyWithAlg(cert.getPublicKey(), plaindata, syalg.getType(), syalg.getMechanism(), syalg.getAlgorithm(), syalg.hasIv(), IV);
        DEROctetString derEncKey = new DEROctetString(temp[1]);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject((DEREncodable)recpientver);
        recipientInfo.addObject((DEREncodable)isAndSN);
        recipientInfo.addObject((DEREncodable)derAlgEncKey);
        recipientInfo.addObject((DEREncodable)derEncKey);
        DERSet recipientInfos = new DERSet((DEREncodable)recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(OID_ENCRYPTCONTENT);
        DERTaggedObject encContent = new DERTaggedObject(true, 0, (DEREncodable)new DEROctetString(temp[0]));
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject((DEREncodable)contentType);
        cont.addObject((DEREncodable)derAlg);
        cont.addObject((DEREncodable)encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject((DEREncodable)version);
        env.addObject((DEREncodable)recipientInfos);
        env.addObject((DEREncodable)cont);
        String envdatatype = OID_ENVELOPEDDATATYPE;
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject((DEREncodable)new DERObjectIdentifier(envdatatype));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, (DEREncodable)env);
        p7.addObject((DEREncodable)dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream((OutputStream)baos);
        try {
            dout.writeObject((Object)p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException("write Envelop Data Error!");
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }
}

