/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.netsign.crypto.algorithm.SymmetricalAlgorithm;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;

public class PKCS7EnvelopedDataUtil {
    public static List getAlgorithmIdentifier(SymmetricalAlgorithm symalg) {
        ArrayList<Object> list = new ArrayList<Object>();
        String oid = symalg.getOId();
        boolean hasIV = symalg.hasIv();
        boolean needseq = symalg.isSeq();
        DEROctetString sIV = null;
        AlgorithmIdentifier algID = null;
        if (hasIV) {
            byte[] iv = new byte[symalg.getIVLength()];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(iv);
            sIV = new DEROctetString(iv);
            if (needseq) {
                DERConstructedSequence seq = new DERConstructedSequence();
                seq.addObject((DEREncodable)new DERInteger(symalg.getIvParamVersion()));
                seq.addObject((DEREncodable)sIV);
                algID = new AlgorithmIdentifier(new DERObjectIdentifier(oid), (DEREncodable)seq);
            } else {
                algID = new AlgorithmIdentifier(new DERObjectIdentifier(oid), (DEREncodable)sIV);
            }
        } else {
            algID = new AlgorithmIdentifier(new DERObjectIdentifier(oid), sIV);
        }
        list.add(algID);
        list.add(sIV);
        return list;
    }

    public static void main(String[] args) {
    }
}

