/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERSet;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.DecryptDataException;
import cn.com.infosec.jce.exception.DecryptKeyException;
import cn.com.infosec.jce.exception.EncryptDataException;
import cn.com.infosec.jce.exception.EncryptKeyException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.asn1.util.DerUtil;
import cn.com.infosec.netsign.crypto.algorithm.SymmetricalAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.PKCS7EnvelopedDataUtil;
import cn.com.infosec.netsign.crypto.util.cache.Envelop;
import cn.com.infosec.netsign.crypto.util.cache.EnvelopCache;
import cn.com.infosec.netsign.crypto.util.cache.EnvelopGear;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import cn.com.infosec.pkcs.EncryptedContentInfo;
import cn.com.infosec.pkcs.EnvelopedData;
import cn.com.infosec.pkcs.FastPkcs7;
import cn.com.infosec.pkcs.Item;
import cn.com.infosec.pkcs.RecipientInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PKCS7EnvelopedData
implements PKCSObjectIdentifiers {
    public static final int TRIPLE_DES_CBC = 1;
    public static final int DES_CBC = 2;
    public static final int RC2_CBC = 3;
    public static final int RC4 = 4;
    private static final String OID_ENVELOPEDDATATYPE = "1.2.840.113549.1.7.3";
    private static final String OID_Q7_ENVELOPEDDATATYPE = "1.2.156.10197.6.1.4.2.3";
    private static final String OID_ENCRYPTCONTENT = "1.2.840.113549.1.7.1";
    private static final String OID_Q7_ENCRYPTCONTENT = "1.2.156.10197.6.1.4.2.1";
    private static final String OID_RSA_ECB_PKCS1PADDING = "1.2.840.113549.1.1.1";
    private static final String OID_SM2_ENCRYPTION = "1.2.156.10197.1.301.3";
    private String encAlg;
    private static EnvelopCache cache;

    static {
        if (Envelop.isCache()) {
            cache = new EnvelopCache(Envelop.getEnvCacheSize(), new EnvelopGear(Envelop.getEnGear()), new EnvelopGear(Envelop.getDeGear()));
        }
    }

    public String getEncAlg() {
        return this.encAlg;
    }

    public byte[] decrypt(byte[] envelopeddata, Certificate cert, PrivateKey prik) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, NoSuchAlgorithmException {
        return this.decrypt(envelopeddata, cert, prik, "INFOSEC");
    }

    public byte[] decrypt1(byte[] envelopeddata, Certificate cert, PrivateKey prik, String provider) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException {
        DERObject pkcs;
        ByteArrayInputStream bais = new ByteArrayInputStream(envelopeddata);
        DERInputStream din = new DERInputStream((InputStream)bais);
        DERConstructedSequence seq = null;
        try {
            pkcs = din.readObject();
        }
        catch (IOException ex) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance((Object)pkcs);
        if (!content.getContentType().equals((Object)envelopedData)) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header " + content.getContentType().getId());
        }
        seq = (DERConstructedSequence)pkcs;
        DERConstructedSequence env = (DERConstructedSequence)DERConstructedSequence.getInstance((ASN1TaggedObject)((DERTaggedObject)seq.getObjectAt(1)), (boolean)true);
        DERConstructedSet ds = (DERConstructedSet)DERSet.getInstance((Object)env.getObjectAt(1));
        DERConstructedSequence recpientInfos = (DERConstructedSequence)DERConstructedSequence.getInstance((Object)ds.getObjectAt(0));
        IssuerAndSerialNumber isAndSN = IssuerAndSerialNumber.getInstance((Object)recpientInfos.getObjectAt(1));
        String issuer = isAndSN.getName().toString();
        String sn = isAndSN.getCertificateSerialNumber().getValue().toString(10);
        String certIssuer = ((X509Certificate)cert).getIssuerDN().toString();
        String certSN = ((X509Certificate)cert).getSerialNumber().toString(10);
        if (!CryptoUtil.compereDN(issuer, certIssuer) || !certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certification is not match");
        }
        DEROctetString encKey = (DEROctetString)recpientInfos.getObjectAt(3);
        DERConstructedSequence cont = (DERConstructedSequence)DERConstructedSequence.getInstance((Object)env.getObjectAt(2));
        AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance((Object)cont.getObjectAt(1));
        String algoid = alg.getObjectId().getId();
        SymmetricalAlgorithm sym = AlgorithmUtil.getSymmetricalAlgByOId(algoid);
        DEROctetString algParam = null;
        DEREncodable obj = alg.getParameters();
        if (obj instanceof DEROctetString) {
            algParam = (DEROctetString)obj;
        }
        if (obj instanceof DERConstructedSequence) {
            DERConstructedSequence se11 = (DERConstructedSequence)alg.getParameters();
            if (se11.getSize() == 0) {
                throw new SecurityException("The ALGParam Sequence size is 0");
            }
            algParam = (DEROctetString)se11.getObjectAt(se11.getSize() - 1);
        }
        IvParameterSpec param = null;
        if (algParam != null) {
            param = new IvParameterSpec(algParam.getOctets());
        }
        DEROctetString encdata = (DEROctetString)DEROctetString.getInstance((ASN1TaggedObject)((DERTaggedObject)cont.getObjectAt(2)), (boolean)true);
        byte[] key = null;
        try {
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
            c.init(2, prik);
            key = c.doFinal(encKey.getOctets());
        }
        catch (Exception ex) {
            throw new DecryptKeyException(ex.getMessage());
        }
        CryptoUtil.debug(key);
        byte[] out = null;
        CryptoUtil.debug(encdata.getOctets());
        try {
            Cipher cd = Cipher.getInstance(sym.getAlgorithmString(), provider);
            SecretKeySpec sk = new SecretKeySpec(key, sym.getAlgorithmString());
            cd.init(2, (Key)sk, param);
            out = cd.doFinal(encdata.getOctets());
        }
        catch (Exception ex) {
            throw new DecryptDataException(ex.getMessage());
        }
        return out;
    }

    public byte[] decrypt(byte[] envelopeddata, Certificate cert, PrivateKey prik, String provider) throws SecurityException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, NoSuchAlgorithmException {
        String asymmetricAlgorithm;
        FastPkcs7 fp7 = new FastPkcs7();
        if (!fp7.pkcs7SignedData(envelopeddata, provider)) {
            throw new SecurityException("can't decode PKCS7EnvlopedData object");
        }
        EnvelopedData ed = fp7.getEnvelopedData();
        if (ed == null) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - wrong header" + fp7.getContentType());
        }
        ArrayList riList = ed.getVRecipientInfo();
        RecipientInfo ri = (RecipientInfo)riList.get(0);
        Item item = ri.getIssuerAndSerialNumber();
        cn.com.infosec.pkcs.IssuerAndSerialNumber iasn = new cn.com.infosec.pkcs.IssuerAndSerialNumber(envelopeddata, item);
        item = iasn.getIssuer();
        byte[] bs = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, bs, 0, bs.length);
        ASN1InputStream in = new ASN1InputStream(bs);
        String issuer = "";
        CryptoUtil.debug(bs);
        try {
            ASN1Sequence seq = ASN1Sequence.getInstance((Object)in.readObject());
            X509Name name = new X509Name(seq);
            issuer = name.toString();
            CryptoUtil.debug(issuer);
            in.close();
        }
        catch (Exception e) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - parse issuer subject failed:" + e.toString());
        }
        String sn = iasn.getSerialNumber().getSerialNumber().toString(10);
        CryptoUtil.debug(sn);
        String certIssuer = ((X509Certificate)cert).getIssuerDN().toString();
        CryptoUtil.debug(certIssuer);
        String certSN = ((X509Certificate)cert).getSerialNumber().toString(10);
        CryptoUtil.debug(certSN);
        if (!CryptoUtil.compereDN(issuer, certIssuer) || !certSN.equals(sn)) {
            throw new CertificateNotMatchException("Certification is not match");
        }
        byte[] encKey = ri.getEncKey();
        EncryptedContentInfo eci = ed.getEncryptedContentInfoObject();
        item = eci.getContentEncryptionAlgorithm();
        bs = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, bs, 0, bs.length);
        in = new ASN1InputStream(bs);
        SymmetricalAlgorithm sym = null;
        String algoid = "";
        try {
            AlgorithmIdentifier alg = AlgorithmIdentifier.getInstance((Object)in.readObject());
            algoid = alg.getObjectId().getId();
            sym = AlgorithmUtil.getSymmetricalAlgByOId(algoid);
        }
        catch (Exception e) {
            throw new SecurityException("Not a valid PKCS#7 envloped-data object - parse symmetrical algorithm failed:" + e.toString());
        }
        this.encAlg = sym == null ? algoid : sym.getName();
        CryptoUtil.debug(this.encAlg);
        item = eci.getIvParameter();
        bs = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, bs, 0, bs.length);
        IvParameterSpec param = null;
        if (bs.length != 0 && (bs[0] != 5 || bs[1] != 0)) {
            if (bs[0] == 48) {
                bs = DerUtil.getDERInnerData(bs);
                bs = DerUtil.getDERInnerData(bs, 2);
                param = new IvParameterSpec(bs);
            } else {
                byte[] tmp = new byte[0xFF & bs[1]];
                System.arraycopy(bs, 2, tmp, 0, tmp.length);
                param = new IvParameterSpec(tmp);
            }
        }
        item = eci.getEncryptedContent();
        byte[] encdata = new byte[item.length];
        System.arraycopy(envelopeddata, item.offset, encdata, 0, encdata.length);
        byte[] key = null;
        String nProvider = provider;
        if ("jce:SwxaJCE".equals(ExtendedConfig.getPrivateKeyAlg()) && ExtendedConfig.isUsehardkeystore() && ExtendedConfig.getHardKeyStoreDevice() == null) {
            nProvider = "SwxaJCE";
        }
        if ("SM2".equals(asymmetricAlgorithm = prik.getAlgorithm())) {
            byte[] sm2prik = prik.getEncoded();
            key = SDFJNI.sm2Decrypt(encKey, sm2prik);
            if (key == null || key.length == 0) {
                throw new DecryptDataException("SM2 Decrypt Error");
            }
        } else {
            try {
                Cipher c = Cipher.getInstance(String.valueOf(asymmetricAlgorithm) + "/ECB/PKCS1Padding", nProvider);
                c.init(2, prik);
                key = c.doFinal(encKey);
            }
            catch (Exception ex) {
                throw new DecryptKeyException(ex.getMessage());
            }
        }
        CryptoUtil.debug(key);
        CryptoUtil.debug(encdata);
        byte[] out = null;
        String symmetricAlgorithmOid = sym.getAlgorithmString();
        if ("SM4".equalsIgnoreCase(sym.getMechanismString())) {
            int encDataLen = encdata.length;
            out = SDFJNI.sm4Decrypt(encdata, encDataLen, key, param.getIV());
            if (out == null) {
                throw new DecryptDataException("SM4 Decrypt Error");
            }
        } else {
            try {
                Cipher cd = Cipher.getInstance(symmetricAlgorithmOid, provider);
                SecretKeySpec sk = new SecretKeySpec(key, symmetricAlgorithmOid);
                if (param != null) {
                    cd.init(2, (Key)sk, param);
                } else {
                    cd.init(2, sk);
                }
                out = cd.doFinal(encdata);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                throw new DecryptDataException(ex.getMessage());
            }
        }
        return out;
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String alg, String provider, PublicKey pubk) throws EncryptDataException, EncryptKeyException, WriteEnvDataException, NoSuchProviderException, NoSuchAlgorithmException {
        String envelopedDataType = OID_ENVELOPEDDATATYPE;
        String dataType = OID_ENCRYPTCONTENT;
        String asymmetricAlgOid = OID_RSA_ECB_PKCS1PADDING;
        String asymmetricAlg = "RSA/ECB/PKCS1Padding";
        boolean isSM2 = false;
        if (pubk instanceof JCESM2PublicKey || pubk instanceof SM2PublicKey) {
            isSM2 = true;
            asymmetricAlgOid = OID_SM2_ENCRYPTION;
            asymmetricAlg = "SM2";
            if (ExtendedConfig.isSm2EncUsingQ7()) {
                envelopedDataType = OID_Q7_ENVELOPEDDATATYPE;
                dataType = OID_Q7_ENCRYPTCONTENT;
            }
        } else if (ExtendedConfig.isRsaEncUsingQ7()) {
            envelopedDataType = OID_Q7_ENVELOPEDDATATYPE;
            dataType = OID_Q7_ENCRYPTCONTENT;
        }
        DERInteger version = new DERInteger(0);
        DERInteger recpientver = new DERInteger(0);
        IssuerAndSerialNumber isAndSN = new IssuerAndSerialNumber((X509Name)((X509Principal)((X509Certificate)cert).getIssuerDN()), new DERInteger(((X509Certificate)cert).getSerialNumber()));
        AlgorithmIdentifier derAlgEncKey = new AlgorithmIdentifier(new DERObjectIdentifier(asymmetricAlgOid), null);
        SymmetricalAlgorithm symalgth = AlgorithmUtil.getSymmetricalAlgByName(alg);
        if (symalgth == null) {
            throw new NoSuchAlgorithmException(String.valueOf(alg) + " can not be supported");
        }
        SecretKey key = null;
        byte[] keyData = null;
        boolean isSM4 = false;
        if ("SM4".equalsIgnoreCase(alg)) {
            isSM4 = true;
            keyData = new byte[16];
            SecureRandom ivRandom = new SecureRandom();
            ivRandom.nextBytes(keyData);
        } else {
            KeyGenerator kg = null;
            kg = KeyGenerator.getInstance(symalgth.getMechanismString(), provider);
            if (provider.equals("DatechCrypto")) {
                SecureRandom sr = SecureRandom.getInstance("DevRandom", provider);
                kg.init(sr);
            }
            key = kg.generateKey();
            keyData = key.getEncoded();
        }
        Cipher c = null;
        byte[] encKey = null;
        if (!isSM2) {
            try {
                c = Cipher.getInstance(asymmetricAlg, provider);
                c.init(1, pubk);
                encKey = c.doFinal(keyData);
            }
            catch (Exception ex) {
                throw new EncryptKeyException(ex.getMessage());
            }
        } else {
            byte[] sm2Pubk = new byte[65];
            sm2Pubk[0] = 4;
            if (pubk instanceof JCESM2PublicKey) {
                System.arraycopy(((JCESM2PublicKey)pubk).getX(), 0, sm2Pubk, 1, 32);
                System.arraycopy(((JCESM2PublicKey)pubk).getY(), 0, sm2Pubk, 33, 32);
            } else {
                System.arraycopy(((SM2PublicKey)pubk).getX(), 0, sm2Pubk, 1, 32);
                System.arraycopy(((SM2PublicKey)pubk).getY(), 0, sm2Pubk, 33, 32);
            }
            encKey = SDFJNI.sm2Encrypt(keyData, sm2Pubk);
            if (encKey == null) {
                throw new EncryptDataException("SM2 Encrypt Error");
            }
        }
        DEROctetString derEncKey = new DEROctetString(encKey);
        DERConstructedSequence recipientInfo = new DERConstructedSequence();
        recipientInfo.addObject((DEREncodable)recpientver);
        recipientInfo.addObject((DEREncodable)isAndSN);
        recipientInfo.addObject((DEREncodable)derAlgEncKey);
        recipientInfo.addObject((DEREncodable)derEncKey);
        DERSet recipientInfos = new DERSet((DEREncodable)recipientInfo);
        DERObjectIdentifier contentType = new DERObjectIdentifier(dataType);
        List list = PKCS7EnvelopedDataUtil.getAlgorithmIdentifier(symalgth);
        AlgorithmIdentifier derAlg = (AlgorithmIdentifier)list.get(0);
        IvParameterSpec param = null;
        DEROctetString paramtemp = (DEROctetString)list.get(1);
        if (paramtemp != null) {
            param = new IvParameterSpec(paramtemp.getOctets());
        }
        byte[] encdata = null;
        if (!isSM4) {
            try {
                c = Cipher.getInstance(symalgth.getAlgorithmString(), provider);
                c.init(1, (Key)key, param);
                encdata = c.doFinal(plaindata);
            }
            catch (Exception ex) {
                ex.printStackTrace(System.out);
                throw new EncryptDataException(ex.toString());
            }
        } else {
            int ptLen = plaindata.length;
            encdata = SDFJNI.sm4Encrypt(plaindata, ptLen, keyData, param.getIV());
            if (encdata == null) {
                throw new EncryptDataException("SM4 Encrypt Error");
            }
        }
        DERTaggedObject encContent = new DERTaggedObject(true, 0, (DEREncodable)new DEROctetString(encdata));
        DERConstructedSequence cont = new DERConstructedSequence();
        cont.addObject((DEREncodable)contentType);
        cont.addObject((DEREncodable)derAlg);
        cont.addObject((DEREncodable)encContent);
        DERConstructedSequence env = new DERConstructedSequence();
        env.addObject((DEREncodable)version);
        env.addObject((DEREncodable)recipientInfos);
        env.addObject((DEREncodable)cont);
        DERConstructedSequence p7 = new DERConstructedSequence();
        p7.addObject((DEREncodable)new DERObjectIdentifier(envelopedDataType));
        DERTaggedObject dtCont = new DERTaggedObject(true, 0, (DEREncodable)env);
        p7.addObject((DEREncodable)dtCont);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream((OutputStream)baos);
        try {
            dout.writeObject((Object)p7);
        }
        catch (IOException ex) {
            throw new WriteEnvDataException(ex.getMessage());
        }
        byte[] bs = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String alg, String provider) throws EncryptDataException, EncryptKeyException, WriteEnvDataException, NoSuchProviderException, NoSuchAlgorithmException {
        return this.encrypt(plaindata, cert, alg, provider, cert.getPublicKey());
    }

    public byte[] encrypt(byte[] plaindata, Certificate cert, String alg) throws EncryptDataException, EncryptKeyException, WriteEnvDataException, NoSuchProviderException, NoSuchAlgorithmException {
        return this.encrypt(plaindata, cert, alg, "INFOSEC");
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new InfosecProvider());
        try {
            FileInputStream fint = new FileInputStream("c:\\testharddes");
            int len = fint.available();
            byte[] testclient = new byte[len];
            fint.read(testclient);
            fint.close();
            FileOutputStream fw = new FileOutputStream("c:\\testharddes1");
            fw.write(Base64.decode(testclient));
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] encryptOptCache(byte[] plainText, X509Certificate enccert, String alg, String provider, PublicKey pubk) throws EncryptDataException, EncryptKeyException, WriteEnvDataException, NoSuchProviderException, NoSuchAlgorithmException {
        byte[] key = pubk.getEncoded();
        if (cache == null) {
            return this.encrypt(plainText, enccert, alg, provider, pubk);
        }
        byte[] cipher = cache.getCipher(plainText, alg, key);
        if (cipher != null) {
            return cipher;
        }
        cipher = this.encrypt(plainText, enccert, alg, provider, pubk);
        cache.putCipher(plainText, alg, key, cipher);
        return cipher;
    }

    public byte[] decryptOptCache(byte[] envelopedMsg, X509Certificate cert, PrivateKey decprikey, String provider) throws InvalidParameterException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, SecurityException, NoSuchAlgorithmException {
        byte[] key = decprikey.getEncoded();
        String alg = "";
        if (cache == null) {
            return this.decrypt(envelopedMsg, cert, decprikey, provider);
        }
        byte[] bak = cache.getDecryptResult(envelopedMsg, alg, key);
        if (bak != null) {
            return bak;
        }
        bak = this.decrypt(envelopedMsg, cert, decprikey, provider);
        cache.putDecryptResult(envelopedMsg, alg, key, bak);
        return bak;
    }
}

