/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.pkcs.CertificationRequest;
import cn.com.infosec.asn1.pkcs.CertificationRequestInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.HardCryptoImpl;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Hashtable;
import javax.security.auth.x500.X500Principal;

public class PKCS10CertificationRequest
extends CertificationRequest {
    private static Hashtable algorithms = new Hashtable();
    private static Hashtable oids = new Hashtable();

    static {
        algorithms.put("MD2WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD2WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.2"));
        algorithms.put("MD5WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("MD5WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("RSAWITHMD5", new DERObjectIdentifier("1.2.840.113549.1.1.4"));
        algorithms.put("SHA1WITHRSAENCRYPTION", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("SHA1WITHRSA", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RSAWITHSHA1", new DERObjectIdentifier("1.2.840.113549.1.1.5"));
        algorithms.put("RIPEMD160WITHRSAENCRYPTION", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("RIPEMD160WITHRSA", new DERObjectIdentifier("1.3.36.3.3.1.2"));
        algorithms.put("SHA1WITHDSA", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("DSAWITHSHA1", new DERObjectIdentifier("1.2.840.10040.4.3"));
        algorithms.put("SHA1WITHECDSA", new DERObjectIdentifier("1.2.840.10045.4.1"));
        algorithms.put("ECDSAWITHSHA1", new DERObjectIdentifier("1.2.840.10045.4.1"));
        algorithms.put("SM3WITHSM2", new DERObjectIdentifier("1.2.156.10197.1.501"));
        algorithms.put("SHA1WITHSM2", new DERObjectIdentifier("1.2.156.197.1.502"));
        algorithms.put("SHA256WITHSM2", new DERObjectIdentifier("1.2.156.197.1.503"));
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.5"), "SHA1WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.4"), "MD5WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.113549.1.1.2"), "MD2WITHRSA");
        oids.put(new DERObjectIdentifier("1.2.840.10040.4.3"), "DSAWITHSHA1");
        oids.put(new DERObjectIdentifier("1.2.156.197.1.501"), "SM3WITHSM2");
        oids.put(new DERObjectIdentifier("1.2.156.10197.1.501"), "SM3WITHSM2");
        oids.put(new DERObjectIdentifier("1.2.156.197.1.502"), "SHA1WITHSM2");
        oids.put(new DERObjectIdentifier("1.2.156.197.1.503"), "SHA256WITHSM2");
    }

    private static ASN1Sequence toDERSequence(byte[] bytes) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ASN1InputStream dIn = new ASN1InputStream((InputStream)bIn);
            return (ASN1Sequence)dIn.readObject();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("badly encoded request");
        }
    }

    public PKCS10CertificationRequest(byte[] bytes) {
        super(PKCS10CertificationRequest.toDERSequence(bytes));
    }

    public PKCS10CertificationRequest(ASN1Sequence sequence) {
        super(sequence);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X509Name subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, subject, key, attributes, signingKey, "INFOSEC");
    }

    private static X509Name convertName(X500Principal name) {
        try {
            return new X509Principal(name.getEncoded());
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't convert name");
        }
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X500Principal subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, PKCS10CertificationRequest.convertName(subject), key, attributes, signingKey, "INFOSEC");
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X500Principal subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this(signatureAlgorithm, PKCS10CertificationRequest.convertName(subject), key, attributes, signingKey, provider);
    }

    public PKCS10CertificationRequest(X509Name subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        this("SHA1WITHRSAENCRYPTION", subject, key, attributes, signingKey, provider);
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X509Name subject, PublicKey key, ASN1Set attributes, PrivateKey signingKey, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        DERObjectIdentifier sigOID = (DERObjectIdentifier)algorithms.get(signatureAlgorithm.toUpperCase());
        if (sigOID == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        this.sigAlgId = new AlgorithmIdentifier(sigOID, null);
        byte[] bytes = key.getEncoded();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        ASN1InputStream dIn = new ASN1InputStream((InputStream)bIn);
        try {
            this.reqInfo = new CertificationRequestInfo(subject, new SubjectPublicKeyInfo((ASN1Sequence)dIn.readObject()), attributes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't encode public key");
        }
        Signature sig = null;
        try {
            sig = Signature.getInstance(this.sigAlgId.getObjectId().getId(), provider);
        }
        catch (NoSuchAlgorithmException e) {
            sig = Signature.getInstance(signatureAlgorithm, provider);
        }
        sig.initSign(signingKey);
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((Object)this.reqInfo);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw new SecurityException("exception encoding TBS cert request - " + e);
        }
        this.sigBits = new DERBitString(sig.sign());
    }

    public PKCS10CertificationRequest(String signatureAlgorithm, X509Name subject, SM2PublicKey key, SM2PrivateKey signingKey, byte[] id) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        DERObjectIdentifier sigOID = (DERObjectIdentifier)algorithms.get(signatureAlgorithm.toUpperCase());
        if (sigOID == null) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        if (signingKey == null) {
            throw new IllegalArgumentException("private key must not be null");
        }
        this.sigAlgId = new AlgorithmIdentifier(sigOID, null);
        byte[] bytes = key.getEncoded();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        ASN1InputStream dIn = new ASN1InputStream((InputStream)bIn);
        try {
            this.reqInfo = new CertificationRequestInfo(subject, new SubjectPublicKeyInfo((ASN1Sequence)dIn.readObject()), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("can't encode public key");
        }
        byte[] signed = null;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((Object)this.reqInfo);
            String[] pieces = signatureAlgorithm.split("with");
            signed = SDFJNI.SM2SignWithExternalKey(bOut.toByteArray(), pieces[0], signingKey.getD(), key, id);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException("exception encoding TBS cert request - " + e);
        }
        this.sigBits = new DERBitString(signed);
    }

    public PKCS10CertificationRequest(X509Name subject, int keysize, ASN1Set attributes, byte[] privatekeylabel, HardCryptoImpl hardcryptoimpl, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, CryptoException, SignatureException {
        DERObjectIdentifier sigOID = new DERObjectIdentifier("1.2.840.113549.1.1.5");
        if (sigOID == null) {
            // empty if block
        }
        if (subject == null) {
            throw new IllegalArgumentException("subject must not be null");
        }
        PublicKey key = hardcryptoimpl.genKeyPair4P10(privatekeylabel, keysize);
        if (key == null) {
            throw new IllegalArgumentException("public key must not be null");
        }
        this.sigAlgId = new AlgorithmIdentifier(sigOID, null);
        byte[] bytes = key.getEncoded();
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        ASN1InputStream dIn = new ASN1InputStream((InputStream)bIn);
        try {
            this.reqInfo = new CertificationRequestInfo(subject, new SubjectPublicKeyInfo((ASN1Sequence)dIn.readObject()), attributes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't encode public key");
        }
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((Object)this.reqInfo);
            byte[] signresult = hardcryptoimpl.SignWithAlg(privatekeylabel, bOut.toByteArray(), 6);
            this.sigBits = new DERBitString(signresult);
        }
        catch (IOException ioex) {
            throw new SecurityException("exception encoding TBS cert request - " + ioex);
        }
    }

    public PublicKey getPublicKey() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        return this.getPublicKey("INFOSEC");
    }

    public PublicKey getPublicKey(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        SubjectPublicKeyInfo subjectPKInfo = this.reqInfo.getSubjectPublicKeyInfo();
        try {
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(new DERBitString((DEREncodable)subjectPKInfo).getBytes());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithmId();
            return KeyFactory.getInstance(keyAlg.getObjectId().getId(), provider).generatePublic(xspec);
        }
        catch (InvalidKeySpecException e) {
            throw new InvalidKeyException("error encoding public key");
        }
    }

    public boolean verify() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        return this.verify("INFOSEC");
    }

    public boolean verify(String provider) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, SignatureException {
        Signature sig;
        block4: {
            sig = null;
            try {
                sig = Signature.getInstance(this.sigAlgId.getObjectId().getId(), provider);
            }
            catch (NoSuchAlgorithmException e) {
                if (oids.get(this.sigAlgId.getObjectId().getId()) == null) break block4;
                String signatureAlgorithm = (String)oids.get(this.sigAlgId.getObjectId().getId());
                sig = Signature.getInstance(signatureAlgorithm, provider);
            }
        }
        sig.initVerify(this.getPublicKey(provider));
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((Object)this.reqInfo);
            sig.update(bOut.toByteArray());
        }
        catch (Exception e) {
            throw new SecurityException("exception encoding TBS cert request - " + e);
        }
        return sig.verify(this.sigBits.getBytes());
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
        try {
            dOut.writeObject((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return bOut.toByteArray();
    }
}

