/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.PKCS10CertificationRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class CryptoUtil {
    public static boolean debug = false;
    static byte JNI_RSA_KEY_NAME = (byte)16;
    static byte JNI_RSA_PLAIN_DATA = (byte)32;
    static byte JNI_RSA_SIGNATURE = (byte)64;
    static byte JNI_RSA_KEY_PARM_N = 1;
    static byte JNI_RSA_KEY_PARM_KE = (byte)2;
    static byte JNI_RSA_ENCHASH = (byte)65;
    static byte JNI_RSA_DECHASH = (byte)66;
    static byte JNI_SYM_ENCSECKEY = (byte)67;
    static byte JNI_SYM_ENC_DATA = (byte)68;
    static byte JNI_SYM_ALG_IV = (byte)69;
    static final String cn = "2.5.4.3";
    private static final String BEGIN_CERT_REQ = "-----BEGIN CERTIFICATE REQUEST-----";
    private static final String END_CERT_REQ = "-----END CERTIFICATE REQUEST-----";
    private static final int CERT_REQ_LINE_LENGTH = 76;
    private static final long DATE_2050 = 2524579200000L;
    public static final byte[] DERNULL;
    public static final byte[] DERTRUE;
    private static byte[] cnid;

    static {
        byte[] byArray = new byte[2];
        byArray[0] = 5;
        DERNULL = byArray;
        DERTRUE = new byte[]{1, 1, -1};
        cnid = new byte[]{85, 4, 3};
    }

    public static String getExtern(byte[] a) throws Exception {
        String externvalue = null;
        try {
            String tmp1;
            ByteArrayInputStream bint = new ByteArrayInputStream(a);
            DERInputStream dint = new DERInputStream((InputStream)bint);
            DEROctetString doct = (DEROctetString)dint.readObject();
            byte[] tmp = doct.getOctets();
            bint = new ByteArrayInputStream(tmp);
            dint = new DERInputStream((InputStream)bint);
            DERObject dobj = dint.readObject();
            Class<?> dc = dobj.getClass();
            Class<?> c1 = Class.forName(dc.getName());
            Method m = c1.getMethod("getString", null);
            externvalue = tmp1 = (String)m.invoke((Object)dobj, null);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return externvalue;
    }

    public static ArrayList getcrldp(byte[] a) throws IOException {
        ArrayList<String> cnlist = new ArrayList<String>();
        if (a != null && a.length > 0) {
            int i = 0;
            int ilength = a.length;
            while (i < ilength) {
                boolean match = false;
                int j = 0;
                int jlength = cnid.length;
                while (j < jlength) {
                    if (i + j < ilength) {
                        if (a[i + j] == cnid[j]) {
                            match = true;
                        } else {
                            match = false;
                            i += j;
                            break;
                        }
                    }
                    ++j;
                }
                if (match) {
                    int clength = 0xFF & a[i += 4];
                    byte[] cnbs = new byte[clength];
                    System.arraycopy(a, ++i, cnbs, 0, clength);
                    String cnstr = new String(cnbs);
                    cnlist.add(cnstr);
                    i += clength;
                }
                ++i;
            }
        }
        return cnlist;
    }

    public static boolean compereDN(String DN1, String JKSDN) {
        if (DN1 == null || JKSDN == null) {
            return false;
        }
        if (DN1.equals(JKSDN)) {
            return true;
        }
        String[] temp = JKSDN.split(",");
        String turnDN = temp[temp.length - 1].trim();
        int i = temp.length - 2;
        while (i >= 0) {
            turnDN = String.valueOf(turnDN) + "," + temp[i].trim();
            --i;
        }
        return DN1.equals(turnDN);
    }

    public static boolean compereBytes(byte[] bytes1, byte[] bytes2) {
        if (bytes1 == bytes2) {
            return true;
        }
        if (bytes1 == null || bytes2 == null) {
            return false;
        }
        if (bytes1.length != bytes2.length) {
            return false;
        }
        int i = 0;
        int length = bytes1.length;
        while (i < length) {
            if (bytes1[i] != bytes2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String trimDN(String dn) {
        String[] temp = dn.split(",");
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < temp.length) {
            buffer.append(String.valueOf(temp[i].trim()) + ",");
            ++i;
        }
        String value = buffer.toString();
        return value.substring(0, value.length() - 1);
    }

    public static String turnDN(String DN) {
        String[] temp = DN.split(",");
        String turnDN = temp[temp.length - 1].trim();
        int i = temp.length - 2;
        while (i >= 0) {
            turnDN = String.valueOf(turnDN) + "," + temp[i].trim();
            --i;
        }
        return turnDN;
    }

    public static String createbase64csr(PKCS10CertificationRequest csr) throws CryptoException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DEROutputStream deros = new DEROutputStream((OutputStream)baos);
            deros.writeObject((Object)csr.getDERObject());
            String sTmp = new String(Base64.encode(baos.toByteArray()));
            String sCsr = "-----BEGIN CERTIFICATE REQUEST-----\n";
            int iCnt = 0;
            while (iCnt < sTmp.length()) {
                int iLineLength = iCnt + 76 > sTmp.length() ? sTmp.length() - iCnt : 76;
                sCsr = String.valueOf(sCsr) + sTmp.substring(iCnt, iCnt + iLineLength) + "\n";
                iCnt += 76;
            }
            sCsr = String.valueOf(sCsr) + "-----END CERTIFICATE REQUEST-----\n";
            return sCsr;
        }
        catch (Exception ex) {
            throw new CryptoException(ex);
        }
    }

    public static byte[] constructHardData(byte tag, byte[] sourcedata) {
        int intLen = sourcedata.length;
        byte[] bytelen = CryptoUtil.getDataLength(intLen);
        byte[] result = new byte[5 + intLen];
        result[0] = tag;
        result[1] = bytelen[0];
        result[2] = bytelen[1];
        result[3] = bytelen[2];
        result[4] = bytelen[3];
        int i = 0;
        while (i < intLen) {
            result[5 + i] = sourcedata[i];
            ++i;
        }
        return result;
    }

    public static byte[] getDataLength(int intLen) {
        byte[] result = new byte[]{(byte)(0xFF & intLen >> 24), (byte)(0xFF & intLen >> 16), (byte)(0xFF & intLen >> 8), (byte)(0xFF & intLen >> 0)};
        return result;
    }

    public static PublicKey getPublicKey(byte[] pubkeyN, byte[] pubkeyE) throws CryptoException {
        try {
            BigInteger biN = new BigInteger(1, pubkeyN);
            BigInteger biE = new BigInteger(1, pubkeyE);
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(biN, biE);
            KeyFactory fact = KeyFactory.getInstance("RSA", "INFOSEC");
            PublicKey pubKey = fact.generatePublic(pubKeySpec);
            return pubKey;
        }
        catch (Exception ex) {
            String msg = "Can not convert PublicKey( N & E) bytearray to PublicKey object";
            throw new CryptoException(msg, ex);
        }
    }

    public static byte[] clearHardData(byte[] sourcedata) {
        byte[] byteLen = new byte[]{sourcedata[1], sourcedata[2], sourcedata[3], sourcedata[4]};
        int intLen = CryptoUtil.getDataLength(byteLen);
        byte[] result = new byte[intLen];
        int i = 0;
        while (i < intLen) {
            result[i] = sourcedata[5 + i];
            ++i;
        }
        return result;
    }

    public static byte[] constructHardPublicKey(PublicKey pk) throws CryptoException {
        RSAPublicKey rpk = (RSAPublicKey)pk;
        byte[] pk_n = rpk.getModulus().toByteArray();
        byte[] pk_e = rpk.getPublicExponent().toByteArray();
        int intLen_N = pk_n.length;
        int intLen_E = pk_e.length;
        byte[] bytePkn = CryptoUtil.getDataLength(intLen_N);
        byte[] bytePke = CryptoUtil.getDataLength(intLen_E);
        int totallen = 5 + intLen_N + 1 + 4 + intLen_E;
        byte[] resultPubkey = new byte[totallen];
        resultPubkey[0] = JNI_RSA_KEY_PARM_N;
        resultPubkey[1] = bytePkn[0];
        resultPubkey[2] = bytePkn[1];
        resultPubkey[3] = bytePkn[2];
        resultPubkey[4] = bytePkn[3];
        int i = 0;
        while (i < intLen_N) {
            resultPubkey[5 + i] = pk_n[i];
            ++i;
        }
        int Pos_E = 4 + intLen_N + 1;
        resultPubkey[Pos_E] = JNI_RSA_KEY_PARM_KE;
        resultPubkey[Pos_E + 1] = bytePke[0];
        resultPubkey[Pos_E + 2] = bytePke[1];
        resultPubkey[Pos_E + 3] = bytePke[2];
        resultPubkey[Pos_E + 4] = bytePke[3];
        int curPos_E = Pos_E + 5;
        int i2 = 0;
        while (i2 < intLen_E) {
            resultPubkey[curPos_E + i2] = pk_e[i2];
            ++i2;
        }
        return resultPubkey;
    }

    public static int getDataLength(byte[] len) {
        BigInteger bi = new BigInteger(len);
        String result = bi.toString(10);
        return Integer.valueOf(result);
    }

    public static byte[][] splitHardPublicKey(byte[] hardpubkey) {
        byte[] byteLen_N = new byte[]{hardpubkey[1], hardpubkey[2], hardpubkey[3], hardpubkey[4]};
        int intLen_N = CryptoUtil.getDataLength(byteLen_N);
        int Pos = 4 + intLen_N + 1;
        byte[] byteLen_E = new byte[]{hardpubkey[Pos + 1], hardpubkey[Pos + 2], hardpubkey[Pos + 3], hardpubkey[Pos + 4]};
        int intLen_E = CryptoUtil.getDataLength(byteLen_E);
        byte[] pubkey_N = new byte[intLen_N];
        byte[] pubkey_E = new byte[intLen_E];
        System.arraycopy(hardpubkey, 5, pubkey_N, 0, intLen_N);
        System.arraycopy(hardpubkey, Pos + 5, pubkey_E, 0, intLen_E);
        return new byte[][]{pubkey_N, pubkey_E};
    }

    public static void debug(byte[] bs) {
        if (!debug || bs == null) {
            return;
        }
        int i = 0;
        int length = bs.length;
        while (i < length) {
            int x = bs[i] & 0xFF;
            if (x > 15) {
                System.out.print(String.valueOf(Integer.toString(x, 16)) + " ");
            } else {
                System.out.print("0" + Integer.toString(x, 16) + " ");
            }
            if ((i + 1) % 16 == 0) {
                System.out.print("\n");
            }
            ++i;
        }
        System.out.print("\n");
    }

    public static void debug(String title, byte[] bs) {
        CryptoUtil.debug(String.valueOf(title) + ":");
        CryptoUtil.debug(bs);
    }

    public static void debug(byte[] bs, String file) {
        if (!debug) {
            return;
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            out.write(bs);
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void debug(String msg) {
        if (!debug) {
            return;
        }
        System.out.println(msg);
    }

    public static int bytes2Int(byte[] bytes, boolean desc) {
        if (bytes == null) {
            return 0;
        }
        if (bytes.length < 4) {
            byte[] tmp = new byte[4];
            if (!desc) {
                System.arraycopy(bytes, 0, tmp, 4 - bytes.length, bytes.length);
            } else {
                System.arraycopy(bytes, 0, tmp, 0, bytes.length);
            }
            bytes = tmp;
        }
        if (!desc) {
            return bytes[0] << 24 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        }
        return bytes[3] << 24 | bytes[2] << 16 & 0xFF0000 | bytes[1] << 8 & 0xFF00 | bytes[0] & 0xFF;
    }

    public static byte[] getDERInnerData(byte[] der) {
        int ab = der[1] & 0xFF;
        int length = 0;
        int dataIndex = 0;
        if (ab >= 128) {
            int lengthOfLength = ab - 128;
            byte[] lengthBytes = new byte[lengthOfLength];
            System.arraycopy(der, 2, lengthBytes, 0, lengthOfLength);
            length = CryptoUtil.generateInt(lengthBytes);
            dataIndex = 2 + lengthOfLength;
        } else {
            length = ab;
            dataIndex = 2;
        }
        byte[] data = new byte[length];
        System.arraycopy(der, dataIndex, data, 0, length);
        return data;
    }

    public static byte[] getDERInnerData(byte[] der, int index) {
        int derStart = 0;
        int length = 0;
        int headLength = 2;
        int i = 0;
        while (i < index) {
            int ab = der[derStart + 1] & 0xFF;
            if (ab > 121) {
                int lengthOfLength = ab - 128;
                headLength = 2 + lengthOfLength;
                byte[] lengthBytes = new byte[lengthOfLength];
                System.arraycopy(der, derStart + 2, lengthBytes, 0, lengthOfLength);
                length = CryptoUtil.generateInt(lengthBytes);
            } else {
                length = ab;
            }
            if (i != index - 1) {
                derStart = derStart + length + headLength;
            }
            ++i;
        }
        byte[] bs = new byte[length];
        System.arraycopy(der, derStart + headLength, bs, 0, length);
        return bs;
    }

    public static int generateInt(byte[] bytes) {
        int tr = 0;
        int i = bytes.length - 1;
        while (i > -1) {
            int x = (bytes[bytes.length - 1 - i] & 0xFF) << i * 8;
            tr += x;
            --i;
        }
        return tr;
    }

    public static byte[] generateDERCode(int type, byte[] content) {
        int length = content.length;
        byte[] lengthBs = null;
        if (length >= 128) {
            byte[] intBs = CryptoUtil.int2Bytes(length);
            lengthBs = new byte[1 + intBs.length];
            lengthBs[0] = (byte)(128 + intBs.length);
            System.arraycopy(intBs, 0, lengthBs, 1, intBs.length);
        } else {
            lengthBs = new byte[]{(byte)length};
        }
        byte[] all = new byte[1 + lengthBs.length + content.length];
        all[0] = (byte)type;
        System.arraycopy(lengthBs, 0, all, 1, lengthBs.length);
        System.arraycopy(content, 0, all, 1 + lengthBs.length, content.length);
        return all;
    }

    public static byte[] int2Bytes(int i) {
        int l = 0;
        l = i <= 255 ? 1 : (i <= 65535 ? 2 : (i <= 0xFFFFFF ? 3 : 4));
        byte[] bs = new byte[l];
        int x = 0;
        while (x < l) {
            bs[x] = (byte)(i >> (l - 1 - x) * 8);
            ++x;
        }
        return bs;
    }

    public static byte[] connect(byte[] a, byte[] b) {
        byte[] tmp = new byte[a.length + b.length];
        System.arraycopy(a, 0, tmp, 0, a.length);
        System.arraycopy(b, 0, tmp, a.length, b.length);
        return tmp;
    }

    public static byte[] date2ASN1(Date date) {
        if (date.getTime() < 2524579200000L) {
            SimpleDateFormat format = new SimpleDateFormat("yyMMddHHmmss");
            String time = String.valueOf(format.format(date)) + "Z";
            return CryptoUtil.generateDERCode(23, time.getBytes());
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
        String time = String.valueOf(format.format(date)) + "Z";
        return CryptoUtil.generateDERCode(24, time.getBytes());
    }

    public static byte[] oid2ASN1(String oid) {
        String[] pieces = oid.split("\\.");
        byte[] oidbs = null;
        byte b = (byte)(Integer.parseInt(pieces[0]) * 40 + Integer.parseInt(pieces[1]));
        oidbs = new byte[]{b};
        int i = 2;
        while (i < pieces.length) {
            int num = Integer.parseInt(pieces[i]);
            int pow = CryptoUtil.maxPow128(num, 0);
            byte[] id = new byte[pow + 1];
            CryptoUtil.genid(pow, num, id);
            byte[] tmp = new byte[oidbs.length + id.length];
            System.arraycopy(oidbs, 0, tmp, 0, oidbs.length);
            System.arraycopy(id, 0, tmp, oidbs.length, id.length);
            oidbs = tmp;
            ++i;
        }
        return oidbs;
    }

    private static int maxPow128(int num, int pow) {
        double d = (double)num % Math.pow(128.0, pow);
        int n = pow - 1 > 0 ? pow - 1 : 1;
        if (d > Math.pow(128.0, n)) {
            return CryptoUtil.maxPow128(num, pow + 1);
        }
        if (pow == 0 && num / 128 > 0) {
            return 1;
        }
        return pow;
    }

    private static void genid(int pow, int num, byte[] id) {
        if (pow == 0) {
            id[id.length - 1] = (byte)num;
        } else {
            id[id.length - 1 - pow] = (byte)(128.0 + (double)num / Math.pow(128.0, pow));
        }
        if (pow - 1 >= 0) {
            CryptoUtil.genid(pow - 1, (int)((double)num % Math.pow(128.0, pow)), id);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509Certificate generateCertificate(byte[] cert) throws Exception {
        ByteArrayInputStream in = null;
        if (cert[0] == 48) {
            int tl = (cert[1] & 0xFF) - 128;
            if (tl <= 0) throw new CertificateException("Illegal code: 30 " + (cert[1] & 0xFF));
            byte[] ltmp = new byte[tl];
            System.arraycopy(cert, 2, ltmp, 0, tl);
            int length = new BigInteger(ltmp).intValue();
            if (length <= 0 || length != cert.length - 2 - tl) throw new CertificateException("Illegal length: " + length);
            in = new ByteArrayInputStream(cert);
        } else {
            String head = "-----BEGIN CERTIFICATE-----";
            String tail = "-----END CERTIFICATE-----";
            String b64Cert = new String(cert);
            if (b64Cert.indexOf(head) > -1) {
                b64Cert = b64Cert.replaceFirst(head, "").replaceFirst(tail, "");
            }
            byte[] certTmp = Base64.decode(b64Cert.trim());
            in = new ByteArrayInputStream(certTmp);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
        return (X509Certificate)cf.generateCertificate(in);
    }

    public static void main(String[] args) throws Exception {
        String DN1 = "c=cn,ou=infosec,ou=randd,cn=hy";
        String DN2 = "cn=hy,ou=randd,ou=infosec,c=cn";
        System.out.println(CryptoUtil.turnDN(DN1));
        CryptoUtil.compereDN(DN1, DN2);
    }
}

