/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.algorithm.SymmetricalAlgorithm;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class AlgorithmUtil {
    private static Map digestAlgs = new HashMap();
    private static Map digestAlgs1 = new HashMap();
    private static Map symmetricalAlgs = new HashMap();
    private static Map symmetricalAlgs1 = new HashMap();

    private static Document createDocument(String fileName) throws CryptoException {
        SAXBuilder builder = new SAXBuilder(true);
        try {
            Document doc = builder.build(new File(fileName));
            return doc;
        }
        catch (IOException ioEx) {
            throw new CryptoException(ioEx);
        }
        catch (JDOMException jdomEx) {
            throw new CryptoException(jdomEx);
        }
    }

    private static String convertValue(String value) {
        String v = value.toUpperCase();
        if (v.startsWith("0X")) {
            v = v.substring(2);
        }
        return v;
    }

    private static void parseDigestAlgForHard(Element element) throws CryptoException {
        String name = element.getAttributeValue("name").trim().toUpperCase();
        try {
            String algStr = element.getChild("key-algorithm").getAttributeValue("value").trim();
            if (algStr == null) {
                throw new CryptoException("do not exist element key-algorithm");
            }
            int algorithm = Integer.parseInt(AlgorithmUtil.convertValue(algStr), 16);
            String oid = element.getChild("oid").getAttributeValue("value").trim();
            DigestAlgorithm dAlgorithm = new DigestAlgorithm(name, oid, algorithm);
            digestAlgs.put(name, dAlgorithm);
            digestAlgs1.put(oid, dAlgorithm);
        }
        catch (NumberFormatException ex) {
            throw new CryptoException(ex);
        }
    }

    private static void parseDigestAlgForSoft(Element element) {
        String name = element.getAttributeValue("name").trim().toUpperCase();
        String oid = element.getChild("oid").getAttributeValue("value").trim();
        DigestAlgorithm dAlgorithm = new DigestAlgorithm(name, oid, -1);
        digestAlgs.put(name, dAlgorithm);
        digestAlgs1.put(oid, dAlgorithm);
    }

    private static void parseSymmetricalAlgForHard(Element element) throws CryptoException {
        try {
            Element e;
            SymmetricalAlgorithm sAlgorithm = new SymmetricalAlgorithm();
            String name = element.getAttributeValue("name").trim().toUpperCase();
            sAlgorithm.setName(name);
            String keyTypeStr = element.getChild("key-type").getAttributeValue("value").trim();
            if (keyTypeStr == null) {
                throw new CryptoException("do not exist element key-type");
            }
            long type = Long.parseLong(AlgorithmUtil.convertValue(keyTypeStr), 16);
            sAlgorithm.setType(type);
            String mechanismStr = element.getChild("key-gen-mechanism").getAttributeValue("value").trim();
            long mechanism = Long.parseLong(AlgorithmUtil.convertValue(mechanismStr), 16);
            sAlgorithm.setMechanism(mechanism);
            long algorithm = Long.parseLong(AlgorithmUtil.convertValue(element.getChild("key-enc-algorithm").getAttributeValue("value").trim()), 16);
            sAlgorithm.setAlgorithm(algorithm);
            String oid = element.getChild("oid").getAttributeValue("value").trim();
            sAlgorithm.setOId(oid);
            boolean hasIv = new Boolean(element.getChild("has-iv").getAttributeValue("value"));
            sAlgorithm.setIv(hasIv);
            if (hasIv && (e = element.getChild("iv-length")) != null) {
                int ivLength = Integer.parseInt(e.getAttributeValue("value", "8").trim());
                sAlgorithm.setIVLength(ivLength);
            }
            boolean isSeq = new Boolean(element.getChild("is-seq-param").getAttributeValue("value"));
            sAlgorithm.setSeq(isSeq);
            if (isSeq) {
                String paramVersionStr = element.getChild("iv-param-version").getAttributeValue("value").trim();
                if (paramVersionStr == null) {
                    throw new CryptoException("do not exist element iv-param-version");
                }
                int paramVersion = Integer.parseInt(paramVersionStr, 10);
                sAlgorithm.setIvParamVersion(paramVersion);
            }
            symmetricalAlgs.put(name, sAlgorithm);
            symmetricalAlgs1.put(oid, sAlgorithm);
        }
        catch (NumberFormatException ex) {
            throw new CryptoException(ex);
        }
    }

    private static void parseSymmetricalAlgForSoft(Element element) throws CryptoException {
        Element e;
        SymmetricalAlgorithm sAlgorithm = new SymmetricalAlgorithm();
        String name = element.getAttributeValue("name").trim().toUpperCase();
        sAlgorithm.setName(name);
        String mechanismStr = element.getChild("key-gen-mechanism").getAttributeValue("value").trim();
        sAlgorithm.setMechanismString(mechanismStr);
        String algorithmStr = element.getChild("key-enc-algorithm").getAttributeValue("value").trim();
        sAlgorithm.setAlgorithmString(algorithmStr);
        String oid = element.getChild("oid").getAttributeValue("value").trim();
        sAlgorithm.setOId(oid);
        boolean hasIv = new Boolean(element.getChild("has-iv").getAttributeValue("value"));
        sAlgorithm.setIv(hasIv);
        if (hasIv && (e = element.getChild("iv-length")) != null) {
            int ivLength = Integer.parseInt(e.getAttributeValue("value", "8").trim());
            sAlgorithm.setIVLength(ivLength);
        }
        boolean isSeq = new Boolean(element.getChild("is-seq-param").getAttributeValue("value"));
        sAlgorithm.setSeq(isSeq);
        if (isSeq) {
            String paramVersionStr = element.getChild("iv-param-version").getAttributeValue("value").trim();
            if (paramVersionStr == null) {
                throw new CryptoException("do not exist element iv-param-version");
            }
            int paramVersion = Integer.parseInt(paramVersionStr, 10);
            sAlgorithm.setIvParamVersion(paramVersion);
        }
        symmetricalAlgs.put(name, sAlgorithm);
        symmetricalAlgs1.put(oid, sAlgorithm);
    }

    public static void initialize(String fileName, String mode) throws CryptoException {
        Document doc = AlgorithmUtil.createDocument(fileName);
        Element root = doc.getRootElement();
        if (!mode.equals(root.getAttributeValue("mode"))) {
            throw new CryptoException("Invalid algorithm-list mode: " + root.getAttributeValue("mode"));
        }
        Iterator digestIt = root.getChild("digest-algorithm-list").getChildren().iterator();
        while (digestIt.hasNext()) {
            Element element = (Element)digestIt.next();
            if (mode.equals("soft")) {
                AlgorithmUtil.parseDigestAlgForSoft(element);
                continue;
            }
            AlgorithmUtil.parseDigestAlgForHard(element);
        }
        Iterator symmetricalIt = root.getChild("symmetrical-algorithm-list").getChildren().iterator();
        while (symmetricalIt.hasNext()) {
            Element element = (Element)symmetricalIt.next();
            if (mode.equals("soft")) {
                AlgorithmUtil.parseSymmetricalAlgForSoft(element);
                continue;
            }
            AlgorithmUtil.parseSymmetricalAlgForHard(element);
        }
    }

    public static DigestAlgorithm getDigestAlgByName(String name) {
        return (DigestAlgorithm)digestAlgs.get(name);
    }

    public static DigestAlgorithm getDigestAlgByOId(String oid) {
        return (DigestAlgorithm)digestAlgs1.get(oid);
    }

    public static String getDigestAlgNameByOId(String oid) {
        DigestAlgorithm alg = (DigestAlgorithm)digestAlgs1.get(oid);
        if (alg != null) {
            return alg.getName();
        }
        return oid;
    }

    public static SymmetricalAlgorithm getSymmetricalAlgByName(String name) {
        return (SymmetricalAlgorithm)symmetricalAlgs.get(name);
    }

    public static SymmetricalAlgorithm getSymmetricalAlgByOId(String oid) {
        return (SymmetricalAlgorithm)symmetricalAlgs1.get(oid);
    }

    public static String getSymmetricalAlgNameByOId(String oid) {
        SymmetricalAlgorithm alg = (SymmetricalAlgorithm)symmetricalAlgs1.get(oid);
        if (alg != null) {
            return alg.getName();
        }
        return oid;
    }

    public static String getUnsymmetricalAlgNameByOid(String oid) {
        if (oid == null) {
            return null;
        }
        if (oid.equals("1.2.840.113549.1.1.1")) {
            return "RSA";
        }
        if (oid.equals("1.2.840.10040.4.1")) {
            return "DSA";
        }
        if (oid.equals("1.2.156.197.1.301") || oid.equals("1.2.156.197.1.301.1") || oid.equals("1.2.156.10197.1.301") || oid.equals("1.2.156.10197.1.301.1") || oid.equals("1.2.156.197.1.501") || oid.equals("1.2.156.10197.1.501")) {
            return "SM2";
        }
        return oid;
    }

    public static String[] getSymmetricalAlgNames() {
        String[] s = new String[symmetricalAlgs.size()];
        symmetricalAlgs.keySet().toArray(s);
        return s;
    }

    public static String[] getDigestAlgNames() {
        String[] s = new String[digestAlgs.size()];
        digestAlgs.keySet().toArray(s);
        return s;
    }

    public static void main(String[] args) throws Exception {
        AlgorithmUtil.initialize("config/algorithm.xml", "hard");
        System.out.println(AlgorithmUtil.getSymmetricalAlgByName("RC4").getType());
    }
}

