/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.cryptodevice;

import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.crypto.cryptodevice.CryptoDevice;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.RadomNumber;
import cn.com.infosec.oscca.sm2.SM2;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.security.rsa.RSAKeyPairGenerator;

public class FMCryptoCard
extends CryptoDevice {
    private static boolean connected;
    private static final int MAX_RSA_KEY_LENGTH = 256;
    private static final int MAX_RSA_KEY_P_LENGTH = 128;
    public static final int BOR_BACKUP = 1;
    public static final int BOR_RECOVER = 2;
    public static final int BOR_BACKUP_INIT = 3;
    public static final int BOR_RECOVER_INIT = 4;
    public static final int CHANGE_PIN_OPER = 1;
    public static final int CHANGE_PIN_ADMIN = 2;

    static {
        System.loadLibrary("CryptoDeviceUtil");
        connected = false;
    }

    public static native int closeDevice();

    public static native int deleteRSAKeyPair(int var0);

    public static native int deleteSM2KeyPair(int var0);

    public static native byte[] exportRSAKeyPair(int var0);

    public static native byte[] exportSM2KeyPair(int var0);

    public static native String getDeviceInfo();

    public static native int importRSAKeyPair(int var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6, byte[] var7, byte[] var8);

    public static native int importSM2KeyPair(int var0, byte[] var1, byte[] var2, byte[] var3);

    public static native int openDevice();

    public static native int userLogin(byte[] var0);

    public static native String getUserInfo();

    public static native int generateRSAKeyPair(int var0, int var1);

    public static native int generateECCKeyPair(int var0);

    public static native int[] backupOrRecover(int var0);

    public static native int setBackupFile(String var0);

    public static native String getBackupFile();

    public static native String getErrorInfo(int var0);

    public static native int changeUserPin(int var0, byte[] var1, byte[] var2);

    public int deleteKeyPair(int index, String alg) {
        if ("RSA".equals(alg)) {
            return FMCryptoCard.deleteRSAKeyPair(index);
        }
        if ("SM2".equals(alg)) {
            return FMCryptoCard.deleteSM2KeyPair(index);
        }
        return -1;
    }

    private static KeyPair generateKeyPair(KeySpec pubks, KeySpec priks, String keyType) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory kf = KeyFactory.getInstance(keyType);
        PublicKey pubk = kf.generatePublic(pubks);
        PrivateKey prik = kf.generatePrivate(priks);
        return new KeyPair(pubk, prik);
    }

    private static byte[] getRSAKeyPiece(byte[] bs, int pos, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(bs, pos, tmp, 0, length);
        if (tmp[0] < 0) {
            byte[] tmp2 = new byte[length + 1];
            tmp2[0] = 0;
            System.arraycopy(tmp, 0, tmp2, 1, length);
            tmp = tmp2;
        }
        return tmp;
    }

    private static byte[] getSM2KeyPiece(byte[] bs, int pos, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(bs, pos, tmp, 0, length);
        return tmp;
    }

    private static KeyPair parseRSAKeyPair(byte[] key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (key == null || key.length == 0) {
            return null;
        }
        int keyLength = key[key.length - 1] * 16;
        byte[] m = FMCryptoCard.getRSAKeyPiece(key, 0, keyLength);
        byte[] e = FMCryptoCard.getRSAKeyPiece(key, 256, keyLength);
        e = FMCryptoCard.trimAfter(e);
        RSAPublicKeySpec pubkSpec = new RSAPublicKeySpec(new BigInteger(m), new BigInteger(e));
        byte[] d = FMCryptoCard.getRSAKeyPiece(key, 512, keyLength);
        byte[] p = FMCryptoCard.getRSAKeyPiece(key, 768, keyLength / 2);
        byte[] q = FMCryptoCard.getRSAKeyPiece(key, 896, keyLength / 2);
        byte[] dp = FMCryptoCard.getRSAKeyPiece(key, 1024, keyLength / 2);
        byte[] dq = FMCryptoCard.getRSAKeyPiece(key, 1152, keyLength / 2);
        byte[] qInv = FMCryptoCard.getRSAKeyPiece(key, 1280, keyLength / 2);
        RSAPrivateCrtKeySpec prikSpec = new RSAPrivateCrtKeySpec(new BigInteger(m), new BigInteger(e), new BigInteger(d), new BigInteger(p), new BigInteger(q), new BigInteger(dp), new BigInteger(dq), new BigInteger(qInv));
        RSAKeyPairGenerator kpg = new RSAKeyPairGenerator();
        return FMCryptoCard.generateKeyPair(pubkSpec, prikSpec, "RSA");
    }

    private static KeyPair parseSM2KeyPair(byte[] key) {
        if (key == null || key.length == 0) {
            return null;
        }
        byte[] x = FMCryptoCard.getSM2KeyPiece(key, 0, 32);
        byte[] y = FMCryptoCard.getSM2KeyPiece(key, 32, 32);
        JCESM2PublicKey pubk = new JCESM2PublicKey();
        pubk.setX(x);
        pubk.setY(y);
        byte[] d = FMCryptoCard.getSM2KeyPiece(key, 64, 32);
        JCESM2PrivateKey prik = new JCESM2PrivateKey();
        prik.setD(d);
        return new KeyPair((PublicKey)pubk, (PrivateKey)prik);
    }

    private static byte[] trimAfter(byte[] bs) {
        int i = bs.length - 1;
        while (i >= 0) {
            if (bs[i] != 0) break;
            --i;
        }
        byte[] tmp = new byte[i + 1];
        System.arraycopy(bs, 0, tmp, 0, i + 1);
        return tmp;
    }

    public synchronized int connectDevice() {
        int result = 0;
        if (!connected && (result = FMCryptoCard.openDevice()) == 0) {
            connected = true;
        }
        return result;
    }

    public int disconnectDevice() {
        int result = 0;
        if (connected && (result = FMCryptoCard.closeDevice()) == 0) {
            connected = false;
        }
        return result;
    }

    public KeyPair exportKeyPair(int keyindex, String type) {
        if (!connected) {
            return null;
        }
        try {
            if (type.equals("RSA")) {
                byte[] key = FMCryptoCard.exportRSAKeyPair(keyindex);
                return FMCryptoCard.parseRSAKeyPair(key);
            }
            if (type.equals("SM2")) {
                byte[] key = FMCryptoCard.exportSM2KeyPair(keyindex);
                return FMCryptoCard.parseSM2KeyPair(key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public int generateKeyPair(int index, String alg, int strongthen) {
        KeyPair kp = null;
        if ("RSA".equals(alg)) {
            try {
                KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "INFOSEC");
                kpg.initialize(strongthen);
                kp = kpg.generateKeyPair();
            }
            catch (Exception e) {
                e.printStackTrace();
                return -1;
            }
        }
        if ("SM2".equals(alg)) {
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            byte[] D = new byte[32];
            SM2.genKeyPair(D, x, y);
            JCESM2PublicKey pubk = new JCESM2PublicKey();
            pubk.setX(x);
            pubk.setY(y);
            JCESM2PrivateKey prik = new JCESM2PrivateKey();
            prik.setD(D);
            kp = new KeyPair((PublicKey)pubk, (PrivateKey)prik);
        }
        if (kp != null) {
            return this.importKeyPair(index, kp);
        }
        return 0;
    }

    public int getMaxKeyNumber(String alg) {
        if ("RSA".equals(alg)) {
            return 768;
        }
        if ("SM2".equals(alg)) {
            return 64;
        }
        return 0;
    }

    public int importKeyPair(int index, KeyPair kp) {
        PublicKey pubk = kp.getPublic();
        if (pubk instanceof RSAPublicKey) {
            RSAPrivateCrtKey prik = (RSAPrivateCrtKey)kp.getPrivate();
            int mlength = prik.getModulus().bitLength() / 8;
            if (mlength % 2 != 0) {
                --mlength;
            }
            byte[] n = this.trimBefore(prik.getModulus().toByteArray(), mlength);
            byte[] e = prik.getPublicExponent().toByteArray();
            byte[] tmp = new byte[mlength];
            System.arraycopy(e, 0, tmp, 0, e.length);
            e = tmp;
            byte[] d = this.trimBefore(prik.getPrivateExponent().toByteArray(), mlength);
            byte[] p = this.trimBefore(prik.getPrimeP().toByteArray(), mlength / 2);
            byte[] q = this.trimBefore(prik.getPrimeQ().toByteArray(), mlength / 2);
            byte[] dp = this.trimBefore(prik.getPrimeExponentP().toByteArray(), mlength / 2);
            byte[] dq = this.trimBefore(prik.getPrimeExponentQ().toByteArray(), mlength / 2);
            byte[] qinv = this.trimBefore(prik.getCrtCoefficient().toByteArray(), mlength / 2);
            return FMCryptoCard.importRSAKeyPair(index, n, e, d, p, q, dp, dq, qinv);
        }
        if (pubk instanceof SM2PublicKey) {
            SM2PublicKey sm2Pubk = (SM2PublicKey)kp.getPublic();
            byte[] x = this.trimBefore(sm2Pubk.getX(), 32);
            byte[] y = this.trimBefore(sm2Pubk.getY(), 32);
            SM2PrivateKey prik = (SM2PrivateKey)kp.getPrivate();
            byte[] D = this.trimBefore(prik.getD(), 32);
            return FMCryptoCard.importSM2KeyPair(index, x, y, D);
        }
        if (pubk instanceof JCESM2PublicKey) {
            JCESM2PublicKey sm2Pubk = (JCESM2PublicKey)kp.getPublic();
            byte[] x = this.trimBefore(sm2Pubk.getX(), 32);
            byte[] y = this.trimBefore(sm2Pubk.getY(), 32);
            JCESM2PrivateKey prik = (JCESM2PrivateKey)kp.getPrivate();
            byte[] D = this.trimBefore(prik.getD(), 32);
            return FMCryptoCard.importSM2KeyPair(index, x, y, D);
        }
        return 0;
    }

    private byte[] trimBefore(byte[] bs, int length) {
        byte[] tmp = new byte[length];
        System.arraycopy(bs, bs.length - length, tmp, 0, length);
        return tmp;
    }

    public int[] getAllExistKeyIndex(String alg) {
        int maxSize = this.getMaxKeyNumber(alg);
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < maxSize) {
            if (this.exportKeyPair(i, alg) != null) {
                buf.append(i).append(" ");
            }
            ++i;
        }
        String ret = buf.toString().trim();
        if (ret.length() == 0) {
            return new int[0];
        }
        String[] pieces = ret.split(" ");
        int[] keys = new int[pieces.length];
        int i2 = 0;
        int length = keys.length;
        while (i2 < length) {
            keys[i2] = Integer.parseInt(pieces[i2]);
            ++i2;
        }
        return keys;
    }

    public int backup(String backupfile, String pwd) {
        FileOutputStream out = null;
        try {
            int[] sm2keys;
            out = new FileOutputStream(backupfile);
            byte[] rd = RadomNumber.getRandomBytes(16);
            SecretKey key = this.generateEncKey(pwd, rd);
            byte[] kenc = this.encryptKey(rd);
            byte[] keylength = this.int2Bytes(kenc.length);
            out.write(keylength);
            out.write(kenc);
            out.flush();
            Cipher c = Cipher.getInstance("RC4", "INFOSEC");
            c.init(1, key);
            int[] rsakeys = this.getAllExistKeyIndex("RSA");
            if (rsakeys != null && rsakeys.length > 0) {
                int i = 0;
                while (i < rsakeys.length) {
                    String keystr;
                    KeyPair kp = this.exportKeyPair(rsakeys[i], "RSA");
                    if (kp != null && (keystr = this.backupRSAKey(rsakeys[i], kp)) != null) {
                        byte[] encrypted = c.update(keystr.getBytes());
                        out.write(this.int2Bytes(encrypted.length));
                        out.write(encrypted);
                        out.flush();
                    }
                    ++i;
                }
            }
            if ((sm2keys = this.getAllExistKeyIndex("SM2")) != null && sm2keys.length > 0) {
                int i = 0;
                while (i < sm2keys.length) {
                    String keystr;
                    KeyPair kp = this.exportKeyPair(sm2keys[i], "SM2");
                    if (kp != null && (keystr = this.backupSM2Key(sm2keys[i], kp)) != null) {
                        byte[] encrypted = c.update(keystr.getBytes());
                        out.write(this.int2Bytes(encrypted.length));
                        out.write(encrypted);
                        out.flush();
                    }
                    ++i;
                }
            }
            byte[] encrypted = c.doFinal();
            out.write(encrypted);
            out.flush();
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        finally {
            try {
                out.close();
            }
            catch (Exception exception) {}
        }
    }

    private SecretKey generateEncKey(String pwd, byte[] random) {
        byte[] tmp = null;
        if (pwd != null) {
            tmp = new byte[pwd.length() + random.length];
            byte[] pwdbs = pwd.getBytes();
            System.arraycopy(pwdbs, 0, tmp, 0, pwdbs.length);
            System.arraycopy(random, 0, tmp, pwdbs.length, random.length);
        } else {
            tmp = random;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] keyData = md.digest(tmp);
            return new SecretKeySpec(keyData, "RC4");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] encryptKey(byte[] keydata) {
        byte[] salt = RadomNumber.getRandomBytes(keydata.length);
        byte[] enc = new byte[keydata.length * 2];
        int i = 0;
        while (i < keydata.length) {
            enc[i * 2] = keydata[i];
            enc[i * 2 + 1] = salt[i];
            ++i;
        }
        return enc;
    }

    private String backupRSAKey(int index, KeyPair kp) {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("RSA:").append(index).append(":");
            RSAPublicKey pubk = (RSAPublicKey)kp.getPublic();
            buf.append(Base64.encode(pubk.getEncoded())).append(":");
            RSAPrivateKey prik = (RSAPrivateKey)kp.getPrivate();
            buf.append(Base64.encode(prik.getEncoded()));
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String backupSM2Key(int index, KeyPair kp) {
        try {
            SM2PrivateKey prik;
            SM2PublicKey pubk;
            StringBuffer buf = new StringBuffer();
            buf.append("SM2:").append(index).append(":");
            byte[] x = null;
            byte[] y = null;
            byte[] d = null;
            if (kp.getPublic() instanceof SM2PublicKey) {
                pubk = (SM2PublicKey)kp.getPublic();
                x = pubk.getX();
                y = pubk.getY();
                prik = (SM2PrivateKey)kp.getPrivate();
                d = prik.getD();
            }
            if (kp.getPublic() instanceof JCESM2PublicKey) {
                pubk = (JCESM2PublicKey)kp.getPublic();
                x = pubk.getX();
                y = pubk.getY();
                prik = (JCESM2PrivateKey)kp.getPrivate();
                d = prik.getD();
            }
            buf.append(Base64.encode(x)).append(":");
            buf.append(Base64.encode(y)).append(":");
            buf.append(Base64.encode(d));
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int recover(String backupfile, String pwd) {
        byte[] lengthbs = new byte[4];
        FileInputStream in = null;
        try {
            in = new FileInputStream(backupfile);
            SecretKey enckey = this.recoverEncKey(in, pwd);
            Cipher c = Cipher.getInstance("RC4", "INFOSEC");
            c.init(2, enckey);
            while (in.read(lengthbs) == 4) {
                int ret;
                CryptoDevice.DeviceKeyPair dkp;
                int keylength = CryptoUtil.bytes2Int(lengthbs, false);
                byte[] enckeyinfo = new byte[keylength];
                in.read(enckeyinfo);
                String keyinfo = new String(c.update(enckeyinfo));
                if (keyinfo.startsWith("RSA")) {
                    dkp = this.recoverRSAKey(keyinfo);
                    if (dkp == null || (ret = this.importKeyPair(dkp.keyIndex, dkp.keyPair)) >= 0) continue;
                    System.out.println("Import RSA key[" + dkp.keyIndex + "] failed:" + ret);
                    int n = ret;
                    return n;
                }
                if (keyinfo.startsWith("SM2")) {
                    dkp = this.recoverSM2Key(keyinfo);
                    if (dkp == null || (ret = this.importKeyPair(dkp.keyIndex, dkp.keyPair)) >= 0) continue;
                    System.out.println("Import SM2 key[" + dkp.keyIndex + "] failed:" + ret);
                    int n = ret;
                    return n;
                }
                System.out.println("Recover crypto card error: unknown key type , wrong password or backup file damaged.");
                return -2;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private CryptoDevice.DeviceKeyPair recoverSM2Key(String keyinfo) {
        String[] pieces = keyinfo.split(":");
        if (pieces.length != 5) {
            return null;
        }
        CryptoDevice.DeviceKeyPair dkp = new CryptoDevice.DeviceKeyPair();
        dkp.keyType = pieces[0];
        dkp.keyIndex = Integer.parseInt(pieces[1]);
        try {
            KeyPair kp;
            byte[] x = Base64.decode(pieces[2]);
            byte[] y = Base64.decode(pieces[3]);
            JCESM2PublicKey pubk = new JCESM2PublicKey();
            pubk.setX(x);
            pubk.setY(y);
            byte[] d = Base64.decode(pieces[4]);
            JCESM2PrivateKey prik = new JCESM2PrivateKey();
            prik.setD(d);
            dkp.keyPair = kp = new KeyPair((PublicKey)pubk, (PrivateKey)prik);
            return dkp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private CryptoDevice.DeviceKeyPair recoverRSAKey(String keyinfo) {
        String[] pieces = keyinfo.split(":");
        if (pieces.length != 4) {
            return null;
        }
        CryptoDevice.DeviceKeyPair dkp = new CryptoDevice.DeviceKeyPair();
        dkp.keyType = pieces[0];
        dkp.keyIndex = Integer.parseInt(pieces[1]);
        try {
            KeyPair kp;
            KeyFactory kf = KeyFactory.getInstance("RSA");
            byte[] pubkEncoded = Base64.decode(pieces[2]);
            X509EncodedKeySpec eks = new X509EncodedKeySpec(pubkEncoded);
            PublicKey pubk = kf.generatePublic(eks);
            byte[] prikEncoded = Base64.decode(pieces[3]);
            PKCS8EncodedKeySpec p8ks = new PKCS8EncodedKeySpec(prikEncoded);
            PrivateKey prik = kf.generatePrivate(p8ks);
            dkp.keyPair = kp = new KeyPair(pubk, prik);
            return dkp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private SecretKey recoverEncKey(InputStream in, String pwd) {
        try {
            byte[] lbs = new byte[4];
            in.read(lbs);
            int keylength = CryptoUtil.bytes2Int(lbs, false);
            byte[] tmp = new byte[keylength];
            in.read(tmp);
            byte[] rd = new byte[tmp.length / 2];
            int i = 0;
            while (i < rd.length) {
                rd[i] = tmp[i * 2];
                ++i;
            }
            return this.generateEncKey(pwd, rd);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] int2Bytes(int i) {
        byte[] tmp = CryptoUtil.int2Bytes(i);
        byte[] bs = new byte[4];
        System.arraycopy(tmp, 0, bs, 4 - tmp.length, tmp.length);
        return bs;
    }

    public static void main(String[] args) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        FMCryptoCard cc = new FMCryptoCard();
        cc.connectDevice();
        FMCryptoCard.setBackupFile("/tmp/fmbackupfile.txt");
        System.out.println(FMCryptoCard.getBackupFile());
    }
}

