/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.asn1.x509;

import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.netsign.asn1.x509.Extension;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import java.io.IOException;
import java.util.ArrayList;

public class DERObjectGenerate {
    public byte[] generateExtensions(ArrayList extensions) {
        byte[] es = new byte[]{};
        int i = 0;
        int size = extensions.size();
        while (i < size) {
            byte[] e = this.generateExtension((Extension)extensions.get(i));
            es = CryptoUtil.connect(es, e);
            ++i;
        }
        es = CryptoUtil.generateDERCode(48, es);
        return CryptoUtil.generateDERCode(163, es);
    }

    private byte[] generateExtension(Extension e) {
        byte[] all = CryptoUtil.oid2ASN1(e.getOid());
        all = CryptoUtil.generateDERCode(6, all);
        if (e.isCritical()) {
            all = CryptoUtil.connect(all, CryptoUtil.DERTRUE);
        }
        all = CryptoUtil.connect(all, e.getValue());
        return CryptoUtil.generateDERCode(48, all);
    }

    public byte[] generateSignatureAlg(String oidstr) {
        byte[] oid = CryptoUtil.oid2ASN1(oidstr);
        oid = CryptoUtil.generateDERCode(6, oid);
        byte[] alg = CryptoUtil.connect(oid, CryptoUtil.DERNULL);
        return CryptoUtil.generateDERCode(48, alg);
    }

    public byte[] generateDN(String dn) throws IOException {
        X509Name name = new X509Name(dn);
        return name.getEncoded();
    }
}

